/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
extends zzbej {
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new zzl();
    private final List<LatLng> zzitd;
    private float zzisi = 10.0f;
    private int mColor = -16777216;
    private float zzisb = 0.0f;
    private boolean zzisc = true;
    private boolean zzitf = false;
    private boolean zzisd = false;
    @NonNull
    private Cap zziti = new ButtCap();
    @NonNull
    private Cap zzitj = new ButtCap();
    private int zzitk = 0;
    @Nullable
    private List<PatternItem> zzitl = null;

    public PolylineOptions() {
        this.zzitd = new ArrayList<LatLng>();
    }

    PolylineOptions(List list, float f, int n, float f2, boolean bl, boolean bl2, boolean bl3, @Nullable Cap cap, @Nullable Cap cap2, int n2, @Nullable List<PatternItem> list2) {
        this.zzitd = list;
        this.zzisi = f;
        this.mColor = n;
        this.zzisb = f2;
        this.zzisc = bl;
        this.zzitf = bl2;
        this.zzisd = bl3;
        if (cap != null) {
            this.zziti = cap;
        }
        if (cap2 != null) {
            this.zzitj = cap2;
        }
        this.zzitk = n2;
        this.zzitl = list2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolylineOptions polylineOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)2, polylineOptions.getPoints(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (float)polylineOptions.getWidth());
        zzbem.zzc((Parcel)parcel2, (int)4, (int)polylineOptions.getColor());
        zzbem.zza((Parcel)parcel2, (int)5, (float)polylineOptions.getZIndex());
        zzbem.zza((Parcel)parcel2, (int)6, (boolean)polylineOptions.isVisible());
        zzbem.zza((Parcel)parcel2, (int)7, (boolean)polylineOptions.isGeodesic());
        zzbem.zza((Parcel)parcel2, (int)8, (boolean)polylineOptions.isClickable());
        zzbem.zza((Parcel)parcel2, (int)9, (Parcelable)polylineOptions.getStartCap(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)10, (Parcelable)polylineOptions.getEndCap(), (int)n, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)11, (int)polylineOptions.getJointType());
        zzbem.zzc((Parcel)parcel2, (int)12, polylineOptions.getPattern(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolylineOptions add(LatLng latLng) {
        this.zzitd.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.zzitd.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzitd.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f) {
        this.zzisi = f;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.mColor = n;
        return this;
    }

    public final PolylineOptions startCap(@NonNull Cap cap) {
        this.zziti = (Cap)((Object)zzbq.checkNotNull((Object)((Object)cap), (Object)"startCap must not be null"));
        return this;
    }

    public final PolylineOptions endCap(@NonNull Cap cap) {
        this.zzitj = (Cap)((Object)zzbq.checkNotNull((Object)((Object)cap), (Object)"endCap must not be null"));
        return this;
    }

    public final PolylineOptions jointType(int n) {
        this.zzitk = n;
        return this;
    }

    public final PolylineOptions pattern(@Nullable List<PatternItem> list) {
        this.zzitl = list;
        return this;
    }

    public final PolylineOptions zIndex(float f) {
        this.zzisb = f;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.zzisc = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.zzitf = bl;
        return this;
    }

    public final PolylineOptions clickable(boolean bl) {
        this.zzisd = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzitd;
    }

    public final float getWidth() {
        return this.zzisi;
    }

    public final int getColor() {
        return this.mColor;
    }

    @NonNull
    public final Cap getStartCap() {
        return this.zziti;
    }

    @NonNull
    public final Cap getEndCap() {
        return this.zzitj;
    }

    public final int getJointType() {
        return this.zzitk;
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        return this.zzitl;
    }

    public final float getZIndex() {
        return this.zzisb;
    }

    public final boolean isVisible() {
        return this.zzisc;
    }

    public final boolean isGeodesic() {
        return this.zzitf;
    }

    public final boolean isClickable() {
        return this.zzisd;
    }
}

