/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zzbck {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zziis;
    private LatLng zziit;
    private float zziiu;
    private float zziiv;
    private LatLngBounds zzies;
    private float zziii;
    private float zziin;
    private boolean zziio = true;
    private float zziiw = 0.0f;
    private float zziix = 0.5f;
    private float zziiy = 0.5f;
    private boolean zziip = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zziis = new BitmapDescriptor(IObjectWrapper.zza.zzao((IBinder)iBinder));
        this.zziit = latLng;
        this.zziiu = f;
        this.zziiv = f2;
        this.zzies = latLngBounds;
        this.zziii = f3;
        this.zziin = f4;
        this.zziio = bl;
        this.zziiw = f5;
        this.zziix = f6;
        this.zziiy = f7;
        this.zziip = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zziis.zzatm().asBinder(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        zzbcn.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        zzbcn.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        zzbcn.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        zzbcn.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        zzbcn.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        zzbcn.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        zzbcn.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        zzbcn.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbp.zzb((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zziis = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zziix = f;
        this.zziiy = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbp.zza((this.zzies == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbp.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbp.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbp.zza((this.zzies == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbp.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbp.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbp.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zziit = latLng;
        this.zziiu = f;
        this.zziiv = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zziit);
        zzbp.zza((this.zziit == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzies = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zziii = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zziin = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zziio = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbp.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zziiw = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zziip = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zziis;
    }

    public final LatLng getLocation() {
        return this.zziit;
    }

    public final float getWidth() {
        return this.zziiu;
    }

    public final float getHeight() {
        return this.zziiv;
    }

    public final LatLngBounds getBounds() {
        return this.zzies;
    }

    public final float getBearing() {
        return this.zziii;
    }

    public final float getZIndex() {
        return this.zziin;
    }

    public final float getTransparency() {
        return this.zziiw;
    }

    public final float getAnchorU() {
        return this.zziix;
    }

    public final float getAnchorV() {
        return this.zziiy;
    }

    public final boolean isVisible() {
        return this.zziio;
    }

    public final boolean isClickable() {
        return this.zziip;
    }
}

