/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzbw;
import com.google.android.gms.maps.internal.zzbx;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzab;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzbmu;

    public MapView(Context context) {
        super(context);
        this.zzbmu = new zzb((ViewGroup)this, context, null);
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbmu = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbmu = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzbmu = new zzb((ViewGroup)this, context, googleMapOptions);
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.zzbmu.onCreate(bundle);
        if (this.zzbmu.zztx() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzbmu.onResume();
    }

    public final void onPause() {
        this.zzbmu.onPause();
    }

    public final void onStart() {
        this.zzbmu.onStart();
    }

    public final void onStop() {
        this.zzbmu.onStop();
    }

    public final void onDestroy() {
        this.zzbmu.onDestroy();
    }

    public final void onLowMemory() {
        this.zzbmu.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzbmu.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbo.zzcz((String)"getMapAsync() must be called on the main thread");
        this.zzbmu.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbo.zzcz((String)"onEnterAmbient() must be called on the main thread");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzbmu;
        if (zzb2.zztx() != null) {
            ((zza)zzb2.zztx()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbo.zzcz((String)"onExitAmbient() must be called on the main thread");
        zzb zzb2 = this.zzbmu;
        if (zzb2.zztx() != null) {
            ((zza)zzb2.zztx()).onExitAmbient();
        }
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzbmy;
        private final Context zzbmz;
        private zzo<zza> zzbms;
        private final GoogleMapOptions zzbmA;
        private final List<OnMapReadyCallback> zzbmt = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzbmy = viewGroup;
            this.zzbmz = context;
            this.zzbmA = googleMapOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzbms = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzbms != null && zzb2.zztx() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zzbmz);
                    IMapViewDelegate iMapViewDelegate = zzbx.zzbh(zzb2.zzbmz).zza(zzn.zzw((Object)zzb2.zzbmz), zzb2.zzbmA);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    zzb2.zzbms.zza((LifecycleDelegate)new zza(zzb2.zzbmy, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : zzb2.zzbmt) {
                        ((zza)zzb2.zztx()).getMapAsync(onMapReadyCallback);
                    }
                    zzb2.zzbmt.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zztx() != null) {
                ((zza)this.zztx()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzbmt.add(onMapReadyCallback);
        }
    }

    static final class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzbmv;
        private final IMapViewDelegate zzbmw;
        private View zzbmx;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzbmw = (IMapViewDelegate)zzbo.zzu((Object)iMapViewDelegate);
            this.zzbmv = (ViewGroup)zzbo.zzu((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                this.zzbmw.onCreate(bundle2);
                zzbw.zzd(bundle2, bundle);
                this.zzbmx = (View)zzn.zzE((IObjectWrapper)this.zzbmw.getView());
                this.zzbmv.removeAllViews();
                this.zzbmv.addView(this.zzbmx);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public final void onStart() {
            try {
                this.zzbmw.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzbmw.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzbmw.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzbmw.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzbmw.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzbmw.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                this.zzbmw.onSaveInstanceState(bundle2);
                zzbw.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzbmw.getMapAsync(new zzab(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                this.zzbmw.onEnterAmbient(bundle2);
                zzbw.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zzbmw.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

