/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzz;

public final class GoogleMapOptions
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzz();
    private Boolean zzbmd;
    private Boolean zzbme;
    private int zzbmf = -1;
    private CameraPosition zzbmg;
    private Boolean zzbmh;
    private Boolean zzbmi;
    private Boolean zzbmj;
    private Boolean zzbmk;
    private Boolean zzbml;
    private Boolean zzbmm;
    private Boolean zzbmn;
    private Boolean zzbmo;
    private Boolean zzbmp;
    private Float zzbmq = null;
    private Float zzbmr = null;
    private LatLngBounds zzbms = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzbmd = zza.zza(by);
        this.zzbme = zza.zza(by2);
        this.zzbmf = n;
        this.zzbmg = cameraPosition;
        this.zzbmh = zza.zza(by3);
        this.zzbmi = zza.zza(by4);
        this.zzbmj = zza.zza(by5);
        this.zzbmk = zza.zza(by6);
        this.zzbml = zza.zza(by7);
        this.zzbmm = zza.zza(by8);
        this.zzbmn = zza.zza(by9);
        this.zzbmo = zza.zza(by10);
        this.zzbmp = zza.zza(by11);
        this.zzbmq = f;
        this.zzbmr = f2;
        this.zzbms = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (byte)zza.zzb(googleMapOptions.zzbmd));
        zzd.zza((Parcel)parcel2, (int)3, (byte)zza.zzb(googleMapOptions.zzbme));
        zzd.zzc((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (byte)zza.zzb(googleMapOptions.zzbmh));
        zzd.zza((Parcel)parcel2, (int)7, (byte)zza.zzb(googleMapOptions.zzbmi));
        zzd.zza((Parcel)parcel2, (int)8, (byte)zza.zzb(googleMapOptions.zzbmj));
        zzd.zza((Parcel)parcel2, (int)9, (byte)zza.zzb(googleMapOptions.zzbmk));
        zzd.zza((Parcel)parcel2, (int)10, (byte)zza.zzb(googleMapOptions.zzbml));
        zzd.zza((Parcel)parcel2, (int)11, (byte)zza.zzb(googleMapOptions.zzbmm));
        zzd.zza((Parcel)parcel2, (int)12, (byte)zza.zzb(googleMapOptions.zzbmn));
        zzd.zza((Parcel)parcel2, (int)14, (byte)zza.zzb(googleMapOptions.zzbmo));
        zzd.zza((Parcel)parcel2, (int)15, (byte)zza.zzb(googleMapOptions.zzbmp));
        zzd.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzbmd = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzbme = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.zzbmf = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzbmg = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzbmh = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzbmi = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzbmj = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzbmk = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzbml = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzbmm = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzbmn = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzbmo = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzbmp = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zzbmq = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzbmr = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzbms = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzbmd;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzbme;
    }

    public final int getMapType() {
        return this.zzbmf;
    }

    public final CameraPosition getCamera() {
        return this.zzbmg;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zzbmh;
    }

    public final Boolean getCompassEnabled() {
        return this.zzbmi;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzbmj;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzbmk;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzbml;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzbmm;
    }

    public final Boolean getLiteMode() {
        return this.zzbmn;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzbmo;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzbmp;
    }

    public final Float getMinZoomPreference() {
        return this.zzbmq;
    }

    public final Float getMaxZoomPreference() {
        return this.zzbmr;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzbms;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbh.zzt((Object)((Object)this)).zzg("MapType", (Object)this.zzbmf).zzg("LiteMode", (Object)this.zzbmn).zzg("Camera", (Object)this.zzbmg).zzg("CompassEnabled", (Object)this.zzbmi).zzg("ZoomControlsEnabled", (Object)this.zzbmh).zzg("ScrollGesturesEnabled", (Object)this.zzbmj).zzg("ZoomGesturesEnabled", (Object)this.zzbmk).zzg("TiltGesturesEnabled", (Object)this.zzbml).zzg("RotateGesturesEnabled", (Object)this.zzbmm).zzg("MapToolbarEnabled", (Object)this.zzbmo).zzg("AmbientEnabled", (Object)this.zzbmp).zzg("MinZoomPreference", (Object)this.zzbmq).zzg("MaxZoomPreference", (Object)this.zzbmr).zzg("LatLngBoundsForCameraTarget", (Object)this.zzbms).zzg("ZOrderOnTop", (Object)this.zzbmd).zzg("UseViewLifecycleInFragment", (Object)this.zzbme).toString();
    }
}

