/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zza;

public final class CameraPosition
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<CameraPosition> CREATOR = new zza();
    public final LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    public CameraPosition(LatLng latLng, float f, float f2, float f3) {
        zzac.zzb((Object)((Object)latLng), (Object)"null camera target");
        zzac.zzb((0.0f <= f2 && f2 <= 90.0f ? 1 : 0) != 0, (String)"Tilt needs to be between 0 and 90 inclusive: %s", (Object[])new Object[]{Float.valueOf(f2)});
        this.target = latLng;
        this.zoom = f;
        this.tilt = f2 + 0.0f;
        this.bearing = ((double)f3 <= 0.0 ? f3 % 360.0f + 360.0f : f3) % 360.0f;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.target, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    public static final CameraPosition fromLatLngZoom(LatLng latLng, float f) {
        return new CameraPosition(latLng, f, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition cameraPosition) {
        return new Builder(cameraPosition);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)((Object)object);
        return this.target.equals((Object)cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("target", (Object)this.target).zzg("zoom", (Object)Float.valueOf(this.zoom)).zzg("tilt", (Object)Float.valueOf(this.tilt)).zzg("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static CameraPosition createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        float f = 0.0f;
        float f2 = 0.0f;
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLat)) {
            f = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLat, 0.0f);
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLng)) {
            f2 = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLng, 0.0f);
        }
        LatLng latLng = new LatLng(f, f2);
        Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraZoom)) {
            builder.zoom(typedArray.getFloat(R.styleable.MapAttrs_cameraZoom, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraBearing)) {
            builder.bearing(typedArray.getFloat(R.styleable.MapAttrs_cameraBearing, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTilt)) {
            builder.tilt(typedArray.getFloat(R.styleable.MapAttrs_cameraTilt, 0.0f));
        }
        return builder.build();
    }

    public static final class Builder {
        private LatLng zzboZ;
        private float zzbpa;
        private float zzbpb;
        private float zzbpc;

        public Builder() {
        }

        public Builder(CameraPosition cameraPosition) {
            CameraPosition cameraPosition2 = cameraPosition;
            this.zzboZ = cameraPosition2.target;
            this.zzbpa = cameraPosition2.zoom;
            this.zzbpb = cameraPosition2.tilt;
            this.zzbpc = cameraPosition2.bearing;
        }

        public Builder target(LatLng latLng) {
            this.zzboZ = latLng;
            return this;
        }

        public Builder zoom(float f) {
            this.zzbpa = f;
            return this;
        }

        public Builder tilt(float f) {
            this.zzbpb = f;
            return this;
        }

        public Builder bearing(float f) {
            this.zzbpc = f;
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.zzboZ, this.zzbpa, this.zzbpb, this.zzbpc);
        }
    }
}

