/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Bitmap;
import android.location.Location;
import android.os.RemoteException;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.zzaa;
import com.google.android.gms.maps.internal.zzag;
import com.google.android.gms.maps.internal.zzb;
import com.google.android.gms.maps.internal.zzd;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.internal.zzg;
import com.google.android.gms.maps.internal.zzh;
import com.google.android.gms.maps.internal.zzi;
import com.google.android.gms.maps.internal.zzj;
import com.google.android.gms.maps.internal.zzk;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzn;
import com.google.android.gms.maps.internal.zzo;
import com.google.android.gms.maps.internal.zzp;
import com.google.android.gms.maps.internal.zzq;
import com.google.android.gms.maps.internal.zzr;
import com.google.android.gms.maps.internal.zzs;
import com.google.android.gms.maps.internal.zzu;
import com.google.android.gms.maps.internal.zzv;
import com.google.android.gms.maps.internal.zzw;
import com.google.android.gms.maps.internal.zzx;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.internal.zzz;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PointOfInterest;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.IPolylineDelegate;
import com.google.android.gms.maps.model.internal.zzb;
import com.google.android.gms.maps.model.internal.zzc;
import com.google.android.gms.maps.model.internal.zzd;
import com.google.android.gms.maps.model.internal.zzf;
import com.google.android.gms.maps.model.internal.zzg;
import com.google.android.gms.maps.model.internal.zzh;

public final class GoogleMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_TERRAIN = 3;
    public static final int MAP_TYPE_HYBRID = 4;
    private final IGoogleMapDelegate zzbnv;
    private UiSettings zzbnw;

    protected GoogleMap(IGoogleMapDelegate iGoogleMapDelegate) {
        this.zzbnv = (IGoogleMapDelegate)zzac.zzw((Object)iGoogleMapDelegate);
    }

    public final CameraPosition getCameraPosition() {
        try {
            return this.zzbnv.getCameraPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMaxZoomLevel() {
        try {
            return this.zzbnv.getMaxZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMinZoomLevel() {
        try {
            return this.zzbnv.getMinZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void moveCamera(CameraUpdate cameraUpdate) {
        try {
            this.zzbnv.moveCamera(cameraUpdate.zzJm());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate) {
        try {
            this.zzbnv.animateCamera(cameraUpdate.zzJm());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        try {
            this.zzbnv.animateCameraWithCallback(cameraUpdate.zzJm(), cancelableCallback == null ? null : new zza(cancelableCallback));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, int n, CancelableCallback cancelableCallback) {
        try {
            this.zzbnv.animateCameraWithDurationAndCallback(cameraUpdate.zzJm(), n, cancelableCallback == null ? null : new zza(cancelableCallback));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void stopAnimation() {
        try {
            this.zzbnv.stopAnimation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polyline addPolyline(PolylineOptions polylineOptions) {
        try {
            return new Polyline(this.zzbnv.addPolyline(polylineOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polygon addPolygon(PolygonOptions polygonOptions) {
        try {
            return new Polygon(this.zzbnv.addPolygon(polygonOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Circle addCircle(CircleOptions circleOptions) {
        try {
            return new Circle(this.zzbnv.addCircle(circleOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Marker addMarker(MarkerOptions markerOptions) {
        try {
            zzf zzf2 = this.zzbnv.addMarker(markerOptions);
            if (zzf2 != null) {
                return new Marker(zzf2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        try {
            zzc zzc2 = this.zzbnv.addGroundOverlay(groundOverlayOptions);
            if (zzc2 != null) {
                return new GroundOverlay(zzc2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final TileOverlay addTileOverlay(TileOverlayOptions tileOverlayOptions) {
        try {
            zzh zzh2 = this.zzbnv.addTileOverlay(tileOverlayOptions);
            if (zzh2 != null) {
                return new TileOverlay(zzh2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void clear() {
        try {
            this.zzbnv.clear();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public IndoorBuilding getFocusedBuilding() {
        try {
            zzd zzd2 = this.zzbnv.getFocusedBuilding();
            if (zzd2 != null) {
                return new IndoorBuilding(zzd2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnIndoorStateChangeListener(final OnIndoorStateChangeListener onIndoorStateChangeListener) {
        try {
            if (onIndoorStateChangeListener == null) {
                this.zzbnv.setOnIndoorStateChangeListener(null);
            } else {
                this.zzbnv.setOnIndoorStateChangeListener(new zzl.zza(this){

                    @Override
                    public void onIndoorBuildingFocused() {
                        onIndoorStateChangeListener.onIndoorBuildingFocused();
                    }

                    @Override
                    public void zza(zzd zzd2) {
                        onIndoorStateChangeListener.onIndoorLevelActivated(new IndoorBuilding(zzd2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getMapType() {
        try {
            return this.zzbnv.getMapType();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMapType(int n) {
        try {
            this.zzbnv.setMapType(n);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isTrafficEnabled() {
        try {
            return this.zzbnv.isTrafficEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTrafficEnabled(boolean bl) {
        try {
            this.zzbnv.setTrafficEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isIndoorEnabled() {
        try {
            return this.zzbnv.isIndoorEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean setIndoorEnabled(boolean bl) {
        try {
            return this.zzbnv.setIndoorEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isBuildingsEnabled() {
        try {
            return this.zzbnv.isBuildingsEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setBuildingsEnabled(boolean bl) {
        try {
            this.zzbnv.setBuildingsEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isMyLocationEnabled() {
        try {
            return this.zzbnv.isMyLocationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final void setMyLocationEnabled(boolean bl) {
        try {
            this.zzbnv.setMyLocationEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final Location getMyLocation() {
        try {
            return this.zzbnv.getMyLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setLocationSource(final LocationSource locationSource) {
        try {
            if (locationSource == null) {
                this.zzbnv.setLocationSource(null);
            } else {
                this.zzbnv.setLocationSource(new ILocationSourceDelegate.zza(this){

                    @Override
                    public void activate(final zzp zzp2) {
                        locationSource.activate(new LocationSource.OnLocationChangedListener(this){

                            @Override
                            public void onLocationChanged(Location location) {
                                try {
                                    zzp2.zze(location);
                                }
                                catch (RemoteException remoteException) {
                                    throw new RuntimeRemoteException(remoteException);
                                }
                            }
                        });
                    }

                    @Override
                    public void deactivate() {
                        locationSource.deactivate();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final UiSettings getUiSettings() {
        try {
            if (this.zzbnw == null) {
                this.zzbnw = new UiSettings(this.zzbnv.getUiSettings());
            }
            return this.zzbnw;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Projection getProjection() {
        try {
            return new Projection(this.zzbnv.getProjection());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnCameraChangeListener(final OnCameraChangeListener onCameraChangeListener) {
        try {
            if (onCameraChangeListener == null) {
                this.zzbnv.setOnCameraChangeListener(null);
            } else {
                this.zzbnv.setOnCameraChangeListener(new zze.zza(this){

                    @Override
                    public void onCameraChange(CameraPosition cameraPosition) {
                        onCameraChangeListener.onCameraChange(cameraPosition);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveStartedListener(final OnCameraMoveStartedListener onCameraMoveStartedListener) {
        try {
            if (onCameraMoveStartedListener == null) {
                this.zzbnv.setOnCameraMoveStartedListener(null);
            } else {
                this.zzbnv.setOnCameraMoveStartedListener(new zzi.zza(this){

                    @Override
                    public void onCameraMoveStarted(int n) {
                        onCameraMoveStartedListener.onCameraMoveStarted(n);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveListener(final OnCameraMoveListener onCameraMoveListener) {
        try {
            if (onCameraMoveListener == null) {
                this.zzbnv.setOnCameraMoveListener(null);
            } else {
                this.zzbnv.setOnCameraMoveListener(new zzh.zza(this){

                    @Override
                    public void onCameraMove() {
                        onCameraMoveListener.onCameraMove();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveCanceledListener(final OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        try {
            if (onCameraMoveCanceledListener == null) {
                this.zzbnv.setOnCameraMoveCanceledListener(null);
            } else {
                this.zzbnv.setOnCameraMoveCanceledListener(new zzg.zza(this){

                    @Override
                    public void onCameraMoveCanceled() {
                        onCameraMoveCanceledListener.onCameraMoveCanceled();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraIdleListener(final OnCameraIdleListener onCameraIdleListener) {
        try {
            if (onCameraIdleListener == null) {
                this.zzbnv.setOnCameraIdleListener(null);
            } else {
                this.zzbnv.setOnCameraIdleListener(new zzf.zza(this){

                    @Override
                    public void onCameraIdle() {
                        onCameraIdleListener.onCameraIdle();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapClickListener(final OnMapClickListener onMapClickListener) {
        try {
            if (onMapClickListener == null) {
                this.zzbnv.setOnMapClickListener(null);
            } else {
                this.zzbnv.setOnMapClickListener(new zzq.zza(this){

                    @Override
                    public void onMapClick(LatLng latLng) {
                        onMapClickListener.onMapClick(latLng);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapLongClickListener(final OnMapLongClickListener onMapLongClickListener) {
        try {
            if (onMapLongClickListener == null) {
                this.zzbnv.setOnMapLongClickListener(null);
            } else {
                this.zzbnv.setOnMapLongClickListener(new zzs.zza(this){

                    @Override
                    public void onMapLongClick(LatLng latLng) {
                        onMapLongClickListener.onMapLongClick(latLng);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerClickListener(final OnMarkerClickListener onMarkerClickListener) {
        try {
            if (onMarkerClickListener == null) {
                this.zzbnv.setOnMarkerClickListener(null);
            } else {
                this.zzbnv.setOnMarkerClickListener(new zzu.zza(this){

                    @Override
                    public boolean zza(zzf zzf2) {
                        return onMarkerClickListener.onMarkerClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerDragListener(final OnMarkerDragListener onMarkerDragListener) {
        try {
            if (onMarkerDragListener == null) {
                this.zzbnv.setOnMarkerDragListener(null);
            } else {
                this.zzbnv.setOnMarkerDragListener(new zzv.zza(this){

                    @Override
                    public void zzb(zzf zzf2) {
                        onMarkerDragListener.onMarkerDragStart(new Marker(zzf2));
                    }

                    @Override
                    public void zzc(zzf zzf2) {
                        onMarkerDragListener.onMarkerDragEnd(new Marker(zzf2));
                    }

                    @Override
                    public void zzd(zzf zzf2) {
                        onMarkerDragListener.onMarkerDrag(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowClickListener(final OnInfoWindowClickListener onInfoWindowClickListener) {
        try {
            if (onInfoWindowClickListener == null) {
                this.zzbnv.setOnInfoWindowClickListener(null);
            } else {
                this.zzbnv.setOnInfoWindowClickListener(new zzm.zza(this){

                    @Override
                    public void zze(zzf zzf2) {
                        onInfoWindowClickListener.onInfoWindowClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowLongClickListener(final OnInfoWindowLongClickListener onInfoWindowLongClickListener) {
        try {
            if (onInfoWindowLongClickListener == null) {
                this.zzbnv.setOnInfoWindowLongClickListener(null);
            } else {
                this.zzbnv.setOnInfoWindowLongClickListener(new zzo.zza(this){

                    @Override
                    public void zzf(zzf zzf2) {
                        onInfoWindowLongClickListener.onInfoWindowLongClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowCloseListener(final OnInfoWindowCloseListener onInfoWindowCloseListener) {
        try {
            if (onInfoWindowCloseListener == null) {
                this.zzbnv.setOnInfoWindowCloseListener(null);
            } else {
                this.zzbnv.setOnInfoWindowCloseListener(new zzn.zza(this){

                    @Override
                    public void zzg(zzf zzf2) {
                        onInfoWindowCloseListener.onInfoWindowClose(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setInfoWindowAdapter(final InfoWindowAdapter infoWindowAdapter) {
        try {
            if (infoWindowAdapter == null) {
                this.zzbnv.setInfoWindowAdapter(null);
            } else {
                this.zzbnv.setInfoWindowAdapter(new zzd.zza(this){

                    @Override
                    public IObjectWrapper zzh(zzf zzf2) {
                        return com.google.android.gms.dynamic.zzd.zzA((Object)infoWindowAdapter.getInfoWindow(new Marker(zzf2)));
                    }

                    @Override
                    public IObjectWrapper zzi(zzf zzf2) {
                        return com.google.android.gms.dynamic.zzd.zzA((Object)infoWindowAdapter.getInfoContents(new Marker(zzf2)));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnMyLocationChangeListener(final OnMyLocationChangeListener onMyLocationChangeListener) {
        try {
            if (onMyLocationChangeListener == null) {
                this.zzbnv.setOnMyLocationChangeListener(null);
            } else {
                this.zzbnv.setOnMyLocationChangeListener(new zzx.zza(this){

                    @Override
                    public void zzG(IObjectWrapper iObjectWrapper) {
                        onMyLocationChangeListener.onMyLocationChange((Location)com.google.android.gms.dynamic.zzd.zzF((IObjectWrapper)iObjectWrapper));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMyLocationButtonClickListener(final OnMyLocationButtonClickListener onMyLocationButtonClickListener) {
        try {
            if (onMyLocationButtonClickListener == null) {
                this.zzbnv.setOnMyLocationButtonClickListener(null);
            } else {
                this.zzbnv.setOnMyLocationButtonClickListener(new zzw.zza(this){

                    @Override
                    public boolean onMyLocationButtonClick() throws RemoteException {
                        return onMyLocationButtonClickListener.onMyLocationButtonClick();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setOnMapLoadedCallback(final OnMapLoadedCallback onMapLoadedCallback) {
        try {
            if (onMapLoadedCallback == null) {
                this.zzbnv.setOnMapLoadedCallback(null);
            } else {
                this.zzbnv.setOnMapLoadedCallback(new zzr.zza(this){

                    @Override
                    public void onMapLoaded() throws RemoteException {
                        onMapLoadedCallback.onMapLoaded();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnGroundOverlayClickListener(final OnGroundOverlayClickListener onGroundOverlayClickListener) {
        try {
            if (onGroundOverlayClickListener == null) {
                this.zzbnv.setOnGroundOverlayClickListener(null);
            } else {
                this.zzbnv.setOnGroundOverlayClickListener(new zzk.zza(this){

                    @Override
                    public void zza(zzc zzc2) {
                        onGroundOverlayClickListener.onGroundOverlayClick(new GroundOverlay(zzc2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCircleClickListener(final OnCircleClickListener onCircleClickListener) {
        try {
            if (onCircleClickListener == null) {
                this.zzbnv.setOnCircleClickListener(null);
            } else {
                this.zzbnv.setOnCircleClickListener(new zzj.zza(this){

                    @Override
                    public void zza(zzb zzb2) {
                        onCircleClickListener.onCircleClick(new Circle(zzb2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolygonClickListener(final OnPolygonClickListener onPolygonClickListener) {
        try {
            if (onPolygonClickListener == null) {
                this.zzbnv.setOnPolygonClickListener(null);
            } else {
                this.zzbnv.setOnPolygonClickListener(new zzz.zza(this){

                    @Override
                    public void zza(zzg zzg2) {
                        onPolygonClickListener.onPolygonClick(new Polygon(zzg2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolylineClickListener(final OnPolylineClickListener onPolylineClickListener) {
        try {
            if (onPolylineClickListener == null) {
                this.zzbnv.setOnPolylineClickListener(null);
            } else {
                this.zzbnv.setOnPolylineClickListener(new zzaa.zza(this){

                    @Override
                    public void zza(IPolylineDelegate iPolylineDelegate) {
                        onPolylineClickListener.onPolylineClick(new Polyline(iPolylineDelegate));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.snapshot(snapshotReadyCallback, null);
    }

    public final void snapshot(final SnapshotReadyCallback snapshotReadyCallback, Bitmap bitmap) {
        com.google.android.gms.dynamic.zzd zzd2 = (com.google.android.gms.dynamic.zzd)(bitmap != null ? com.google.android.gms.dynamic.zzd.zzA((Object)bitmap) : null);
        try {
            this.zzbnv.snapshot(new zzag.zza(this){

                @Override
                public void onSnapshotReady(Bitmap bitmap) throws RemoteException {
                    snapshotReadyCallback.onSnapshotReady(bitmap);
                }

                @Override
                public void zzH(IObjectWrapper iObjectWrapper) throws RemoteException {
                    snapshotReadyCallback.onSnapshotReady((Bitmap)com.google.android.gms.dynamic.zzd.zzF((IObjectWrapper)iObjectWrapper));
                }
            }, (IObjectWrapper)zzd2);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPadding(int n, int n2, int n3, int n4) {
        try {
            this.zzbnv.setPadding(n, n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setContentDescription(String string) {
        try {
            this.zzbnv.setContentDescription(string);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPoiClickListener(final OnPoiClickListener onPoiClickListener) {
        try {
            if (onPoiClickListener == null) {
                this.zzbnv.setOnPoiClickListener(null);
            } else {
                this.zzbnv.setOnPoiClickListener(new zzy.zza(this){

                    @Override
                    public void zza(PointOfInterest pointOfInterest) throws RemoteException {
                        onPoiClickListener.onPoiClick(pointOfInterest);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean setMapStyle(MapStyleOptions mapStyleOptions) {
        try {
            return this.zzbnv.setMapStyle(mapStyleOptions);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setMinZoomPreference(float f) {
        try {
            this.zzbnv.setMinZoomPreference(f);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setMaxZoomPreference(float f) {
        try {
            this.zzbnv.setMaxZoomPreference(f);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void resetMinMaxZoomPreference() {
        try {
            this.zzbnv.resetMinMaxZoomPreference();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setLatLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        try {
            this.zzbnv.setLatLngBoundsForCameraTarget(latLngBounds);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static interface OnPoiClickListener {
        public void onPoiClick(PointOfInterest var1);
    }

    private static final class zza
    extends zzb.zza {
        private final CancelableCallback zzbnW;

        zza(CancelableCallback cancelableCallback) {
            this.zzbnW = cancelableCallback;
        }

        @Override
        public void onFinish() {
            this.zzbnW.onFinish();
        }

        @Override
        public void onCancel() {
            this.zzbnW.onCancel();
        }
    }

    public static interface OnGroundOverlayClickListener {
        public void onGroundOverlayClick(GroundOverlay var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMyLocationButtonClickListener {
        public boolean onMyLocationButtonClick();
    }

    @Deprecated
    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(Location var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);

        public View getInfoContents(Marker var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(Marker var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(Marker var1);

        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(Polyline var1);
    }

    public static interface OnPolygonClickListener {
        public void onPolygonClick(Polygon var1);
    }

    public static interface OnCircleClickListener {
        public void onCircleClick(Circle var1);
    }

    @Deprecated
    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onCameraMoveStarted(int var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);
    }

    public static interface OnIndoorStateChangeListener {
        public void onIndoorBuildingFocused();

        public void onIndoorLevelActivated(IndoorBuilding var1);
    }
}

