/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzah;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzbox;

    public MapView(Context context) {
        super(context);
        this.zzbox = new zzb((ViewGroup)this, context, null);
        this.zzJz();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbox = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzJz();
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbox = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzJz();
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzbox = new zzb((ViewGroup)this, context, googleMapOptions);
        this.zzJz();
    }

    private void zzJz() {
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.zzbox.onCreate(bundle);
        if (this.zzbox.zzBM() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzbox.onResume();
    }

    public final void onPause() {
        this.zzbox.onPause();
    }

    public final void onStart() {
        this.zzbox.onStart();
    }

    public final void onStop() {
        this.zzbox.onStop();
    }

    public final void onDestroy() {
        this.zzbox.onDestroy();
    }

    public final void onLowMemory() {
        this.zzbox.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzbox.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzac.zzdj((String)"getMapAsync() must be called on the main thread");
        this.zzbox.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzac.zzdj((String)"onEnterAmbient() must be called on the main thread");
        this.zzbox.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzac.zzdj((String)"onExitAmbient() must be called on the main thread");
        this.zzbox.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzboB;
        private final Context mContext;
        protected zze<zza> zzbov;
        private final GoogleMapOptions zzboC;
        private final List<OnMapReadyCallback> zzbow = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzboB = viewGroup;
            this.mContext = context;
            this.zzboC = googleMapOptions;
        }

        protected void zza(zze<zza> zze2) {
            this.zzbov = zze2;
            this.zzJy();
        }

        public void zzJy() {
            if (this.zzbov != null && this.zzBM() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzai.zzbI(this.mContext).zza(zzd.zzA((Object)this.mContext), this.zzboC);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzbov.zza((LifecycleDelegate)new zza(this.zzboB, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzbow) {
                        ((zza)this.zzBM()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzbow.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzBM() != null) {
                ((zza)this.zzBM()).getMapAsync(onMapReadyCallback);
            } else {
                this.zzbow.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzBM() != null) {
                ((zza)this.zzBM()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzBM() != null) {
                ((zza)this.zzBM()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzboy;
        private final IMapViewDelegate zzboz;
        private View zzboA;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzboz = (IMapViewDelegate)zzac.zzw((Object)iMapViewDelegate);
            this.zzboy = (ViewGroup)zzac.zzw((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                this.zzboz.onCreate(bundle2);
                zzah.zzd(bundle2, bundle);
                this.zzboA = (View)zzd.zzF((IObjectWrapper)this.zzboz.getView());
                this.zzboy.removeAllViews();
                this.zzboy.addView(this.zzboA);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
            try {
                this.zzboz.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzboz.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzboz.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzboz.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzboz.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzboz.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                this.zzboz.onSaveInstanceState(bundle2);
                zzah.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzboz.getMapAsync(new zzt.zza(this){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                this.zzboz.onEnterAmbient(bundle2);
                zzah.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzboz.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

