/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GoogleMapOptions
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new com.google.android.gms.maps.zza();
    private Boolean zzboc;
    private Boolean zzbod;
    private int zzboe = -1;
    private CameraPosition zzbof;
    private Boolean zzbog;
    private Boolean zzboh;
    private Boolean zzboi;
    private Boolean zzboj;
    private Boolean zzbok;
    private Boolean zzbol;
    private Boolean zzbom;
    private Boolean zzbon;
    private Boolean zzboo;
    private Float zzbop = null;
    private Float zzboq = null;
    private LatLngBounds zzbor = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzboc = zza.zza(by);
        this.zzbod = zza.zza(by2);
        this.zzboe = n;
        this.zzbof = cameraPosition;
        this.zzbog = zza.zza(by3);
        this.zzboh = zza.zza(by4);
        this.zzboi = zza.zza(by5);
        this.zzboj = zza.zza(by6);
        this.zzbok = zza.zza(by7);
        this.zzbol = zza.zza(by8);
        this.zzbom = zza.zza(by9);
        this.zzbon = zza.zza(by10);
        this.zzboo = zza.zza(by11);
        this.zzbop = f;
        this.zzboq = f2;
        this.zzbor = latLngBounds;
    }

    public void writeToParcel(Parcel parcel, int n) {
        com.google.android.gms.maps.zza.zza(this, parcel, n);
    }

    byte zzJn() {
        return zza.zzd(this.zzboc);
    }

    byte zzJo() {
        return zza.zzd(this.zzbod);
    }

    byte zzJp() {
        return zza.zzd(this.zzbog);
    }

    byte zzJq() {
        return zza.zzd(this.zzboh);
    }

    byte zzJr() {
        return zza.zzd(this.zzboi);
    }

    byte zzJs() {
        return zza.zzd(this.zzboj);
    }

    byte zzJt() {
        return zza.zzd(this.zzbok);
    }

    byte zzJu() {
        return zza.zzd(this.zzbol);
    }

    byte zzJv() {
        return zza.zzd(this.zzbom);
    }

    byte zzJw() {
        return zza.zzd(this.zzbon);
    }

    byte zzJx() {
        return zza.zzd(this.zzboo);
    }

    public GoogleMapOptions() {
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzboc = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzbod = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.zzboe = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzbof = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzbog = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.zzboh = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzboi = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzboj = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzbok = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzbol = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.zzbom = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzbon = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzboo = bl;
        return this;
    }

    public GoogleMapOptions minZoomPreference(float f) {
        this.zzbop = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions maxZoomPreference(float f) {
        this.zzboq = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzbor = latLngBounds;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzboc;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzbod;
    }

    public int getMapType() {
        return this.zzboe;
    }

    public CameraPosition getCamera() {
        return this.zzbof;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzbog;
    }

    public Boolean getCompassEnabled() {
        return this.zzboh;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzboi;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzboj;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzbok;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzbol;
    }

    public Boolean getLiteMode() {
        return this.zzbom;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzbon;
    }

    public Boolean getAmbientEnabled() {
        return this.zzboo;
    }

    public Float getMinZoomPreference() {
        return this.zzbop;
    }

    public Float getMaxZoomPreference() {
        return this.zzboq;
    }

    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzbor;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

