/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.zzoz;
import com.google.android.gms.internal.zzpa;

public class zzoy
extends zzj<zzpa> {
    private Activity mActivity;
    private zza zzaDj;
    private final String zzRs;
    private final int mTheme;

    public zzoy(Activity activity, Looper looper, zzf zzf2, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super((Context)activity, looper, 12, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzRs = zzf2.getAccountName();
        this.mActivity = activity;
        this.mTheme = n;
    }

    public boolean zzpe() {
        return true;
    }

    protected String zzfK() {
        return "com.google.android.gms.identity.service.BIND";
    }

    protected String zzfL() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    protected zzpa zzbS(IBinder iBinder) {
        return zzpa.zza.zzbU(iBinder);
    }

    public void disconnect() {
        super.disconnect();
        if (this.zzaDj != null) {
            this.zzaDj.setActivity(null);
            this.zzaDj = null;
        }
    }

    protected zzpa zzwj() throws DeadObjectException {
        return (zzpa)super.zzpc();
    }

    protected void zzwk() {
        super.zzpb();
    }

    public void zza(UserAddressRequest userAddressRequest, int n) {
        this.zzwk();
        this.zzaDj = new zza(n, this.mActivity);
        try {
            Bundle bundle = new Bundle();
            String string = this.getContext().getPackageName();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", string);
            if (!TextUtils.isEmpty((CharSequence)this.zzRs)) {
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)new Account(this.zzRs, "com.google"));
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.mTheme);
            this.zzwj().zza(this.zzaDj, userAddressRequest, bundle);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            this.zzaDj.zzh(1, bundle);
        }
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzbS(iBinder);
    }

    public static final class zza
    extends zzoz.zza {
        private final int zzaaY;
        private Activity mActivity;

        public zza(int n, Activity activity) {
            this.zzaaY = n;
            this.mActivity = activity;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            ConnectionResult connectionResult;
            if (n == 1) {
                Intent intent = new Intent();
                intent.putExtras(bundle);
                PendingIntent pendingIntent = this.mActivity.createPendingResult(this.zzaaY, intent, 0x40000000);
                if (pendingIntent == null) {
                    return;
                }
                try {
                    pendingIntent.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception settng pending result", (Throwable)canceledException);
                }
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.identity.intents.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(this.mActivity, this.zzaaY);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                try {
                    PendingIntent pendingIntent2 = this.mActivity.createPendingResult(this.zzaaY, new Intent(), 0x40000000);
                    if (pendingIntent2 != null) {
                        pendingIntent2.send(1);
                    }
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
        }
    }
}

