/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.flags.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Binder;
import android.util.Log;
import com.google.android.gms.common.util.SharedPreferencesUtils;
import com.google.android.gms.flags.Flag;
import com.google.android.gms.flags.Singletons;
import com.google.android.gms.flags.impl.DataUtils;
import com.google.android.gms.flags.impl.SharedPreferencesFactory;
import java.util.ArrayList;
import java.util.List;

public class ServiceApi {
    public ServiceApi() {
    }

    public List<String> getExperimentIdsFromService() {
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = Binder.clearCallingIdentity();
        try {
            for (Flag.StringFlag stringFlag : Singletons.flagRegistry().registeredServiceExperimentIdFlags()) {
                String string = (String)((DataUtils)new DataUtils.StringUtils(stringFlag)).getGservicesValue().get();
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)l);
        }
        return arrayList;
    }

    public static void persistGserviceValues(Context context) {
        SharedPreferences.Editor editor;
        SharedPreferences sharedPreferences;
        try {
            sharedPreferences = SharedPreferencesFactory.getSharedPreferences(context);
        }
        catch (Exception exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FlagsServiceApi", (String)(string.length() != 0 ? "Failed to write shared flags: ".concat(string) : new String("Failed to write shared flags: ")));
            return;
        }
        SharedPreferences.Editor editor2 = editor = sharedPreferences.edit();
        for (Flag flag : Singletons.flagRegistry().registeredFlags()) {
            if (flag.getSource() != 0) continue;
            DataUtils dataUtils = DataUtils.forFlag(flag);
            dataUtils.putInSharedPreferences(editor2, dataUtils.getGservicesValue().get());
        }
        SharedPreferences.Editor editor3 = editor;
        SharedPreferencesUtils.publishWorldReadableSharedPreferences((Context)context, (SharedPreferences.Editor)editor3, (String)"google_sdk_flags");
    }
}

