/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.flags.impl;

import android.content.SharedPreferences;
import android.util.Log;
import com.google.android.gms.common.config.GservicesValue;
import com.google.android.gms.flags.Flag;
import com.google.android.gms.flags.impl.util.StrictModeUtil;
import com.google.android.gms.flags.impl.zza;
import com.google.android.gms.flags.impl.zzb;
import com.google.android.gms.flags.impl.zzc;
import com.google.android.gms.flags.impl.zzd;
import org.json.JSONObject;

public abstract class DataUtils<T> {
    public DataUtils() {
    }

    public static DataUtils forFlag(Flag flag) {
        if (flag instanceof Flag.BooleanFlag) {
            return new BooleanUtils((Flag.BooleanFlag)flag);
        }
        if (flag instanceof Flag.IntegerFlag) {
            return new IntegerUtils((Flag.IntegerFlag)flag);
        }
        if (flag instanceof Flag.LongFlag) {
            return new LongUtils((Flag.LongFlag)flag);
        }
        if (flag instanceof Flag.StringFlag) {
            return new StringUtils((Flag.StringFlag)flag);
        }
        String string = String.valueOf(flag.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "Unexpected flag type: ".concat(string) : new String("Unexpected flag type: "));
    }

    public abstract GservicesValue<T> getGservicesValue();

    public abstract void putInSharedPreferences(SharedPreferences.Editor var1, T var2);

    public abstract T getFromSharedPreferences(SharedPreferences var1);

    public abstract void putStringOverrideInSharedPreferences(SharedPreferences.Editor var1, String var2);

    public abstract T getFromJSONObject(JSONObject var1);

    public static class StringUtils
    extends DataUtils<String> {
        private final Flag.StringFlag zzacs;

        StringUtils(Flag.StringFlag stringFlag) {
            this.zzacs = stringFlag;
        }

        @Override
        public GservicesValue<String> getGservicesValue() {
            return GservicesValue.value((String)this.zzacs.getKey(), (String)((String)this.zzacs.getDefault()));
        }

        @Override
        public void putInSharedPreferences(SharedPreferences.Editor editor, String string) {
            editor.putString(this.zzacs.getKey(), string);
        }

        @Override
        public String getFromSharedPreferences(SharedPreferences sharedPreferences) {
            return sharedPreferences.getString(this.zzacs.getKey(), (String)this.zzacs.getDefault());
        }

        public static String getFromSharedPreferencesNoStrict(SharedPreferences sharedPreferences, String string, String string2) {
            try {
                return StrictModeUtil.runWithLaxStrictMode(new zzd(sharedPreferences, string, string2));
            }
            catch (Exception exception) {
                String string3 = String.valueOf(exception.getMessage());
                Log.w((String)"FlagDataUtils", (String)(string3.length() != 0 ? "Flag value not available, returning default: ".concat(string3) : new String("Flag value not available, returning default: ")));
                return string2;
            }
        }

        @Override
        public void putStringOverrideInSharedPreferences(SharedPreferences.Editor editor, String string) {
            editor.putString(this.zzacs.getKey(), String.valueOf(string));
        }

        @Override
        public String getFromJSONObject(JSONObject jSONObject) {
            return jSONObject.optString(this.zzacs.getKey(), (String)this.zzacs.getDefault());
        }
    }

    public static class LongUtils
    extends DataUtils<Long> {
        private final Flag.LongFlag zzacq;

        LongUtils(Flag.LongFlag longFlag) {
            this.zzacq = longFlag;
        }

        @Override
        public GservicesValue<Long> getGservicesValue() {
            return GservicesValue.value((String)this.zzacq.getKey(), (Long)((Long)this.zzacq.getDefault()));
        }

        @Override
        public void putInSharedPreferences(SharedPreferences.Editor editor, Long l) {
            editor.putLong(this.zzacq.getKey(), l.longValue());
        }

        @Override
        public Long getFromSharedPreferences(SharedPreferences sharedPreferences) {
            return sharedPreferences.getLong(this.zzacq.getKey(), ((Long)this.zzacq.getDefault()).longValue());
        }

        public static Long getFromSharedPreferencesNoStrict(SharedPreferences sharedPreferences, String string, Long l) {
            try {
                return StrictModeUtil.runWithLaxStrictMode(new zzc(sharedPreferences, string, l));
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.w((String)"FlagDataUtils", (String)(string2.length() != 0 ? "Flag value not available, returning default: ".concat(string2) : new String("Flag value not available, returning default: ")));
                return l;
            }
        }

        @Override
        public void putStringOverrideInSharedPreferences(SharedPreferences.Editor editor, String string) {
            editor.putLong(this.zzacq.getKey(), Long.parseLong(string));
        }

        @Override
        public Long getFromJSONObject(JSONObject jSONObject) {
            return jSONObject.optLong(this.zzacq.getKey(), ((Long)this.zzacq.getDefault()).longValue());
        }
    }

    public static class IntegerUtils
    extends DataUtils<Integer> {
        private final Flag.IntegerFlag zzaco;

        IntegerUtils(Flag.IntegerFlag integerFlag) {
            this.zzaco = integerFlag;
        }

        @Override
        public GservicesValue<Integer> getGservicesValue() {
            return GservicesValue.value((String)this.zzaco.getKey(), (Integer)((Integer)this.zzaco.getDefault()));
        }

        @Override
        public void putInSharedPreferences(SharedPreferences.Editor editor, Integer n) {
            editor.putInt(this.zzaco.getKey(), n.intValue());
        }

        @Override
        public Integer getFromSharedPreferences(SharedPreferences sharedPreferences) {
            return sharedPreferences.getInt(this.zzaco.getKey(), ((Integer)this.zzaco.getDefault()).intValue());
        }

        public static Integer getFromSharedPreferencesNoStrict(SharedPreferences sharedPreferences, String string, Integer n) {
            try {
                return StrictModeUtil.runWithLaxStrictMode(new zzb(sharedPreferences, string, n));
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.w((String)"FlagDataUtils", (String)(string2.length() != 0 ? "Flag value not available, returning default: ".concat(string2) : new String("Flag value not available, returning default: ")));
                return n;
            }
        }

        @Override
        public void putStringOverrideInSharedPreferences(SharedPreferences.Editor editor, String string) {
            editor.putInt(this.zzaco.getKey(), Integer.parseInt(string));
        }

        @Override
        public Integer getFromJSONObject(JSONObject jSONObject) {
            return jSONObject.optInt(this.zzaco.getKey(), ((Integer)this.zzaco.getDefault()).intValue());
        }
    }

    public static class BooleanUtils
    extends DataUtils<Boolean> {
        private final Flag.BooleanFlag zzack;

        BooleanUtils(Flag.BooleanFlag booleanFlag) {
            this.zzack = booleanFlag;
        }

        @Override
        public GservicesValue<Boolean> getGservicesValue() {
            return GservicesValue.value((String)this.zzack.getKey(), (boolean)((Boolean)this.zzack.getDefault()));
        }

        @Override
        public void putInSharedPreferences(SharedPreferences.Editor editor, Boolean bl) {
            editor.putBoolean(this.zzack.getKey(), bl.booleanValue());
        }

        @Override
        public Boolean getFromSharedPreferences(SharedPreferences sharedPreferences) {
            return sharedPreferences.getBoolean(this.zzack.getKey(), ((Boolean)this.zzack.getDefault()).booleanValue());
        }

        public static Boolean getFromSharedPreferencesNoStrict(SharedPreferences sharedPreferences, String string, Boolean bl) {
            try {
                return StrictModeUtil.runWithLaxStrictMode(new zza(sharedPreferences, string, bl));
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.w((String)"FlagDataUtils", (String)(string2.length() != 0 ? "Flag value not available, returning default: ".concat(string2) : new String("Flag value not available, returning default: ")));
                return bl;
            }
        }

        @Override
        public void putStringOverrideInSharedPreferences(SharedPreferences.Editor editor, String string) {
            editor.putBoolean(this.zzack.getKey(), Boolean.parseBoolean(string));
        }

        @Override
        public Boolean getFromJSONObject(JSONObject jSONObject) {
            return jSONObject.optBoolean(this.zzack.getKey(), ((Boolean)this.zzack.getDefault()).booleanValue());
        }
    }
}

