/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.clearcut;

import com.google.android.gms.internal.clearcut.zzav;
import com.google.android.gms.internal.clearcut.zzci;
import com.google.android.gms.internal.clearcut.zzcn;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbq
extends zzav<Double>
implements zzcn<Double>,
RandomAccess {
    private static final zzbq zzgj = new zzbq();
    private double[] zzgk;
    private int size;

    zzbq() {
        this(new double[10], 0);
    }

    private zzbq(double[] dArray, int n) {
        this.zzgk = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzgk, n2, this.zzgk, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbq)) {
            return super.equals(object);
        }
        zzbq zzbq2 = (zzbq)object;
        if (this.size != zzbq2.size) {
            return false;
        }
        double[] dArray = zzbq2.zzgk;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzgk[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzgk[i]);
            n = n * 31 + zzci.zzl(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
        if (this.size < this.zzgk.length) {
            System.arraycopy(this.zzgk, n, this.zzgk, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzgk, 0, dArray, 0, n);
            System.arraycopy(this.zzgk, n, dArray, n + 1, this.size - n);
            this.zzgk = dArray;
        }
        this.zzgk[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzw();
        zzci.checkNotNull(collection);
        if (!(collection instanceof zzbq)) {
            return super.addAll(collection);
        }
        zzbq zzbq2 = (zzbq)collection;
        if (zzbq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbq2.size;
        if (n > this.zzgk.length) {
            this.zzgk = Arrays.copyOf(this.zzgk, n);
        }
        System.arraycopy(zzbq2.zzgk, 0, this.zzgk, this.size, zzbq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzgk[i])) continue;
            System.arraycopy(this.zzgk, i + 1, this.zzgk, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzg(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
    }

    private final String zzh(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzbq zzbq2 = this;
        zzbq2.zzw();
        zzbq2.zzg(n);
        double d3 = zzbq2.zzgk[n];
        zzbq2.zzgk[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbq zzbq2 = this;
        zzbq2.zzw();
        zzbq2.zzg(n);
        double d = zzbq2.zzgk[n];
        if (n < zzbq2.size - 1) {
            System.arraycopy(zzbq2.zzgk, n + 1, zzbq2.zzgk, n, zzbq2.size - n);
        }
        --zzbq2.size;
        ++zzbq2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzcn zzi(int n) {
        int n2 = n;
        zzbq zzbq2 = this;
        if (n2 < zzbq2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbq(Arrays.copyOf(zzbq2.zzgk, n2), zzbq2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbq zzbq2 = this;
        zzbq2.zzg(n);
        return zzbq2.zzgk[n];
    }

    static {
        zzgj.zzv();
    }
}

