/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzry;
import com.google.android.gms.internal.zzrz;
import java.lang.ref.WeakReference;

public class zzsf<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> Bv = null;
    private zzsf<? extends Result> Bw = null;
    private volatile ResultCallbacks<? super R> Bx = null;
    private PendingResult<R> By = null;
    private final Object yH = new Object();
    private Status Bz = null;
    private final WeakReference<GoogleApiClient> yJ;
    private final zza BA;
    private boolean BB = false;

    public zzsf(WeakReference<GoogleApiClient> weakReference) {
        zzaa.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.yJ = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.yJ.get();
        this.BA = new zza(googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.yH;
        synchronized (object) {
            zzaa.zza((this.Bv == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzaa.zza((this.Bx == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.Bv = resultTransform;
            zzsf<R> zzsf2 = new zzsf<R>(this.yJ);
            this.Bw = zzsf2;
            this.zzauc();
            return zzsf2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.yH;
        synchronized (object) {
            zzaa.zza((this.Bx == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzaa.zza((this.Bv == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.Bx = resultCallbacks;
            this.zzauc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(R r) {
        Object object = this.yH;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.Bv != null) {
                    zzry.zzatf().submit(new Runnable((Result)r){
                        final /* synthetic */ Result BC;
                        {
                            this.BC = result;
                        }

                        @Override
                        @WorkerThread
                        public void run() {
                            try {
                                zzqq.yG.set(true);
                                PendingResult pendingResult = zzsf.this.Bv.onSuccess(this.BC);
                                zzsf.this.BA.sendMessage(zzsf.this.BA.obtainMessage(0, pendingResult));
                            }
                            catch (RuntimeException runtimeException) {
                                zzsf.this.BA.sendMessage(zzsf.this.BA.obtainMessage(1, runtimeException));
                            }
                            finally {
                                zzqq.yG.set(false);
                                zzsf.this.zze(this.BC);
                                GoogleApiClient googleApiClient = (GoogleApiClient)zzsf.this.yJ.get();
                                if (googleApiClient != null) {
                                    googleApiClient.zzb(zzsf.this);
                                }
                            }
                        }
                    });
                } else if (this.zzaue()) {
                    this.Bx.onSuccess(r);
                }
            } else {
                this.zzad(r.getStatus());
                this.zze((Result)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(PendingResult<?> pendingResult) {
        Object object = this.yH;
        synchronized (object) {
            this.By = pendingResult;
            this.zzauc();
        }
    }

    private void zzauc() {
        if (this.Bv == null && this.Bx == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.yJ.get();
        if (!this.BB && this.Bv != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.BB = true;
        }
        if (this.Bz != null) {
            this.zzae(this.Bz);
        } else if (this.By != null) {
            this.By.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzad(Status status) {
        Object object = this.yH;
        synchronized (object) {
            this.Bz = status;
            this.zzae(this.Bz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzae(Status status) {
        Object object = this.yH;
        synchronized (object) {
            if (this.Bv != null) {
                Status status2 = this.Bv.onFailure(status);
                zzaa.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzad(status2);
            } else if (this.zzaue()) {
                this.Bx.onFailure(status);
            }
        }
    }

    void zzaud() {
        this.Bx = null;
    }

    private boolean zzaue() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.yJ.get();
        return this.Bx != null && googleApiClient != null;
    }

    private void zze(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    PendingResult pendingResult = (PendingResult)message.obj;
                    Object object = zzsf.this.yH;
                    synchronized (object) {
                        if (pendingResult == null) {
                            ((zzsf)zzsf.this.Bw).zzad(new Status(13, "Transform returned null"));
                        } else if (pendingResult instanceof zzrz) {
                            ((zzsf)zzsf.this.Bw).zzad(((zzrz)pendingResult).getStatus());
                        } else {
                            zzsf.this.Bw.zza(pendingResult);
                        }
                        break;
                    }
                }
                case 1: {
                    RuntimeException runtimeException = (RuntimeException)message.obj;
                    String string2 = String.valueOf(runtimeException.getMessage());
                    Log.e((String)"TransformedResultImpl", (String)(string2.length() != 0 ? "Runtime exception on the transformation worker thread: ".concat(string2) : new String("Runtime exception on the transformation worker thread: ")));
                    throw runtimeException;
                }
                default: {
                    int n = message.what;
                    Log.e((String)"TransformedResultImpl", (String)new StringBuilder(70).append("TransformationResultHandler received unknown message type: ").append(n).toString());
                }
            }
        }
    }
}

