/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.internal.zzra;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrc;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzre;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzxp;
import com.google.android.gms.internal.zzxq;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzrf
implements zzqs,
zzrm {
    private final Lock zg;
    private final Condition Aw;
    private final Context mContext;
    private final zzc zm;
    private final zzb Ax;
    final Map<Api.zzc<?>, Api.zze> Aj;
    final Map<Api.zzc<?>, ConnectionResult> Ay = new HashMap();
    final zzf zP;
    final Map<Api<?>, Integer> zk;
    final Api.zza<? extends zzxp, zzxq> xQ;
    private volatile zzre Az;
    private ConnectionResult AA = null;
    int AB;
    final zzrd yW;
    final zzrm.zza AC;

    public zzrf(Context context, zzrd zzrd2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzf zzf2, Map<Api<?>, Integer> map2, Api.zza<? extends zzxp, zzxq> zza2, ArrayList<zzqr> arrayList, zzrm.zza zza3) {
        this.mContext = context;
        this.zg = lock;
        this.zm = zzc2;
        this.Aj = map;
        this.zP = zzf2;
        this.zk = map2;
        this.xQ = zza2;
        this.yW = zzrd2;
        this.AC = zza3;
        for (zzqr zzqr2 : arrayList) {
            zzqr2.zza(this);
        }
        this.Ax = new zzb(looper);
        this.Aw = lock.newCondition();
        this.Az = new zzrc(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqo.zza<R, A>> T zza(@NonNull T t) {
        t.zzarv();
        return this.Az.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T zzb(@NonNull T t) {
        t.zzarv();
        return this.Az.zzb(t);
    }

    @Override
    public void connect() {
        this.Az.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.Aw.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.wO;
        }
        if (this.AA != null) {
            return this.AA;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.Aw.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.wO;
        }
        if (this.AA != null) {
            return this.AA;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        boolean bl = this.Az.disconnect();
        if (bl) {
            this.Ay.clear();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzaqv();
        if (this.Aj.containsKey(zzc2)) {
            if (this.Aj.get(zzc2).isConnected()) {
                return ConnectionResult.wO;
            }
            if (this.Ay.containsKey(zzc2)) {
                return this.Ay.get(zzc2);
            }
        }
        return null;
    }

    void zzatc() {
        this.zg.lock();
        try {
            this.Az = new zzrb(this, this.zP, this.zk, this.zm, this.xQ, this.zg, this.mContext);
            this.Az.begin();
            this.Aw.signalAll();
        }
        finally {
            this.zg.unlock();
        }
    }

    void zzatd() {
        this.zg.lock();
        try {
            this.yW.zzasz();
            this.Az = new zzra(this);
            this.Az.begin();
            this.Aw.signalAll();
        }
        finally {
            this.zg.unlock();
        }
    }

    void zzh(ConnectionResult connectionResult) {
        this.zg.lock();
        try {
            this.AA = connectionResult;
            this.Az = new zzrc(this);
            this.Az.begin();
            this.Aw.signalAll();
        }
        finally {
            this.zg.unlock();
        }
    }

    void zzate() {
        for (Api.zze zze2 : this.Aj.values()) {
            zze2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.Az instanceof zzra;
    }

    @Override
    public boolean isConnecting() {
        return this.Az instanceof zzrb;
    }

    @Override
    public boolean zza(zzsa zzsa2) {
        return false;
    }

    @Override
    public void zzard() {
    }

    @Override
    public void zzarz() {
        if (this.isConnected()) {
            ((zzra)this.Az).zzasn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, int n) {
        this.zg.lock();
        try {
            this.Az.zza(connectionResult, api, n);
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {
        this.zg.lock();
        try {
            this.Az.onConnected(bundle);
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zg.lock();
        try {
            this.Az.onConnectionSuspended(n);
        }
        finally {
            this.zg.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.Ax.obtainMessage(1, zza2);
        this.Ax.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.Ax.obtainMessage(2, runtimeException);
        this.Ax.sendMessage(message);
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.Az);
        for (Api<?> api : this.zk.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            Api.zze zze2 = this.Aj.get(api.zzaqv());
            zze2.dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static abstract class zza {
        private final zzre AD;

        protected zza(zzre zzre2) {
            this.AD = zzre2;
        }

        public final void zzc(zzrf zzrf2) {
            zzrf2.zg.lock();
            try {
                if (zzrf2.Az != this.AD) {
                    return;
                }
                this.zzaso();
            }
            finally {
                zzrf2.zg.unlock();
            }
        }

        protected abstract void zzaso();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zza zza2 = (zza)message.obj;
                    zza2.zzc(zzrf.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)message.obj;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GACStateManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }
}

