/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzrj;
import com.google.android.gms.internal.zzrk;
import java.lang.ref.WeakReference;

public class zzrp<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zk = null;
    private zzrp<? extends Result> zl = null;
    private volatile ResultCallbacks<? super R> zm = null;
    private PendingResult<R> zn = null;
    private final Object wG = new Object();
    private Status zo = null;
    private final WeakReference<GoogleApiClient> wI;
    private final zza zp;
    private boolean zq = false;

    public zzrp(WeakReference<GoogleApiClient> weakReference) {
        zzac.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.wI = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.wI.get();
        this.zp = new zza(googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.wG;
        synchronized (object) {
            zzac.zza((this.zk == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzac.zza((this.zm == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zk = resultTransform;
            zzrp<R> zzrp2 = new zzrp<R>(this.wI);
            this.zl = zzrp2;
            this.zzast();
            return zzrp2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.wG;
        synchronized (object) {
            zzac.zza((this.zm == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzac.zza((this.zk == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zm = resultCallbacks;
            this.zzast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(R r) {
        Object object = this.wG;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zk != null) {
                    zzrj.zzarz().submit(new Runnable((Result)r){
                        final /* synthetic */ Result zr;
                        {
                            this.zr = result;
                        }

                        @Override
                        @WorkerThread
                        public void run() {
                            try {
                                zzqe.wF.set(true);
                                PendingResult pendingResult = zzrp.this.zk.onSuccess(this.zr);
                                zzrp.this.zp.sendMessage(zzrp.this.zp.obtainMessage(0, pendingResult));
                            }
                            catch (RuntimeException runtimeException) {
                                zzrp.this.zp.sendMessage(zzrp.this.zp.obtainMessage(1, runtimeException));
                            }
                            finally {
                                zzqe.wF.set(false);
                                zzrp.this.zze(this.zr);
                                GoogleApiClient googleApiClient = (GoogleApiClient)zzrp.this.wI.get();
                                if (googleApiClient != null) {
                                    googleApiClient.zzb(zzrp.this);
                                }
                            }
                        }
                    });
                } else if (this.zzasv()) {
                    this.zm.onSuccess(r);
                }
            } else {
                this.zzac(r.getStatus());
                this.zze((Result)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(PendingResult<?> pendingResult) {
        Object object = this.wG;
        synchronized (object) {
            this.zn = pendingResult;
            this.zzast();
        }
    }

    private void zzast() {
        if (this.zk == null && this.zm == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.wI.get();
        if (!this.zq && this.zk != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zq = true;
        }
        if (this.zo != null) {
            this.zzad(this.zo);
        } else if (this.zn != null) {
            this.zn.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzac(Status status) {
        Object object = this.wG;
        synchronized (object) {
            this.zo = status;
            this.zzad(this.zo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzad(Status status) {
        Object object = this.wG;
        synchronized (object) {
            if (this.zk != null) {
                Status status2 = this.zk.onFailure(status);
                zzac.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzac(status2);
            } else if (this.zzasv()) {
                this.zm.onFailure(status);
            }
        }
    }

    void zzasu() {
        this.zm = null;
    }

    private boolean zzasv() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.wI.get();
        return this.zm != null && googleApiClient != null;
    }

    private void zze(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    PendingResult pendingResult = (PendingResult)message.obj;
                    Object object = zzrp.this.wG;
                    synchronized (object) {
                        if (pendingResult == null) {
                            ((zzrp)zzrp.this.zl).zzac(new Status(13, "Transform returned null"));
                        } else if (pendingResult instanceof zzrk) {
                            ((zzrp)zzrp.this.zl).zzac(((zzrk)pendingResult).getStatus());
                        } else {
                            zzrp.this.zl.zza(pendingResult);
                        }
                        break;
                    }
                }
                case 1: {
                    RuntimeException runtimeException = (RuntimeException)message.obj;
                    String string2 = String.valueOf(runtimeException.getMessage());
                    Log.e((String)"TransformedResultImpl", (String)(string2.length() != 0 ? "Runtime exception on the transformation worker thread: ".concat(string2) : new String("Runtime exception on the transformation worker thread: ")));
                    throw runtimeException;
                }
                default: {
                    int n = message.what;
                    Log.e((String)"TransformedResultImpl", (String)new StringBuilder(70).append("TransformationResultHandler received unknown message type: ").append(n).toString());
                }
            }
        }
    }
}

