/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzai;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqz;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.internal.zzwy;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzxa;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> vE = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = vE;
        synchronized (set) {
            int n = 0;
            String string2 = String.valueOf(string).concat("  ");
            for (GoogleApiClient googleApiClient : vE) {
                printWriter.append(string).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string2, fileDescriptor, printWriter, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<GoogleApiClient> zzaqa() {
        Set<GoogleApiClient> set = vE;
        synchronized (set) {
            return vE;
        }
    }

    public <A extends Api.zzb, R extends Result, T extends zzqc.zza<R, A>> T zzc(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzqc.zza<? extends Result, A>> T zzd(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzrd<L> zzs(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzrl zzrl2) {
        throw new UnsupportedOperationException();
    }

    public void zzaqb() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzrp zzrp2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzrp zzrp2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account ec;
        private final Set<Scope> vF = new HashSet<Scope>();
        private final Set<Scope> vG = new HashSet<Scope>();
        private int vH;
        private View vI;
        private String fo;
        private String vJ;
        private final Map<Api<?>, zzh.zza> vK = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> vL = new ArrayMap();
        private zzqz vM;
        private int vN = -1;
        private OnConnectionFailedListener vO;
        private Looper zzajn;
        private GoogleApiAvailability vP = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzwz, zzxa> vQ = zzwy.fb;
        private final ArrayList<ConnectionCallbacks> vR = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> vS = new ArrayList();

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzajn = context.getMainLooper();
            this.fo = context.getPackageName();
            this.vJ = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzac.zzb((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.vR.add(connectionCallbacks);
            zzac.zzb((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.vS.add(onConnectionFailedListener);
        }

        public Builder setHandler(@NonNull Handler handler) {
            zzac.zzb((Object)handler, (Object)"Handler must not be null");
            this.zzajn = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzac.zzb((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.vR.add(connectionCallbacks);
            return this;
        }

        public Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzac.zzb((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.vS.add(onConnectionFailedListener);
            return this;
        }

        public Builder setViewForPopups(@NonNull View view) {
            zzac.zzb((Object)view, (Object)"View must not be null");
            this.vI = view;
            return this;
        }

        public Builder addScope(@NonNull Scope scope) {
            zzac.zzb((Object)scope, (Object)"Scope must not be null");
            this.vF.add(scope);
            return this;
        }

        public Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzac.zzb(api, (Object)"Api must not be null");
            this.vL.put(api, null);
            List<Scope> list = api.zzapm().zzp(null);
            this.vG.addAll(list);
            this.vF.addAll(list);
            return this;
        }

        public Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzac.zzb(api, (Object)"Api must not be null");
            this.vL.put(api, null);
            this.zza(api, null, 1, scopeArray);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzac.zzb(api, (Object)"Api must not be null");
            zzac.zzb(o, (Object)"Null options are not permitted for this Api");
            this.vL.put(api, o);
            List<Scope> list = api.zzapm().zzp(o);
            this.vG.addAll(list);
            this.vF.addAll(list);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzac.zzb(api, (Object)"Api must not be null");
            zzac.zzb(o, (Object)"Null options are not permitted for this Api");
            this.vL.put(api, o);
            this.zza(api, o, 1, scopeArray);
            return this;
        }

        public Builder setAccountName(String string) {
            this.ec = string == null ? null : new Account(string, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int n) {
            this.vH = n;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.zza(new zzqz((Activity)fragmentActivity), n, onConnectionFailedListener);
        }

        private Builder zza(@NonNull zzqz zzqz2, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            zzac.zzb((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            this.vN = n;
            this.vO = onConnectionFailedListener;
            this.vM = zzqz2;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        public zzh zzaqd() {
            zzxa zzxa2 = zzxa.aAa;
            if (this.vL.containsKey(zzwy.API)) {
                zzxa2 = (zzxa)this.vL.get(zzwy.API);
            }
            return new zzh(this.ec, this.vF, this.vK, this.vH, this.vI, this.fo, this.vJ, zzxa2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoogleApiClient build() {
            zzac.zzb((!this.vL.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            GoogleApiClient googleApiClient = this.zzaqe();
            Set set = vE;
            synchronized (set) {
                vE.add(googleApiClient);
            }
            if (this.vN >= 0) {
                this.zzf(googleApiClient);
            }
            return googleApiClient;
        }

        private GoogleApiClient zzaqe() {
            zzh zzh2 = this.zzaqd();
            Api<?> object = null;
            Api<?> object2 = null;
            Map<Api<?>, zzh.zza> map = zzh2.zzaui();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzqf> arrayList = new ArrayList<zzqf>();
            for (Api<?> object3 : this.vL.keySet()) {
                zzai<Object> zzai2;
                Api.zzd zzd2;
                Api.ApiOptions apiOptions = this.vL.get(object3);
                int n = 0;
                if (map.get(object3) != null) {
                    n = map.get(object3).Cb ? 1 : 2;
                }
                arrayMap.put(object3, n);
                zzqf zzqf2 = new zzqf(object3, n);
                arrayList.add(zzqf2);
                if (object3.zzapq()) {
                    zzd2 = object3.zzapo();
                    if (zzd2.getPriority() == 1) {
                        object2 = object3;
                    }
                    zzai2 = Builder.zza(zzd2, (Object)apiOptions, this.mContext, this.zzajn, zzh2, (ConnectionCallbacks)zzqf2, (OnConnectionFailedListener)zzqf2);
                } else {
                    zzd2 = object3.zzapn();
                    if (zzd2.getPriority() == 1) {
                        object2 = object3;
                    }
                    zzai2 = Builder.zza(zzd2, (Object)apiOptions, this.mContext, this.zzajn, zzh2, (ConnectionCallbacks)zzqf2, (OnConnectionFailedListener)zzqf2);
                }
                arrayMap2.put(object3.zzapp(), zzai2);
                if (!zzai2.zzahs()) continue;
                if (object != null) {
                    zzd2 = String.valueOf(object3.getName());
                    String string = String.valueOf(object.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(zzd2).length() + String.valueOf(string).length()).append((String)((Object)zzd2)).append(" cannot be used with ").append(string).toString());
                }
                object = object3;
            }
            if (object != null) {
                if (object2 != null) {
                    String string = String.valueOf(object.getName());
                    String string2 = String.valueOf(object2.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" cannot be used with ").append(string2).toString());
                }
                zzac.zza((this.ec == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{object.getName()});
                zzac.zza((boolean)this.vF.equals(this.vG), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{object.getName()});
            }
            int n = zzqp.zza(arrayMap2.values(), true);
            return new zzqp(this.mContext, new ReentrantLock(), this.zzajn, zzh2, this.vP, this.vQ, (Map<Api<?>, Integer>)arrayMap, (List<ConnectionCallbacks>)this.vR, (List<OnConnectionFailedListener>)this.vS, (Map<Api.zzc<?>, Api.zze>)arrayMap2, this.vN, n, arrayList);
        }

        private void zzf(GoogleApiClient googleApiClient) {
            zzqa.zza(this.vM).zza(this.vN, googleApiClient, this.vO);
        }

        private <O extends Api.ApiOptions> void zza(Api<O> api, O o, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException(new StringBuilder(90).append("Invalid resolution mode: '").append(n).append("', use a constant from GoogleApiClient.ResolutionMode").toString());
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzapm().zzp(o));
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.vK.put(api, new zzh.zza(hashSet, bl));
        }

        private static <C extends Api.zze, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, zzh zzh2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return zza2.zza(context, looper, zzh2, object, connectionCallbacks, onConnectionFailedListener);
        }

        private static <C extends Api.zzg, O> zzai zza(Api.zzh<C, O> zzh2, Object object, Context context, Looper looper, zzh zzh3, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return new zzai(context, looper, zzh2.zzapt(), connectionCallbacks, onConnectionFailedListener, zzh3, zzh2.zzr(object));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

