/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.common.util.zzs;

public final class zzrt
extends Drawable
implements Drawable.Callback {
    private int AD = 0;
    private long bZ;
    private int mFrom;
    private int AE;
    private int AF = 255;
    private int AG;
    private int AH = 0;
    private boolean Ax = true;
    private boolean AI;
    private zzb AJ;
    private Drawable AK;
    private Drawable AL;
    private boolean AM;
    private boolean AN;
    private boolean AO;
    private int AP;

    public zzrt(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.AQ;
        }
        this.AK = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.AJ.AS |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.AQ;
        }
        this.AL = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.AJ.AS |= drawable3.getChangingConfigurations();
    }

    zzrt(zzb zzb2) {
        this.AJ = new zzb(zzb2);
    }

    @TargetApi(value=11)
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback;
        if (zzs.zzaxk() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @TargetApi(value=11)
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback;
        if (zzs.zzaxk() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    @TargetApi(value=11)
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback;
        if (zzs.zzaxk() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.AJ.mChangingConfigurations | this.AJ.AS;
    }

    public void setAlpha(int n) {
        if (this.AH == this.AF) {
            this.AH = n;
        }
        this.AF = n;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.AK.setColorFilter(colorFilter);
        this.AL.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.AK.getIntrinsicWidth(), this.AL.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.AK.getIntrinsicHeight(), this.AL.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect rect) {
        this.AK.setBounds(rect);
        this.AL.setBounds(rect);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.AJ.mChangingConfigurations = this.getChangingConfigurations();
            return this.AJ;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.AO) {
            this.AP = Drawable.resolveOpacity((int)this.AK.getOpacity(), (int)this.AL.getOpacity());
            this.AO = true;
        }
        return this.AP;
    }

    public boolean canConstantState() {
        if (!this.AM) {
            this.AN = this.AK.getConstantState() != null && this.AL.getConstantState() != null;
            this.AM = true;
        }
        return this.AN;
    }

    public Drawable mutate() {
        if (!this.AI && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.AK.mutate();
            this.AL.mutate();
            this.AI = true;
        }
        return this;
    }

    public Drawable zzatn() {
        return this.AL;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.AE = this.AF;
        this.AH = 0;
        this.AG = n;
        this.AD = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.AD) {
            case 1: {
                this.bZ = SystemClock.uptimeMillis();
                bl = false;
                this.AD = 2;
                break;
            }
            case 2: {
                if (this.bZ < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.bZ) / (float)this.AG;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.AD = 0;
                }
                f = Math.min(f, 1.0f);
                this.AH = (int)(0.0f + (float)(this.AE - 0) * f);
            }
        }
        int n = this.AH;
        boolean bl3 = this.Ax;
        Drawable drawable2 = this.AK;
        Drawable drawable3 = this.AL;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.AF) {
                drawable3.setAlpha(this.AF);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.AF - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.AF);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.AF);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzrt$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzrt$zza AQ = new com.google.android.gms.internal.zzrt$zza();
        private static final zza AR = new zza();

        private com.google.android.gms.internal.zzrt$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return AR;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return AQ;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        int AS;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.mChangingConfigurations = zzb2.mChangingConfigurations;
                this.AS = zzb2.AS;
            }
        }

        public Drawable newDrawable() {
            return new zzrt(this);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

