/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;

public class GoogleApiAvailability
extends zzc {
    private static final GoogleApiAvailability uM = new GoogleApiAvailability();
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";

    public static GoogleApiAvailability getInstance() {
        return uM;
    }

    GoogleApiAvailability() {
    }

    @MainThread
    public Task<Void> makeGooglePlayServicesAvailable(Activity activity) {
        zzac.zzhq((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n = this.isGooglePlayServicesAvailable((Context)activity);
        if (n == 0) {
            return Tasks.forResult(null);
        }
        zzrf zzrf2 = zzrf.zzu(activity);
        zzrf2.zzk(new ConnectionResult(n, null));
        return zzrf2.getTask();
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2) {
        return this.getErrorDialog(activity, n, n2, null);
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.zza((Context)activity, n, "d");
        return this.zza((Context)activity, n, zzj.zza(activity, intent, n2), onCancelListener);
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2) {
        return this.showErrorDialogFragment(activity, n, n2, null);
    }

    public boolean zza(Activity activity, @NonNull zzrb zzrb2, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.zza((Context)activity, n, "d");
        Dialog dialog = this.zza((Context)activity, n, zzj.zza(zzrb2, intent, n2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        this.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Dialog dialog = this.getErrorDialog(activity, n, n2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        this.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public void showErrorNotification(Context context, int n) {
        if (n == 6) {
            Log.e((String)"GoogleApiAvailability", (String)"showErrorNotification(context, errorCode) is called for RESOLUTION_REQUIRED when showErrorNotification(context, result) should be called");
        }
        if (this.isUserResolvableError(n)) {
            GooglePlayServicesUtil.showErrorNotification(n, context);
        }
    }

    public void showErrorNotification(Context context, ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            GooglePlayServicesUtil.zza(connectionResult.getErrorCode(), context, pendingIntent);
        }
    }

    public void zza(Context context, ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            GooglePlayServicesUtil.zza(connectionResult.getErrorCode(), context, GoogleApiActivity.zza(context, pendingIntent, n));
        }
    }

    public Dialog zza(Activity activity, DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        builder.setMessage((CharSequence)com.google.android.gms.common.internal.zzi.zzi((Context)activity, 18));
        builder.setTitle((CharSequence)com.google.android.gms.common.internal.zzi.zzg((Context)activity, 18));
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        this.zza(activity, (Dialog)alertDialog, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return alertDialog;
    }

    @Nullable
    public zzqv zza(Context context, zzqv.zza zza2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zzqv zzqv2 = new zzqv(zza2);
        context.registerReceiver((BroadcastReceiver)zzqv2, intentFilter);
        zzqv2.setContext(context);
        if (!this.zzs(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zza2.zzaqp();
            zzqv2.unregister();
            return null;
        }
        return zzqv2;
    }

    public int isGooglePlayServicesAvailable(Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @Deprecated
    @Nullable
    public Intent zzfl(int n) {
        return super.zzfl(n);
    }

    @Nullable
    public Intent zza(Context context, int n, @Nullable String string2) {
        return super.zza(context, n, string2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        int n = connectionResult.getErrorCode();
        if (zzi.zzcl((Context)context) && n == 2) {
            n = 42;
        }
        return this.getErrorResolutionPendingIntent(context, n, 0);
    }

    @Nullable
    public PendingIntent zza(Context context, int n, int n2, @Nullable String string2) {
        return super.zza(context, n, n2, string2);
    }

    @Nullable
    public String getOpenSourceSoftwareLicenseInfo(Context context) {
        return super.getOpenSourceSoftwareLicenseInfo(context);
    }

    public int zzbo(Context context) {
        return super.zzbo(context);
    }

    public boolean zzd(Context context, int n) {
        return super.zzd(context, n);
    }

    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }

    @TargetApi(value=14)
    Dialog zza(Context context, int n, zzj zzj2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        Object object;
        if (n == 0) {
            return null;
        }
        if (zzi.zzcl((Context)context) && n == 2) {
            n = 42;
        }
        AlertDialog.Builder builder = null;
        if (zzs.zzaxn()) {
            object = new TypedValue();
            context.getTheme().resolveAttribute(16843529, object, true);
            string2 = context.getResources().getResourceEntryName(object.resourceId);
            if ("Theme.Dialog.Alert".equals(string2)) {
                builder = new AlertDialog.Builder(context, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder(context);
        }
        builder.setMessage((CharSequence)com.google.android.gms.common.internal.zzi.zzi(context, n));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        if ((object = com.google.android.gms.common.internal.zzi.zzk(context, n)) != null) {
            builder.setPositiveButton((CharSequence)object, (DialogInterface.OnClickListener)zzj2);
        }
        if ((string2 = com.google.android.gms.common.internal.zzi.zzg(context, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    @TargetApi(value=11)
    void zza(Activity activity, Dialog dialog, String string2, DialogInterface.OnCancelListener onCancelListener) {
        boolean bl;
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, onCancelListener);
            supportErrorDialogFragment.show(fragmentManager, string2);
        } else if (zzs.zzaxk()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, onCancelListener);
            errorDialogFragment.show(fragmentManager, string2);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
    }
}

