/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzqs;
import java.lang.ref.WeakReference;

public class zzqx<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> vw = null;
    private zzqx<? extends Result> vx = null;
    private volatile ResultCallbacks<? super R> vy = null;
    private PendingResult<R> vz = null;
    private final Object sT = new Object();
    private Status vA = null;
    private final WeakReference<GoogleApiClient> sV;
    private final zza vB;
    private boolean vC = false;

    public zzqx(WeakReference<GoogleApiClient> weakReference) {
        zzab.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.sV = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.sV.get();
        this.vB = new zza(googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.sT;
        synchronized (object) {
            zzab.zza((this.vw == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzab.zza((this.vy == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.vw = resultTransform;
            zzqx<R> zzqx2 = new zzqx<R>(this.sV);
            this.vx = zzqx2;
            this.zzaqw();
            return zzqx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.sT;
        synchronized (object) {
            zzab.zza((this.vy == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzab.zza((this.vw == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.vy = resultCallbacks;
            this.zzaqw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(R r) {
        Object object = this.sT;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.vw != null) {
                    zzqr.zzaqc().submit(new Runnable((Result)r){
                        final /* synthetic */ Result vD;
                        {
                            this.vD = result;
                        }

                        @Override
                        @WorkerThread
                        public void run() {
                            try {
                                zzpo.sS.set(true);
                                PendingResult pendingResult = zzqx.this.vw.onSuccess(this.vD);
                                zzqx.this.vB.sendMessage(zzqx.this.vB.obtainMessage(0, pendingResult));
                            }
                            catch (RuntimeException runtimeException) {
                                zzqx.this.vB.sendMessage(zzqx.this.vB.obtainMessage(1, runtimeException));
                            }
                            finally {
                                zzpo.sS.set(false);
                                zzqx.this.zze(this.vD);
                                GoogleApiClient googleApiClient = (GoogleApiClient)zzqx.this.sV.get();
                                if (googleApiClient != null) {
                                    googleApiClient.zzb(zzqx.this);
                                }
                            }
                        }
                    });
                } else if (this.zzaqy()) {
                    this.vy.onSuccess(r);
                }
            } else {
                this.zzac(r.getStatus());
                this.zze((Result)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(PendingResult<?> pendingResult) {
        Object object = this.sT;
        synchronized (object) {
            this.vz = pendingResult;
            this.zzaqw();
        }
    }

    private void zzaqw() {
        if (this.vw == null && this.vy == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.sV.get();
        if (!this.vC && this.vw != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.vC = true;
        }
        if (this.vA != null) {
            this.zzad(this.vA);
        } else if (this.vz != null) {
            this.vz.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzac(Status status) {
        Object object = this.sT;
        synchronized (object) {
            this.vA = status;
            this.zzad(this.vA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzad(Status status) {
        Object object = this.sT;
        synchronized (object) {
            if (this.vw != null) {
                Status status2 = this.vw.onFailure(status);
                zzab.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzac(status2);
            } else if (this.zzaqy()) {
                this.vy.onFailure(status);
            }
        }
    }

    void zzaqx() {
        this.vy = null;
    }

    private boolean zzaqy() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.sV.get();
        return this.vy != null && googleApiClient != null;
    }

    private void zze(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    PendingResult pendingResult = (PendingResult)message.obj;
                    Object object = zzqx.this.sT;
                    synchronized (object) {
                        if (pendingResult == null) {
                            ((zzqx)zzqx.this.vx).zzac(new Status(13, "Transform returned null"));
                        } else if (pendingResult instanceof zzqs) {
                            ((zzqx)zzqx.this.vx).zzac(((zzqs)pendingResult).getStatus());
                        } else {
                            zzqx.this.vx.zza(pendingResult);
                        }
                        break;
                    }
                }
                case 1: {
                    RuntimeException runtimeException = (RuntimeException)message.obj;
                    String string2 = String.valueOf(runtimeException.getMessage());
                    Log.e((String)"TransformedResultImpl", (String)(string2.length() != 0 ? "Runtime exception on the transformation worker thread: ".concat(string2) : new String("Runtime exception on the transformation worker thread: ")));
                    throw runtimeException;
                }
                default: {
                    int n = message.what;
                    Log.e((String)"TransformedResultImpl", (String)new StringBuilder(70).append("TransformationResultHandler received unknown message type: ").append(n).toString());
                }
            }
        }
    }
}

