/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzpp;
import com.google.android.gms.internal.zzpv;
import com.google.android.gms.internal.zzpw;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.internal.zzpz;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqt;
import com.google.android.gms.internal.zzvu;
import com.google.android.gms.internal.zzvv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzqa
implements zzqh {
    private final Lock tr;
    private final Condition uv;
    private final Context mContext;
    private final zzc tz;
    private final zzb uw;
    final Map<Api.zzc<?>, Api.zze> ui;
    final Map<Api.zzc<?>, ConnectionResult> ux = new HashMap();
    final zzg tN;
    final Map<Api<?>, Integer> tO;
    final Api.zza<? extends zzvu, zzvv> si;
    private volatile zzpz uy;
    private ConnectionResult uz = null;
    int uA;
    final zzpy th;
    final zzqh.zza uB;

    public zzqa(Context context, zzpy zzpy2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zzvu, zzvv> zza2, ArrayList<zzpp> arrayList, zzqh.zza zza3) {
        this.mContext = context;
        this.tr = lock;
        this.tz = zzc2;
        this.ui = map;
        this.tN = zzg2;
        this.tO = map2;
        this.si = zza2;
        this.th = zzpy2;
        this.uB = zza3;
        for (zzpp zzpp2 : arrayList) {
            zzpp2.zza(this);
        }
        this.uw = new zzb(looper);
        this.uv = lock.newCondition();
        this.uy = new zzpx(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzpm.zza<R, A>> T zzc(@NonNull T t) {
        t.zzaow();
        return this.uy.zzc(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzpm.zza<? extends Result, A>> T zzd(@NonNull T t) {
        t.zzaow();
        return this.uy.zzd(t);
    }

    @Override
    public void connect() {
        this.uy.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.uv.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.rb;
        }
        if (this.uz != null) {
            return this.uz;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.uv.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.rb;
        }
        if (this.uz != null) {
            return this.uz;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        boolean bl = this.uy.disconnect();
        if (bl) {
            this.ux.clear();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzans();
        if (this.ui.containsKey(zzc2)) {
            if (this.ui.get(zzc2).isConnected()) {
                return ConnectionResult.rb;
            }
            if (this.ux.containsKey(zzc2)) {
                return this.ux.get(zzc2);
            }
        }
        return null;
    }

    void zzapz() {
        this.tr.lock();
        try {
            this.uy = new zzpw(this, this.tN, this.tO, this.tz, this.si, this.tr, this.mContext);
            this.uy.begin();
            this.uv.signalAll();
        }
        finally {
            this.tr.unlock();
        }
    }

    void zzaqa() {
        this.tr.lock();
        try {
            this.th.zzapw();
            this.uy = new zzpv(this);
            this.uy.begin();
            this.uv.signalAll();
        }
        finally {
            this.tr.unlock();
        }
    }

    void zzi(ConnectionResult connectionResult) {
        this.tr.lock();
        try {
            this.uz = connectionResult;
            this.uy = new zzpx(this);
            this.uy.begin();
            this.uv.signalAll();
        }
        finally {
            this.tr.unlock();
        }
    }

    void zzaqb() {
        for (Api.zze zze2 : this.ui.values()) {
            zze2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.uy instanceof zzpv;
    }

    @Override
    public boolean isConnecting() {
        return this.uy instanceof zzpw;
    }

    @Override
    public boolean zza(zzqt zzqt2) {
        return false;
    }

    @Override
    public void zzaof() {
    }

    @Override
    public void zzapb() {
        if (this.isConnected()) {
            ((zzpv)this.uy).zzapk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, int n) {
        this.tr.lock();
        try {
            this.uy.zza(connectionResult, api, n);
        }
        finally {
            this.tr.unlock();
        }
    }

    public void onConnected(@Nullable Bundle bundle) {
        this.tr.lock();
        try {
            this.uy.onConnected(bundle);
        }
        finally {
            this.tr.unlock();
        }
    }

    public void onConnectionSuspended(int n) {
        this.tr.lock();
        try {
            this.uy.onConnectionSuspended(n);
        }
        finally {
            this.tr.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.uw.obtainMessage(1, zza2);
        this.uw.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.uw.obtainMessage(2, runtimeException);
        this.uw.sendMessage(message);
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.uy);
        for (Api<?> api : this.tO.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            Api.zze zze2 = this.ui.get(api.zzans());
            zze2.dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static abstract class zza {
        private final zzpz uC;

        protected zza(zzpz zzpz2) {
            this.uC = zzpz2;
        }

        public final void zzd(zzqa zzqa2) {
            zzqa2.tr.lock();
            try {
                if (zzqa2.uy != this.uC) {
                    return;
                }
                this.zzapl();
            }
            finally {
                zzqa2.tr.unlock();
            }
        }

        protected abstract void zzapl();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zza zza2 = (zza)message.obj;
                    zza2.zzd(zzqa.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)message.obj;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GACStateManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }
}

