/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzpz;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqb;
import com.google.android.gms.internal.zzvu;
import com.google.android.gms.internal.zzvv;
import com.google.android.gms.signin.internal.SignInResponse;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzpw
implements zzpz {
    private final zzqa tw;
    private final Lock tr;
    private final Context mContext;
    private final com.google.android.gms.common.zzc tz;
    private ConnectionResult tA;
    private int tB;
    private int tC = 0;
    private int tD;
    private final Bundle tE = new Bundle();
    private final Set<Api.zzc> tF = new HashSet<Api.zzc>();
    private zzvu tG;
    private int tH;
    private boolean tI;
    private boolean tJ;
    private zzq tK;
    private boolean tL;
    private boolean tM;
    private final zzg tN;
    private final Map<Api<?>, Integer> tO;
    private final Api.zza<? extends zzvu, zzvv> si;
    private ArrayList<Future<?>> tP = new ArrayList();

    public zzpw(zzqa zzqa2, zzg zzg2, Map<Api<?>, Integer> map, com.google.android.gms.common.zzc zzc2, Api.zza<? extends zzvu, zzvv> zza2, Lock lock, Context context) {
        this.tw = zzqa2;
        this.tN = zzg2;
        this.tO = map;
        this.tz = zzc2;
        this.si = zza2;
        this.tr = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.tw.ux.clear();
        this.tI = false;
        this.tA = null;
        this.tC = 0;
        this.tH = 2;
        this.tJ = false;
        this.tL = false;
        boolean bl = false;
        HashMap<Api.zze, zza> hashMap = new HashMap<Api.zze, zza>();
        for (Api<?> api : this.tO.keySet()) {
            Api.zze zze2 = this.tw.ui.get(api.zzans());
            int n = this.tO.get(api);
            bl |= api.zzanp().getPriority() == 1;
            if (zze2.zzafk()) {
                this.tI = true;
                if (n < this.tH) {
                    this.tH = n;
                }
                if (n != 0) {
                    this.tF.add(api.zzans());
                }
            }
            hashMap.put(zze2, new zza(this, api, n));
        }
        if (bl) {
            this.tI = false;
        }
        if (this.tI) {
            this.tN.zzc(this.tw.th.getSessionId());
            zze zze3 = new zze();
            this.tG = this.si.zza(this.mContext, this.tw.th.getLooper(), this.tN, this.tN.zzasp(), zze3, zze3);
        }
        this.tD = this.tw.ui.size();
        this.tP.add(zzqb.zzaqc().submit(new zzb(hashMap)));
    }

    private boolean zzapm() {
        --this.tD;
        if (this.tD > 0) {
            return false;
        }
        if (this.tD < 0) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.tw.th.zzapy());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        if (this.tA != null) {
            this.tw.uA = this.tB;
            this.zzg(this.tA);
            return false;
        }
        return true;
    }

    private void zza(SignInResponse signInResponse) {
        if (!this.zzfi(0)) {
            return;
        }
        ConnectionResult connectionResult = signInResponse.zzath();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = signInResponse.zzbzz();
            ConnectionResult connectionResult2 = resolveAccountResponse.zzath();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zzg(connectionResult2);
                return;
            }
            this.tJ = true;
            this.tK = resolveAccountResponse.zzatg();
            this.tL = resolveAccountResponse.zzati();
            this.tM = resolveAccountResponse.zzatj();
            this.zzapn();
        } else if (this.zzf(connectionResult)) {
            this.zzapq();
            this.zzapn();
        } else {
            this.zzg(connectionResult);
        }
    }

    private void zzapn() {
        if (this.tD != 0) {
            return;
        }
        if (!this.tI || this.tJ) {
            this.zzapo();
        }
    }

    private void zzapo() {
        ArrayList<Api.zze> arrayList = new ArrayList<Api.zze>();
        this.tC = 1;
        this.tD = this.tw.ui.size();
        for (Api.zzc<?> zzc2 : this.tw.ui.keySet()) {
            if (this.tw.ux.containsKey(zzc2)) {
                if (!this.zzapm()) continue;
                this.zzapp();
                continue;
            }
            arrayList.add(this.tw.ui.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.tP.add(zzqb.zzaqc().submit(new zzc(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle bundle) {
        if (!this.zzfi(1)) {
            return;
        }
        if (bundle != null) {
            this.tE.putAll(bundle);
        }
        if (this.zzapm()) {
            this.zzapp();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzfi(1)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzapm()) {
            this.zzapp();
        }
    }

    private void zzapp() {
        this.tw.zzaqa();
        zzqb.zzaqc().execute(new Runnable(){

            @Override
            public void run() {
                zzpw.this.tz.zzbp(zzpw.this.mContext);
            }
        });
        if (this.tG != null) {
            if (this.tL) {
                this.tG.zza(this.tK, this.tM);
            }
            this.zzbm(false);
        }
        for (Api.zzc<?> zzc2 : this.tw.ux.keySet()) {
            Api.zze zze2 = this.tw.ui.get(zzc2);
            zze2.disconnect();
        }
        Bundle bundle = this.tE.isEmpty() ? null : this.tE;
        this.tw.uB.zzm(bundle);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzpm.zza<R, A>> T zzc(T t) {
        this.tw.th.uc.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzpm.zza<? extends Result, A>> T zzd(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
    }

    @Override
    public boolean disconnect() {
        this.zzapr();
        this.zzbm(true);
        this.tw.zzi(null);
        return true;
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzg(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzanp().getPriority(), n, connectionResult)) {
            this.tA = connectionResult;
            this.tB = n2;
        }
        this.tw.ux.put(api.zzans(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zze(connectionResult)) {
            return false;
        }
        return this.tA == null || n < this.tB;
    }

    private boolean zze(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.tz.zzfc(connectionResult.getErrorCode()) != null;
    }

    private void zzapq() {
        this.tI = false;
        this.tw.th.uj = Collections.emptySet();
        for (Api.zzc zzc2 : this.tF) {
            if (this.tw.ux.containsKey(zzc2)) continue;
            this.tw.ux.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zzf(ConnectionResult connectionResult) {
        return this.tH == 2 || this.tH == 1 && !connectionResult.hasResolution();
    }

    private void zzg(ConnectionResult connectionResult) {
        this.zzapr();
        this.zzbm(!connectionResult.hasResolution());
        this.tw.zzi(connectionResult);
        this.tw.uB.zzd(connectionResult);
    }

    private void zzbm(boolean bl) {
        if (this.tG != null) {
            if (this.tG.isConnected() && bl) {
                this.tG.zzbzo();
            }
            this.tG.disconnect();
            this.tK = null;
        }
    }

    private void zzapr() {
        for (Future<?> future : this.tP) {
            future.cancel(true);
        }
        this.tP.clear();
    }

    private Set<Scope> zzaps() {
        if (this.tN == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.tN.zzasj());
        Map<Api<?>, zzg.zza> map = this.tN.zzasl();
        for (Api<?> api : map.keySet()) {
            if (this.tw.ux.containsKey(api.zzans())) continue;
            hashSet.addAll(map.get(api).dT);
        }
        return hashSet;
    }

    private boolean zzfi(int n) {
        if (this.tC != n) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.tw.th.zzapy());
            String string2 = String.valueOf(this);
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.tD;
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = String.valueOf(this.zzfj(this.tC));
            String string4 = String.valueOf(this.zzfj(n));
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzfj(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zzd
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzpw> tR;

        zzd(zzpw zzpw2) {
            this.tR = new WeakReference<zzpw>(zzpw2);
        }

        @Override
        @BinderThread
        public void zzb(final SignInResponse signInResponse) {
            final zzpw zzpw2 = (zzpw)this.tR.get();
            if (zzpw2 == null) {
                return;
            }
            zzpw2.tw.zza(new zzqa.zza(zzpw2){

                @Override
                public void zzapl() {
                    zzpw2.zza(signInResponse);
                }
            });
        }
    }

    private static class zza
    implements zzd.zzf {
        private final WeakReference<zzpw> tR;
        private final Api<?> pN;
        private final int tf;

        public zza(zzpw zzpw2, Api<?> api, int n) {
            this.tR = new WeakReference<zzpw>(zzpw2);
            this.pN = api;
            this.tf = n;
        }

        public void zzh(@NonNull ConnectionResult connectionResult) {
            zzpw zzpw2 = (zzpw)this.tR.get();
            if (zzpw2 == null) {
                return;
            }
            zzab.zza((Looper.myLooper() == ((zzpw)zzpw2).tw.th.getLooper() ? 1 : 0) != 0, (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzpw2.tr.lock();
            try {
                if (!zzpw2.zzfi(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzpw2.zzb(connectionResult, this.pN, this.tf);
                }
                if (zzpw2.zzapm()) {
                    zzpw2.zzapn();
                }
            }
            finally {
                zzpw2.tr.unlock();
            }
        }
    }

    private class zze
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zze() {
        }

        @Override
        public void onConnected(Bundle bundle) {
            zzpw.this.tG.zza(new zzd(zzpw.this));
        }

        @Override
        public void onConnectionSuspended(int n) {
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzpw.this.tr.lock();
            try {
                if (zzpw.this.zzf(connectionResult)) {
                    zzpw.this.zzapq();
                    zzpw.this.zzapn();
                } else {
                    zzpw.this.zzg(connectionResult);
                }
            }
            finally {
                zzpw.this.tr.unlock();
            }
        }
    }

    private class zzc
    extends zzf {
        private final ArrayList<Api.zze> tW;

        public zzc(ArrayList<Api.zze> arrayList) {
            this.tW = arrayList;
        }

        @Override
        @WorkerThread
        public void zzapl() {
            ((zzpw)zzpw.this).tw.th.uj = zzpw.this.zzaps();
            for (Api.zze zze2 : this.tW) {
                zze2.zza(zzpw.this.tK, ((zzpw)zzpw.this).tw.th.uj);
            }
        }
    }

    private class zzb
    extends zzf {
        private final Map<Api.zze, zza> tS;

        public zzb(Map<Api.zze, zza> map) {
            this.tS = map;
        }

        @Override
        @WorkerThread
        public void zzapl() {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            for (Api.zze object : this.tS.keySet()) {
                if (object.zzanu()) {
                    bl2 = true;
                    if (this.tS.get(object).tf != 0) continue;
                    bl = true;
                    break;
                }
                bl3 = false;
            }
            int n2 = n = bl2 ? zzpw.this.tz.isGooglePlayServicesAvailable(zzpw.this.mContext) : 0;
            if (n != 0 && (bl || bl3)) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzpw.this.tw.zza(new zzqa.zza(zzpw.this){

                    @Override
                    public void zzapl() {
                        zzpw.this.zzg(connectionResult);
                    }
                });
                return;
            }
            if (zzpw.this.tI) {
                zzpw.this.tG.connect();
            }
            for (Api.zze zze2 : this.tS.keySet()) {
                final zzd.zzf zzf2 = this.tS.get(zze2);
                if (zze2.zzanu() && n != 0) {
                    zzpw.this.tw.zza(new zzqa.zza(zzpw.this){

                        @Override
                        public void zzapl() {
                            zzf2.zzh(new ConnectionResult(16, null));
                        }
                    });
                    continue;
                }
                zze2.zza(zzf2);
            }
        }
    }

    private abstract class zzf
    implements Runnable {
        private zzf() {
        }

        @Override
        @WorkerThread
        public void run() {
            zzpw.this.tr.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzapl();
            }
            catch (RuntimeException runtimeException) {
                zzpw.this.tw.zza(runtimeException);
            }
            finally {
                zzpw.this.tr.unlock();
            }
        }

        @WorkerThread
        protected abstract void zzapl();
    }
}

