/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new zzb();
    private final int mVersionCode;
    private final Uri wP;
    private final int zzaie;
    private final int zzaif;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.mVersionCode = n;
        this.wP = uri;
        this.zzaie = n2;
        this.zzaif = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzn(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    private static Uri zzn(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.wP;
    }

    public int getWidth() {
        return this.zzaie;
    }

    public int getHeight() {
        return this.zzaif;
    }

    public String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzaie, this.zzaif, this.wP.toString());
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.wP.toString());
            jSONObject.put("width", this.zzaie);
            jSONObject.put("height", this.zzaif);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzaa.equal((Object)this.wP, (Object)webImage.wP) && this.zzaie == webImage.zzaie && this.zzaif == webImage.zzaif;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.wP, this.zzaie, this.zzaif});
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }
}

