/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzpp;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqt;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.internal.zzvt;
import com.google.android.gms.internal.zzvu;
import com.google.android.gms.internal.zzvv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> rW = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = rW;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : rW) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<GoogleApiClient> zzaoe() {
        Set<GoogleApiClient> set = rW;
        synchronized (set) {
            return rW;
        }
    }

    public <A extends Api.zzb, R extends Result, T extends zzpm.zza<R, A>> T zzc(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzpm.zza<? extends Result, A>> T zzd(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzqn<L> zzs(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzqt zzqt2) {
        throw new UnsupportedOperationException();
    }

    public void zzaof() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzqx zzqx2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzqx zzqx2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account aL;
        private final Set<Scope> rX = new HashSet<Scope>();
        private final Set<Scope> rY = new HashSet<Scope>();
        private int rZ;
        private View sa;
        private String bX;
        private String sb;
        private final Map<Api<?>, zzg.zza> sc = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> sd = new ArrayMap();
        private zzqi se;
        private int sf = -1;
        private OnConnectionFailedListener sg;
        private Looper zzahv;
        private GoogleApiAvailability sh = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzvu, zzvv> si = zzvt.bK;
        private final ArrayList<ConnectionCallbacks> sj = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> sk = new ArrayList();

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzahv = context.getMainLooper();
            this.bX = context.getPackageName();
            this.sb = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzab.zzb((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.sj.add(connectionCallbacks);
            zzab.zzb((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.sk.add(onConnectionFailedListener);
        }

        public Builder setHandler(@NonNull Handler handler) {
            zzab.zzb((Object)handler, (Object)"Handler must not be null");
            this.zzahv = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzab.zzb((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.sj.add(connectionCallbacks);
            return this;
        }

        public Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzab.zzb((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.sk.add(onConnectionFailedListener);
            return this;
        }

        public Builder setViewForPopups(@NonNull View view) {
            zzab.zzb((Object)view, (Object)"View must not be null");
            this.sa = view;
            return this;
        }

        public Builder addScope(@NonNull Scope scope) {
            zzab.zzb((Object)scope, (Object)"Scope must not be null");
            this.rX.add(scope);
            return this;
        }

        public Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzab.zzb(api, (Object)"Api must not be null");
            this.sd.put(api, null);
            List<Scope> list = api.zzanp().zzp(null);
            this.rY.addAll(list);
            this.rX.addAll(list);
            return this;
        }

        public Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzab.zzb(api, (Object)"Api must not be null");
            this.sd.put(api, null);
            this.zza(api, null, 1, scopeArray);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzab.zzb(api, (Object)"Api must not be null");
            zzab.zzb(o, (Object)"Null options are not permitted for this Api");
            this.sd.put(api, o);
            List<Scope> list = api.zzanp().zzp(o);
            this.rY.addAll(list);
            this.rX.addAll(list);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzab.zzb(api, (Object)"Api must not be null");
            zzab.zzb(o, (Object)"Null options are not permitted for this Api");
            this.sd.put(api, o);
            this.zza(api, o, 1, scopeArray);
            return this;
        }

        public Builder setAccountName(String string2) {
            this.aL = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int n) {
            this.rZ = n;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.zza(new zzqi((Activity)fragmentActivity), n, onConnectionFailedListener);
        }

        private Builder zza(@NonNull zzqi zzqi2, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            zzab.zzb((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            this.sf = n;
            this.sg = onConnectionFailedListener;
            this.se = zzqi2;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        public zzg zzaoh() {
            zzvv zzvv2 = zzvv.atR;
            if (this.sd.containsKey(zzvt.API)) {
                zzvv2 = (zzvv)this.sd.get(zzvt.API);
            }
            return new zzg(this.aL, this.rX, this.sc, this.rZ, this.sa, this.bX, this.sb, zzvv2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoogleApiClient build() {
            zzab.zzb((!this.sd.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            GoogleApiClient googleApiClient = this.zzaoi();
            Set set = rW;
            synchronized (set) {
                rW.add(googleApiClient);
            }
            if (this.sf >= 0) {
                this.zzf(googleApiClient);
            }
            return googleApiClient;
        }

        private GoogleApiClient zzaoi() {
            zzg zzg2 = this.zzaoh();
            Api<?> object = null;
            Api<?> object2 = null;
            Map<Api<?>, zzg.zza> map = zzg2.zzasl();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzpp> arrayList = new ArrayList<zzpp>();
            for (Api<?> object3 : this.sd.keySet()) {
                zzah<Object> zzah2;
                Api.zzd zzd2;
                Api.ApiOptions apiOptions = this.sd.get(object3);
                int n = 0;
                if (map.get(object3) != null) {
                    n = map.get(object3).yn ? 1 : 2;
                }
                arrayMap.put(object3, n);
                zzpp zzpp2 = new zzpp(object3, n);
                arrayList.add(zzpp2);
                if (object3.zzant()) {
                    zzd2 = object3.zzanr();
                    if (zzd2.getPriority() == 1) {
                        object2 = object3;
                    }
                    zzah2 = Builder.zza(zzd2, (Object)apiOptions, this.mContext, this.zzahv, zzg2, (ConnectionCallbacks)zzpp2, (OnConnectionFailedListener)zzpp2);
                } else {
                    zzd2 = object3.zzanq();
                    if (zzd2.getPriority() == 1) {
                        object2 = object3;
                    }
                    zzah2 = Builder.zza(zzd2, (Object)apiOptions, this.mContext, this.zzahv, zzg2, (ConnectionCallbacks)zzpp2, (OnConnectionFailedListener)zzpp2);
                }
                arrayMap2.put(object3.zzans(), zzah2);
                if (!zzah2.zzafz()) continue;
                if (object != null) {
                    zzd2 = String.valueOf(object3.getName());
                    String string2 = String.valueOf(object.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(zzd2).length() + String.valueOf(string2).length()).append((String)((Object)zzd2)).append(" cannot be used with ").append(string2).toString());
                }
                object = object3;
            }
            if (object != null) {
                if (object2 != null) {
                    String string3 = String.valueOf(object.getName());
                    String string4 = String.valueOf(object2.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append(" cannot be used with ").append(string4).toString());
                }
                zzab.zza((this.aL == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{object.getName()});
                zzab.zza((boolean)this.rX.equals(this.rY), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{object.getName()});
            }
            int n = zzpy.zza(arrayMap2.values(), true);
            return new zzpy(this.mContext, new ReentrantLock(), this.zzahv, zzg2, this.sh, this.si, (Map<Api<?>, Integer>)arrayMap, (List<ConnectionCallbacks>)this.sj, (List<OnConnectionFailedListener>)this.sk, (Map<Api.zzc<?>, Api.zze>)arrayMap2, this.sf, n, arrayList);
        }

        private void zzf(GoogleApiClient googleApiClient) {
            zzpk.zza(this.se).zza(this.sf, googleApiClient, this.sg);
        }

        private <O extends Api.ApiOptions> void zza(Api<O> api, O o, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException(new StringBuilder(90).append("Invalid resolution mode: '").append(n).append("', use a constant from GoogleApiClient.ResolutionMode").toString());
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzanp().zzp(o));
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.sc.put(api, new zzg.zza(hashSet, bl));
        }

        private static <C extends Api.zze, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, zzg zzg2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return zza2.zza(context, looper, zzg2, object, connectionCallbacks, onConnectionFailedListener);
        }

        private static <C extends Api.zzg, O> zzah zza(Api.zzh<C, O> zzh2, Object object, Context context, Looper looper, zzg zzg2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return new zzah(context, looper, zzh2.zzanw(), connectionCallbacks, onConnectionFailedListener, zzg2, zzh2.zzr(object));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

