/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzpo;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zzpo<BatchResult> {
    private int rH;
    private boolean rI;
    private boolean rJ;
    private final PendingResult<?>[] rK;
    private final Object zzail = new Object();

    private Batch(List<PendingResult<?>> list, GoogleApiClient googleApiClient) {
        super(googleApiClient);
        this.rH = list.size();
        this.rK = new PendingResult[this.rH];
        if (list.isEmpty()) {
            this.zzc(new BatchResult(Status.sq, this.rK));
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PendingResult<?> pendingResult = list.get(i);
            this.rK[i] = pendingResult;
            pendingResult.zza(new PendingResult.zza(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzv(Status status) {
                    Object object = Batch.this.zzail;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.rJ = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.rI = true;
                        }
                        Batch.this.rH--;
                        if (Batch.this.rH == 0) {
                            if (Batch.this.rJ) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.rI ? new Status(13) : Status.sq;
                                Batch.this.zzc(new BatchResult(status2, Batch.this.rK));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.rK) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.rK);
    }

    @Override
    public /* synthetic */ Result zzc(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> rM = new ArrayList();
        private GoogleApiClient gY;

        public Builder(GoogleApiClient googleApiClient) {
            this.gY = googleApiClient;
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.rM.size());
            this.rM.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.rM, this.gY);
        }
    }
}

