/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope dK = new Scope("profile");
    public static final Scope dL = new Scope("email");
    public static final Scope dM = new Scope("openid");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzb();
    final int versionCode;
    private final ArrayList<Scope> dN;
    private Account aL;
    private boolean dO;
    private final boolean dP;
    private final boolean dQ;
    private String dR;
    private String dS;
    private static Comparator<Scope> dJ = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzaok().compareTo(scope2.zzaok());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInOptions zzfq(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(hashSet, account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null));
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this.versionCode = n;
        this.dN = arrayList;
        this.aL = account;
        this.dO = bl;
        this.dP = bl2;
        this.dQ = bl3;
        this.dR = string2;
        this.dS = string3;
    }

    private GoogleSignInOptions(Set<Scope> set, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this(2, new ArrayList<Scope>(set), account, bl, bl2, bl3, string2, string3);
    }

    public ArrayList<Scope> zzafq() {
        return new ArrayList<Scope>(this.dN);
    }

    public Scope[] getScopeArray() {
        return this.dN.toArray(new Scope[this.dN.size()]);
    }

    public Account getAccount() {
        return this.aL;
    }

    public boolean zzafr() {
        return this.dO;
    }

    public boolean zzafs() {
        return this.dP;
    }

    public boolean zzaft() {
        return this.dQ;
    }

    public String zzafu() {
        return this.dR;
    }

    public String zzafv() {
        return this.dS;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.dN.size() != googleSignInOptions.zzafq().size() || !this.dN.containsAll(googleSignInOptions.zzafq())) {
                return false;
            }
            return (this.aL == null ? googleSignInOptions.getAccount() == null : this.aL.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.dR) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzafu()) : this.dR.equals(googleSignInOptions.zzafu())) && this.dQ == googleSignInOptions.zzaft() && this.dO == googleSignInOptions.zzafr() && this.dP == googleSignInOptions.zzafs();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.dN) {
            arrayList.add(scope.zzaok());
        }
        Collections.sort(arrayList);
        return new zze().zzq(arrayList).zzq(this.aL).zzq(this.dR).zzba(this.dQ).zzba(this.dO).zzba(this.dP).zzagc();
    }

    public String zzafn() {
        return this.zzafp().toString();
    }

    private JSONObject zzafp() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.dN, dJ);
            for (Scope scope : this.dN) {
                jSONArray.put((Object)scope.zzaok());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.aL != null) {
                jSONObject.put("accountName", (Object)this.aL.name);
            }
            jSONObject.put("idTokenRequested", this.dO);
            jSONObject.put("forceCodeForRefreshToken", this.dQ);
            jSONObject.put("serverAuthRequested", this.dP);
            if (!TextUtils.isEmpty((CharSequence)this.dR)) {
                jSONObject.put("serverClientId", (Object)this.dR);
            }
            if (!TextUtils.isEmpty((CharSequence)this.dS)) {
                jSONObject.put("hostedDomain", (Object)this.dS);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> dT = new HashSet<Scope>();
        private boolean dP;
        private boolean dQ;
        private boolean dO;
        private String dR;
        private Account aL;
        private String dS;

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzab.zzy((Object)googleSignInOptions);
            this.dT = new HashSet<Scope>(googleSignInOptions.dN);
            this.dP = googleSignInOptions.dP;
            this.dQ = googleSignInOptions.dQ;
            this.dO = googleSignInOptions.dO;
            this.dR = googleSignInOptions.dR;
            this.aL = googleSignInOptions.aL;
            this.dS = googleSignInOptions.dS;
        }

        public Builder requestId() {
            this.dT.add(dM);
            return this;
        }

        public Builder requestEmail() {
            this.dT.add(dL);
            return this;
        }

        public Builder requestProfile() {
            this.dT.add(dK);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.dT.add(scope);
            this.dT.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public Builder requestIdToken(String string2) {
            this.dO = true;
            this.dR = this.zzfr(string2);
            return this;
        }

        public Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public Builder requestServerAuthCode(String string2, boolean bl) {
            this.dP = true;
            this.dR = this.zzfr(string2);
            this.dQ = bl;
            return this;
        }

        public Builder setAccountName(String string2) {
            this.aL = new Account(zzab.zzhr((String)string2), "com.google");
            return this;
        }

        public Builder setHostedDomain(String string2) {
            this.dS = zzab.zzhr((String)string2);
            return this;
        }

        public GoogleSignInOptions build() {
            if (this.dO && (this.aL == null || !this.dT.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(this.dT, this.aL, this.dO, this.dP, this.dQ, this.dR, this.dS);
        }

        private String zzfr(String string2) {
            zzab.zzhr((String)string2);
            zzab.zzb((this.dR == null || this.dR.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

