/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzpn;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzpw;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class zzqh
implements Handler.Callback {
    private long tV = 5000L;
    private long tU = 120000L;
    private long uv = 10000L;
    private static final Object zzamp = new Object();
    private static zzqh uw;
    private final Context mContext;
    private final GoogleApiAvailability rX;
    private int ux = -1;
    private final AtomicInteger uy = new AtomicInteger(1);
    private final SparseArray<zzc<?>> uz = new SparseArray();
    private final Map<zzpo<?>, zzc<?>> uA = new ConcurrentHashMap(5, 0.75f, 1);
    private zzpw uB = null;
    private final Set<zzpo<?>> uC = new com.google.android.gms.common.util.zza();
    private final Handler mHandler;
    private final ReferenceQueue<com.google.android.gms.common.api.zzc<?>> uD = new ReferenceQueue();
    private final SparseArray<zza> uE = new SparseArray();
    private zzb uF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<zzqh, Integer> zza(Context context, com.google.android.gms.common.api.zzc<?> zzc2) {
        Object object = zzamp;
        synchronized (object) {
            if (uw == null) {
                uw = new zzqh(context.getApplicationContext());
            }
            int n = uw.zza(zzc2);
            return Pair.create((Object)uw, (Object)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzqh zzaqa() {
        Object object = zzamp;
        synchronized (object) {
            return uw;
        }
    }

    private zzqh(Context context) {
        this(context, GoogleApiAvailability.getInstance());
    }

    private zzqh(Context context, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper(), (Handler.Callback)this);
        this.rX = googleApiAvailability;
    }

    private int zza(com.google.android.gms.common.api.zzc<?> zzc2) {
        int n = this.uy.getAndIncrement();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, n, 0, zzc2));
        return n;
    }

    @WorkerThread
    private void zza(com.google.android.gms.common.api.zzc<?> zzc2, int n) {
        zzpo<?> zzpo2 = zzc2.zzany();
        if (!this.uA.containsKey(zzpo2)) {
            this.uA.put(zzpo2, new zzc(zzc2));
        }
        zzc<?> zzc3 = this.uA.get(zzpo2);
        zzc3.zzfk(n);
        this.uz.put(n, zzc3);
        ((zzc)zzc3).connect();
        this.uE.put(n, (Object)new zza(zzc2, n, this.uD));
        if (this.uF == null || !this.uF.uH.get()) {
            this.uF = new zzb(this.uD, this.uE);
            this.uF.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzpw zzpw2) {
        Object object = zzamp;
        synchronized (object) {
            if (zzpw2 == null) {
                this.uB = null;
                this.uC.clear();
            }
        }
    }

    @WorkerThread
    public void zza(zzpq zzpq2) {
        Set<zzpo<?>> set = zzpq2.zzaon();
        for (zzpo<?> zzpo2 : set) {
            zzc<?> zzc2 = this.uA.get(zzpo2);
            if (zzc2 == null) {
                zzpq2.cancel();
                return;
            }
            if (zzc2.isConnected()) {
                zzpq2.zza(zzpo2, ConnectionResult.qR);
                continue;
            }
            if (zzc2.zzaqg() != null) {
                zzpq2.zza(zzpo2, zzc2.zzaqg());
                continue;
            }
            zzc2.zzb(zzpq2);
        }
    }

    public void zzaol() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    @WorkerThread
    private void zzaqb() {
        for (zzc<?> zzc2 : this.uA.values()) {
            zzc2.zzaqf();
            ((zzc)zzc2).connect();
        }
    }

    public void zzd(int n, boolean bl) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n, bl ? 1 : 2));
    }

    @WorkerThread
    private void zze(int n, boolean bl) {
        zzc zzc2 = (zzc)this.uz.get(n);
        if (zzc2 != null) {
            if (!bl) {
                this.uz.delete(n);
            }
            zzc2.zzf(n, bl);
        } else {
            Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(52).append("onRelease received for unknown instance: ").append(n).toString(), (Throwable)new Exception());
        }
    }

    public <O extends Api.ApiOptions> void zza(com.google.android.gms.common.api.zzc<O> zzc2, int n, zzpr.zza<? extends Result, Api.zzb> zza2) {
        zzpn.zza zza3 = new zzpn.zza(zzc2.getInstanceId(), n, zza2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)zza3));
    }

    public <O extends Api.ApiOptions, TResult> void zza(com.google.android.gms.common.api.zzc<O> zzc2, int n, zzrb<Api.zzb, TResult> zzrb2, TaskCompletionSource<TResult> taskCompletionSource) {
        zzpn.zzb<TResult> zzb2 = new zzpn.zzb<TResult>(zzc2.getInstanceId(), n, zzrb2, taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, zzb2));
    }

    @WorkerThread
    private void zza(zzpn zzpn2) {
        ((zzc)this.uz.get(zzpn2.sn)).zzb(zzpn2);
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.zza((zzpq)message.obj);
                break;
            }
            case 6: {
                this.zza((com.google.android.gms.common.api.zzc)message.obj, message.arg1);
                break;
            }
            case 3: {
                this.zzaqb();
                break;
            }
            case 2: 
            case 7: {
                this.zze(message.arg1, message.arg2 == 1);
                break;
            }
            case 4: {
                this.zza((zzpn)message.obj);
                break;
            }
            case 5: {
                if (this.uz.get(message.arg1) == null) break;
                ((zzc)this.uz.get(message.arg1)).zzab(new Status(17, "Error resolution was canceled by the user."));
                break;
            }
            case 8: {
                if (!this.uA.containsKey(message.obj)) break;
                ((zzc)this.uA.get(message.obj)).resume();
                break;
            }
            case 9: {
                if (!this.uA.containsKey(message.obj)) break;
                ((zzc)this.uA.get(message.obj)).zzapr();
                break;
            }
            case 10: {
                if (!this.uA.containsKey(message.obj)) break;
                ((zzc)this.uA.get(message.obj)).zzaqj();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    boolean zzc(ConnectionResult connectionResult, int n) {
        if (connectionResult.hasResolution() || this.rX.isUserResolvableError(connectionResult.getErrorCode())) {
            this.rX.zza(this.mContext, connectionResult, n);
            return true;
        }
        return false;
    }

    public void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0));
        }
    }

    static /* synthetic */ zzpw zzd(zzqh zzqh2) {
        return null;
    }

    private static final class zzb
    extends Thread {
        private final ReferenceQueue<com.google.android.gms.common.api.zzc<?>> uD;
        private final SparseArray<zza> uE;
        private final AtomicBoolean uH = new AtomicBoolean();

        public zzb(ReferenceQueue<com.google.android.gms.common.api.zzc<?>> referenceQueue, SparseArray<zza> sparseArray) {
            super("GoogleApiCleanup");
            this.uD = referenceQueue;
            this.uE = sparseArray;
        }

        @Override
        public void run() {
            this.uH.set(true);
            Process.setThreadPriority((int)10);
            try {
                while (this.uH.get()) {
                    zza zza2 = (zza)this.uD.remove();
                    this.uE.remove(zza2.sn);
                    zza2.zzaqd();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.uH.set(false);
            }
        }
    }

    private final class zza
    extends PhantomReference<com.google.android.gms.common.api.zzc<?>> {
        private final int sn;

        public zza(com.google.android.gms.common.api.zzc zzc2, int n, ReferenceQueue<com.google.android.gms.common.api.zzc<?>> referenceQueue) {
            super(zzc2, referenceQueue);
            this.sn = n;
        }

        public void zzaqd() {
            zzqh.this.mHandler.sendMessage(zzqh.this.mHandler.obtainMessage(2, this.sn, 2));
        }
    }

    private class zzd
    implements zzd.zzf {
        private final Api.zze uJ;
        private final zzpo<?> rG;

        public zzd(Api.zze zze2, zzpo<?> zzpo2) {
            this.uJ = zze2;
            this.rG = zzpo2;
        }

        @WorkerThread
        public void zzh(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                this.uJ.zza(null, Collections.emptySet());
            } else {
                ((zzc)zzqh.this.uA.get(this.rG)).onConnectionFailed(connectionResult);
            }
        }
    }

    private class zzc<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private final Queue<zzpn> uI = new LinkedList<zzpn>();
        private final Api.zze uJ;
        private final Api.zzb uK;
        private final zzpo<O> rG;
        private final SparseArray<zzrd> uL = new SparseArray();
        private final Set<zzpq> uM = new HashSet<zzpq>();
        private final SparseArray<Map<Object, zzpr.zza>> uN = new SparseArray();
        private boolean tT;
        private ConnectionResult uO = null;

        @WorkerThread
        public zzc(com.google.android.gms.common.api.zzc<O> zzc2) {
            this.uJ = this.zzb(zzc2);
            this.uK = this.uJ instanceof zzah ? ((zzah)this.uJ).zzatj() : this.uJ;
            this.rG = zzc2.zzany();
        }

        @Override
        @WorkerThread
        public void onConnected(@Nullable Bundle bundle) {
            this.zzaqf();
            this.zzj(ConnectionResult.qR);
            this.zzaqh();
            for (int i = 0; i < this.uN.size(); ++i) {
                Map map = (Map)this.uN.get(this.uN.keyAt(i));
                for (zzpr.zza zza2 : map.values()) {
                    try {
                        zza2.zzb(this.uK);
                    }
                    catch (DeadObjectException deadObjectException) {
                        this.uJ.disconnect();
                        this.onConnectionSuspended(1);
                    }
                }
            }
            this.zzaqe();
            this.zzaqi();
        }

        @Override
        @WorkerThread
        public void onConnectionSuspended(int n) {
            this.zzaqf();
            this.tT = true;
            zzqh.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzqh.this.mHandler, (int)8, this.rG), zzqh.this.tV);
            zzqh.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzqh.this.mHandler, (int)9, this.rG), zzqh.this.tU);
            zzqh.this.ux = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            this.zzaqf();
            zzqh.this.ux = -1;
            this.zzj(connectionResult);
            int n = this.uL.keyAt(0);
            if (this.uI.isEmpty()) {
                this.uO = connectionResult;
                return;
            }
            Object object = zzamp;
            synchronized (object) {
                if (zzqh.zzd(zzqh.this) != null && zzqh.this.uC.contains(this.rG)) {
                    zzqh.zzd(zzqh.this).zzb(connectionResult, n);
                    return;
                }
            }
            if (!zzqh.this.zzc(connectionResult, n)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.tT = true;
                }
                if (this.tT) {
                    zzqh.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzqh.this.mHandler, (int)8, this.rG), zzqh.this.tV);
                } else {
                    object = String.valueOf(this.rG.zzaok());
                    this.zzab(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
                }
            }
        }

        @WorkerThread
        public void zzaqe() {
            while (this.uJ.isConnected() && !this.uI.isEmpty()) {
                zzpn zzpn2 = this.uI.remove();
                this.zzc(zzpn2);
            }
        }

        @WorkerThread
        public void zzb(zzpn zzpn2) {
            if (this.uJ.isConnected()) {
                this.zzc(zzpn2);
                this.zzaqi();
            } else {
                this.uI.add(zzpn2);
                if (this.uO != null && this.uO.hasResolution()) {
                    this.onConnectionFailed(this.uO);
                } else {
                    this.connect();
                }
            }
        }

        @WorkerThread
        public void zzfk(int n) {
            this.uL.put(n, (Object)new zzrd(this.rG.zzanp(), this.uJ));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzf(int n, boolean bl) {
            Object object;
            Iterator iterator = this.uI.iterator();
            while (iterator.hasNext()) {
                object = (zzpn)iterator.next();
                if (((zzpn)object).sn != n || ((zzpn)object).it == 1 || !((zzpn)object).cancel()) continue;
                iterator.remove();
            }
            ((zzrd)this.uL.get(n)).release();
            this.uN.delete(n);
            if (!bl) {
                this.uL.remove(n);
                zzqh.this.uE.remove(n);
                if (this.uL.size() == 0 && this.uI.isEmpty()) {
                    this.zzaqh();
                    this.uJ.disconnect();
                    zzqh.this.uA.remove(this.rG);
                    object = zzamp;
                    synchronized (object) {
                        zzqh.this.uC.remove(this.rG);
                    }
                }
            }
        }

        @WorkerThread
        public void zzaqf() {
            this.uO = null;
        }

        ConnectionResult zzaqg() {
            return this.uO;
        }

        @WorkerThread
        private void zzc(zzpn zzpn2) {
            zzpn2.zza(this.uL);
            if (zzpn2.it == 3) {
                try {
                    Map map = (Map)this.uN.get(zzpn2.sn);
                    if (map == null) {
                        map = new ArrayMap(1);
                        this.uN.put(zzpn2.sn, (Object)map);
                    }
                    zzpr.zza<? extends Result, Api.zzb> zza2 = ((zzpn.zza)zzpn2).so;
                    zzqr zzqr2 = (zzqr)((Object)zza2);
                    map.put(zzqr2.zzaqq(), zza2);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("Listener registration methods must implement ListenerApiMethod");
                }
            }
            if (zzpn2.it == 4) {
                try {
                    Map map = (Map)this.uN.get(zzpn2.sn);
                    zzqr zzqr3 = (zzqr)((Object)((zzpn.zza)zzpn2).so);
                    if (map != null) {
                        map.remove(zzqr3.zzaqq());
                    } else {
                        Log.w((String)"GoogleApiManager", (String)"Received call to unregister a listener without a matching registration call.");
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("Listener unregistration methods must implement ListenerApiMethod");
                }
            }
            try {
                zzpn2.zzb(this.uK);
            }
            catch (DeadObjectException deadObjectException) {
                this.uJ.disconnect();
                this.onConnectionSuspended(1);
            }
        }

        @WorkerThread
        private void zzab(Status status) {
            for (zzpn zzpn2 : this.uI) {
                zzpn2.zzx(status);
            }
            this.uI.clear();
        }

        @WorkerThread
        private void resume() {
            if (this.tT) {
                this.connect();
            }
        }

        @WorkerThread
        private void zzaqh() {
            if (this.tT) {
                zzqh.this.mHandler.removeMessages(9, this.rG);
                zzqh.this.mHandler.removeMessages(8, this.rG);
                this.tT = false;
            }
        }

        @WorkerThread
        private void zzapr() {
            if (this.tT) {
                this.zzaqh();
                int n = zzqh.this.rX.isGooglePlayServicesAvailable(zzqh.this.mContext);
                Status status = n == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zzab(status);
                this.uJ.disconnect();
            }
        }

        private void zzaqi() {
            zzqh.this.mHandler.removeMessages(10, this.rG);
            zzqh.this.mHandler.sendMessageDelayed(zzqh.this.mHandler.obtainMessage(10, this.rG), zzqh.this.uv);
        }

        private void zzaqj() {
            if (this.uJ.isConnected() && this.uN.size() == 0) {
                for (int i = 0; i < this.uL.size(); ++i) {
                    zzrd zzrd2 = (zzrd)this.uL.get(this.uL.keyAt(i));
                    if (!zzrd2.zzaqw()) continue;
                    this.zzaqi();
                    return;
                }
                this.uJ.disconnect();
            }
        }

        @WorkerThread
        private Api.zze zzb(com.google.android.gms.common.api.zzc zzc2) {
            Api api = zzc2.zzanw();
            if (api.zzanq()) {
                Api.zzh zzh2 = api.zzano();
                return new zzah(zzc2.getApplicationContext(), zzqh.this.mHandler.getLooper(), zzh2.zzant(), this, this, zzg.zzcd(zzc2.getApplicationContext()), zzh2.zzs(zzc2.zzanx()));
            }
            return zzc2.zzanw().zzann().zza(zzc2.getApplicationContext(), zzqh.this.mHandler.getLooper(), zzg.zzcd(zzc2.getApplicationContext()), zzc2.zzanx(), this, this);
        }

        @WorkerThread
        private void connect() {
            if (this.uJ.isConnected() || this.uJ.isConnecting()) {
                return;
            }
            if (this.uJ.zzanr() && zzqh.this.ux != 0) {
                zzqh.this.ux = zzqh.this.rX.isGooglePlayServicesAvailable(zzqh.this.mContext);
                if (zzqh.this.ux != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(zzqh.this.ux, null);
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            this.uJ.zza(new zzd(this.uJ, this.rG));
        }

        @WorkerThread
        public void zzb(zzpq zzpq2) {
            this.uM.add(zzpq2);
        }

        @WorkerThread
        private void zzj(ConnectionResult connectionResult) {
            for (zzpq zzpq2 : this.uM) {
                zzpq2.zza(this.rG, connectionResult);
            }
            this.uM.clear();
        }

        boolean isConnected() {
            return this.uJ.isConnected();
        }
    }
}

