/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.internal.zzqt;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzc<O extends Api.ApiOptions> {
    private final Context mContext;
    private final zzqt rE;
    private final Api<O> pD;
    private final O rF;
    private final zzpo<O> rG;
    private final Looper zzahv;
    private final int mId;
    private final zzqh rH;
    private final GoogleApiClient rI;
    private final AtomicBoolean rJ = new AtomicBoolean(false);
    private final AtomicInteger rK = new AtomicInteger(0);

    public zzc(@NonNull Context context, Api<O> api, O o, Looper looper) {
        zzab.zzb((Object)context, (Object)"Null context is not permitted.");
        zzab.zzb(api, (Object)"Api must not be null.");
        zzab.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.pD = api;
        this.rF = o;
        this.zzahv = looper;
        this.rE = new zzqt();
        this.rG = new zzpo<O>(this.pD, this.rF);
        this.rI = new zzqi(this);
        Pair<zzqh, Integer> pair = zzqh.zza(this.mContext, this);
        this.rH = (zzqh)pair.first;
        this.mId = (Integer)pair.second;
    }

    public zzc(@NonNull Context context, Api<O> api, O o) {
        this(context, api, o, Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper());
    }

    public void release() {
        if (this.rJ.getAndSet(true)) {
            return;
        }
        this.rE.release();
        this.rH.zzd(this.mId, this.rK.get() > 0);
    }

    private <A extends Api.zzb, T extends zzpr.zza<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzaot();
        this.rH.zza(this, n, t);
        return t;
    }

    private <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzrb<A, TResult> zzrb2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.rH.zza(this, n, zzrb2, taskCompletionSource);
        return taskCompletionSource.getTask();
    }

    public <A extends Api.zzb, T extends zzpr.zza<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> zza(zzrb<A, TResult> zzrb2) {
        return this.zza(0, zzrb2);
    }

    public <A extends Api.zzb, T extends zzpr.zza<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> zzb(zzrb<A, TResult> zzrb2) {
        return this.zza(1, zzrb2);
    }

    public void zzanu() {
        this.rK.incrementAndGet();
    }

    public void zzanv() {
        if (this.rK.decrementAndGet() == 0 && this.rJ.get()) {
            this.rH.zzd(this.mId, false);
        }
    }

    public Api<O> zzanw() {
        return this.pD;
    }

    public O zzanx() {
        return this.rF;
    }

    public zzpo<O> zzany() {
        return this.rG;
    }

    public int getInstanceId() {
        return this.mId;
    }

    public GoogleApiClient zzanz() {
        return this.rI;
    }

    public Looper getLooper() {
        return this.zzahv;
    }

    public Context getApplicationContext() {
        return this.mContext;
    }
}

