/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.widget.ProgressBar;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqu;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;

public class GoogleApiAvailability
extends zzc {
    private static final GoogleApiAvailability qU = new GoogleApiAvailability();
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";

    public static GoogleApiAvailability getInstance() {
        return qU;
    }

    GoogleApiAvailability() {
    }

    @MainThread
    public Task<Void> makeGooglePlayServicesAvailable(Activity activity) {
        zzab.zzhj((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n = this.isGooglePlayServicesAvailable((Context)activity);
        if (n == 0) {
            return Tasks.forResult(null);
        }
        zzqu zzqu2 = zzqu.zzu(activity);
        zzqu2.zzk(new ConnectionResult(n, null));
        return zzqu2.getTask();
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2) {
        return GooglePlayServicesUtil.getErrorDialog(n, activity, n2);
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        return GooglePlayServicesUtil.getErrorDialog(n, activity, n2, onCancelListener);
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2) {
        return GooglePlayServicesUtil.showErrorDialogFragment(n, activity, n2);
    }

    public boolean zza(Activity activity, @NonNull zzqp zzqp2, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.zza((Context)activity, n, "d");
        Dialog dialog = GooglePlayServicesUtil.zza(n, activity, com.google.android.gms.common.internal.zzi.zza(zzqp2, intent, n2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        GooglePlayServicesUtil.zza(activity, onCancelListener, "GooglePlayServicesErrorDialog", dialog);
        return true;
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        return GooglePlayServicesUtil.showErrorDialogFragment(n, activity, n2, onCancelListener);
    }

    public void showErrorNotification(Context context, int n) {
        if (n == 6) {
            Log.e((String)"GoogleApiAvailability", (String)"showErrorNotification(context, errorCode) is called for RESOLUTION_REQUIRED when showErrorNotification(context, result) should be called");
        }
        if (this.isUserResolvableError(n)) {
            GooglePlayServicesUtil.showErrorNotification(n, context);
        }
    }

    public void showErrorNotification(Context context, ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            GooglePlayServicesUtil.zza(connectionResult.getErrorCode(), context, pendingIntent);
        }
    }

    public void zza(Context context, ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            GooglePlayServicesUtil.zza(connectionResult.getErrorCode(), context, GoogleApiActivity.zza(context, pendingIntent, n));
        }
    }

    public Dialog zza(Activity activity, DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        String string2 = GooglePlayServicesUtil.zzbv((Context)activity);
        builder.setMessage((CharSequence)activity.getResources().getString(R.string.common_google_play_services_updating_text, new Object[]{string2}));
        builder.setTitle(R.string.common_google_play_services_updating_title);
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        GooglePlayServicesUtil.zza(activity, onCancelListener, "GooglePlayServicesUpdatingDialog", (Dialog)alertDialog);
        return alertDialog;
    }

    @Nullable
    public zzqj zza(Context context, zzqj.zza zza2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zzqj zzqj2 = new zzqj(zza2);
        context.registerReceiver((BroadcastReceiver)zzqj2, intentFilter);
        zzqj2.setContext(context);
        if (!this.zzm(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zza2.zzaor();
            zzqj2.unregister();
            return null;
        }
        return zzqj2;
    }

    public int isGooglePlayServicesAvailable(Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @Deprecated
    @Nullable
    public Intent zzfa(int n) {
        return super.zzfa(n);
    }

    @Nullable
    public Intent zza(Context context, int n, @Nullable String string2) {
        return super.zza(context, n, string2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        int n = connectionResult.getErrorCode();
        if (zzi.zzck((Context)context) && n == 2) {
            n = 42;
        }
        return this.getErrorResolutionPendingIntent(context, n, 0);
    }

    @Nullable
    public PendingIntent zza(Context context, int n, int n2, @Nullable String string2) {
        return super.zza(context, n, n2, string2);
    }

    @Nullable
    public String getOpenSourceSoftwareLicenseInfo(Context context) {
        return super.getOpenSourceSoftwareLicenseInfo(context);
    }

    public int zzbn(Context context) {
        return super.zzbn(context);
    }

    public boolean zzc(Context context, int n) {
        return super.zzc(context, n);
    }

    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }
}

