/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional {
    public static final Scope dP = new Scope("profile");
    public static final Scope dQ = new Scope("email");
    public static final Scope dR = new Scope("openid");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzb();
    final int versionCode;
    private final ArrayList<Scope> dS;
    private Account aP;
    private boolean dT;
    private final boolean dU;
    private final boolean dV;
    private String dW;
    private String dX;
    private static Comparator<Scope> dO = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzaoh().compareTo(scope2.zzaoh());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInOptions zzfr(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(hashSet, account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null));
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this.versionCode = n;
        this.dS = arrayList;
        this.aP = account;
        this.dT = bl;
        this.dU = bl2;
        this.dV = bl3;
        this.dW = string2;
        this.dX = string3;
    }

    private GoogleSignInOptions(Set<Scope> set, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this(2, new ArrayList<Scope>(set), account, bl, bl2, bl3, string2, string3);
    }

    public ArrayList<Scope> zzafq() {
        return new ArrayList<Scope>(this.dS);
    }

    public Scope[] getScopeArray() {
        return this.dS.toArray(new Scope[this.dS.size()]);
    }

    public Account getAccount() {
        return this.aP;
    }

    public boolean zzafr() {
        return this.dT;
    }

    public boolean zzafs() {
        return this.dU;
    }

    public boolean zzaft() {
        return this.dV;
    }

    public String zzafu() {
        return this.dW;
    }

    public String zzafv() {
        return this.dX;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.dS.size() != googleSignInOptions.zzafq().size() || !this.dS.containsAll(googleSignInOptions.zzafq())) {
                return false;
            }
            return (this.aP == null ? googleSignInOptions.getAccount() == null : this.aP.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.dW) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzafu()) : this.dW.equals(googleSignInOptions.zzafu())) && this.dV == googleSignInOptions.zzaft() && this.dT == googleSignInOptions.zzafr() && this.dU == googleSignInOptions.zzafs();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.dS) {
            arrayList.add(scope.zzaoh());
        }
        Collections.sort(arrayList);
        return new zze().zzr(arrayList).zzr(this.aP).zzr(this.dW).zzba(this.dV).zzba(this.dT).zzba(this.dU).zzagc();
    }

    public String zzafn() {
        return this.zzafp().toString();
    }

    private JSONObject zzafp() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.dS, dO);
            for (Scope scope : this.dS) {
                jSONArray.put((Object)scope.zzaoh());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.aP != null) {
                jSONObject.put("accountName", (Object)this.aP.name);
            }
            jSONObject.put("idTokenRequested", this.dT);
            jSONObject.put("forceCodeForRefreshToken", this.dV);
            jSONObject.put("serverAuthRequested", this.dU);
            if (!TextUtils.isEmpty((CharSequence)this.dW)) {
                jSONObject.put("serverClientId", (Object)this.dW);
            }
            if (!TextUtils.isEmpty((CharSequence)this.dX)) {
                jSONObject.put("hostedDomain", (Object)this.dX);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> dY = new HashSet<Scope>();
        private boolean dU;
        private boolean dV;
        private boolean dT;
        private String dW;
        private Account aP;
        private String dX;

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzab.zzaa((Object)googleSignInOptions);
            this.dY = new HashSet<Scope>(googleSignInOptions.dS);
            this.dU = googleSignInOptions.dU;
            this.dV = googleSignInOptions.dV;
            this.dT = googleSignInOptions.dT;
            this.dW = googleSignInOptions.dW;
            this.aP = googleSignInOptions.aP;
            this.dX = googleSignInOptions.dX;
        }

        public Builder requestId() {
            this.dY.add(dR);
            return this;
        }

        public Builder requestEmail() {
            this.dY.add(dQ);
            return this;
        }

        public Builder requestProfile() {
            this.dY.add(dP);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.dY.add(scope);
            this.dY.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public Builder requestIdToken(String string2) {
            this.dT = true;
            this.dW = this.zzfs(string2);
            return this;
        }

        public Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public Builder requestServerAuthCode(String string2, boolean bl) {
            this.dU = true;
            this.dW = this.zzfs(string2);
            this.dV = bl;
            return this;
        }

        public Builder setAccountName(String string2) {
            this.aP = new Account(zzab.zzhs((String)string2), "com.google");
            return this;
        }

        public Builder setHostedDomain(String string2) {
            this.dX = zzab.zzhs((String)string2);
            return this;
        }

        public GoogleSignInOptions build() {
            if (this.dT && (this.aP == null || !this.dY.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(this.dY, this.aP, this.dT, this.dU, this.dV, this.dW, this.dX);
        }

        private String zzfs(String string2) {
            zzab.zzhs((String)string2);
            zzab.zzb((this.dW == null || this.dW.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

