/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzpa;
import com.google.android.gms.internal.zztv;
import com.google.android.gms.internal.zztw;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zznx
implements zzoo {
    private final Context mContext;
    private final zzof zzamm;
    private final Looper zzakW;
    private final zzoh zzamn;
    private final zzoh zzamo;
    private final Map<Api.zzc<?>, zzoh> zzamp;
    private final Set<zzpa> zzamq = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzamr;
    private Bundle zzams;
    private ConnectionResult zzamt = null;
    private ConnectionResult zzamu = null;
    private boolean zzamv = false;
    private final Lock zzamw;
    private int zzamx = 0;

    public static zznx zza(Context context, zzof zzof2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zztv, zztw> zza2, ArrayList<zznw> arrayList) {
        Object object;
        Api.zze zze2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzps()) {
                zze2 = object;
            }
            if (object.zzpd()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzaa.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc3 = api.zzre();
            if (arrayMap2.containsKey(zzc3)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc3)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the apiTypeMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zznw>();
        ArrayList<zznw> arrayList2 = new ArrayList<zznw>();
        for (zznw zznw2 : arrayList) {
            if (arrayMap5.containsKey(zznw2.zzakT)) {
                ((ArrayList)object).add(zznw2);
                continue;
            }
            if (arrayMap.containsKey(zznw2.zzakT)) {
                arrayList2.add(zznw2);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the apiTypeMap");
        }
        return new zznx(context, zzof2, lock, looper, zzc2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzg2, zza2, zze2, (ArrayList<zznw>)object, arrayList2, (Map<Api<?>, Integer>)arrayMap5, (Map<Api<?>, Integer>)arrayMap);
    }

    private zznx(Context context, zzof zzof2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzg zzg2, Api.zza<? extends zztv, zztw> zza2, Api.zze zze2, ArrayList<zznw> arrayList, ArrayList<zznw> arrayList2, Map<Api<?>, Integer> map3, Map<Api<?>, Integer> map4) {
        this.mContext = context;
        this.zzamm = zzof2;
        this.zzamw = lock;
        this.zzakW = looper;
        this.zzamr = zze2;
        this.zzamn = new zzoh(context, this.zzamm, lock, looper, zzc2, map2, null, map4, null, arrayList2, new zza());
        this.zzamo = new zzoh(context, this.zzamm, lock, looper, zzc2, map, zzg2, map3, zza2, arrayList, new zzb());
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc3 : map2.keySet()) {
            arrayMap.put(zzc3, (Object)this.zzamn);
        }
        for (Api.zzc<?> zzc3 : map.keySet()) {
            arrayMap.put(zzc3, (Object)this.zzamo);
        }
        this.zzamp = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zznt.zza<R, A>> T zzc(@NonNull T t) {
        if (this.zze(t)) {
            if (this.zzrT()) {
                t.zzx(new Status(4, null, this.zzrU()));
                return t;
            }
            return this.zzamo.zzc(t);
        }
        return this.zzamn.zzc(t);
    }

    @Override
    public <A extends Api.zzb, T extends zznt.zza<? extends Result, A>> T zzd(@NonNull T t) {
        if (this.zze(t)) {
            if (this.zzrT()) {
                t.zzx(new Status(4, null, this.zzrU()));
                return t;
            }
            return this.zzamo.zzd(t);
        }
        return this.zzamn.zzd(t);
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzamp.get(api.zzre()).equals(this.zzamo)) {
            if (this.zzrT()) {
                return new ConnectionResult(4, this.zzrU());
            }
            return this.zzamo.getConnectionResult(api);
        }
        return this.zzamn.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.zzamx = 2;
        this.zzamv = false;
        this.zzrP();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.zzamu = null;
        this.zzamt = null;
        this.zzamx = 0;
        this.zzamn.disconnect();
        this.zzamo.disconnect();
        this.zzrS();
    }

    @Override
    public boolean isConnected() {
        this.zzamw.lock();
        try {
            boolean bl = this.zzamn.isConnected() && (this.zzrO() || this.zzrT() || this.zzamx == 1);
            return bl;
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.zzamw.lock();
        try {
            boolean bl = this.zzamx == 2;
            return bl;
        }
        finally {
            this.zzamw.unlock();
        }
    }

    @Override
    public boolean zza(zzpa zzpa2) {
        this.zzamw.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzrO()) {
                this.zzamq.add(zzpa2);
                if (this.zzamx == 0) {
                    this.zzamx = 1;
                }
                this.zzamu = null;
                this.zzamo.connect();
                boolean bl = true;
                return true;
            }
        }
        finally {
            this.zzamw.unlock();
        }
        return false;
    }

    @Override
    public void zzrN() {
        this.zzamn.zzrN();
        this.zzamo.zzrN();
    }

    @Override
    public void zzrr() {
        this.zzamw.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzamo.disconnect();
            this.zzamu = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzakW);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zznx.this.zzamw.lock();
                        try {
                            zznx.this.zzrQ();
                        }
                        finally {
                            zznx.this.zzamw.unlock();
                        }
                    }
                });
            } else {
                this.zzrS();
            }
        }
        finally {
            this.zzamw.unlock();
        }
    }

    public boolean zzrO() {
        return this.zzamo.isConnected();
    }

    private void zzrP() {
        this.zzamu = null;
        this.zzamt = null;
        this.zzamn.connect();
        this.zzamo.connect();
    }

    private void zzrQ() {
        if (zznx.zzc(this.zzamt)) {
            if (zznx.zzc(this.zzamu) || this.zzrT()) {
                this.zzrR();
            } else if (this.zzamu != null) {
                if (this.zzamx == 1) {
                    this.zzrS();
                } else {
                    this.zzb(this.zzamu);
                    this.zzamn.disconnect();
                }
            }
        } else if (this.zzamt != null && zznx.zzc(this.zzamu)) {
            this.zzamo.disconnect();
            this.zzb(this.zzamt);
        } else if (this.zzamt != null && this.zzamu != null) {
            ConnectionResult connectionResult = this.zzamt;
            if (this.zzamo.zzanF < this.zzamn.zzanF) {
                connectionResult = this.zzamu;
            }
            this.zzb(connectionResult);
        }
    }

    private void zzrR() {
        switch (this.zzamx) {
            case 2: {
                this.zzamm.zzk(this.zzams);
            }
            case 1: {
                this.zzrS();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
            }
        }
        this.zzamx = 0;
    }

    private void zzb(ConnectionResult connectionResult) {
        switch (this.zzamx) {
            case 2: {
                this.zzamm.zzd(connectionResult);
            }
            case 1: {
                this.zzrS();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzamx = 0;
    }

    private void zzrS() {
        for (zzpa zzpa2 : this.zzamq) {
            zzpa2.zzpr();
        }
        this.zzamq.clear();
    }

    private void zzb(int n, boolean bl) {
        this.zzamm.zzc(n, bl);
        this.zzamu = null;
        this.zzamt = null;
    }

    private boolean zzrT() {
        return this.zzamu != null && this.zzamu.getErrorCode() == 4;
    }

    private boolean zze(zznt.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzre();
        zzaa.zzb((boolean)this.zzamp.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzamp.get(zzc2).equals(this.zzamo);
    }

    @Nullable
    private PendingIntent zzrU() {
        if (this.zzamr == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzamm.getSessionId(), (Intent)this.zzamr.zzpt(), (int)0x8000000);
    }

    private void zzj(Bundle bundle) {
        if (this.zzams == null) {
            this.zzams = bundle;
        } else if (bundle != null) {
            this.zzams.putAll(bundle);
        }
    }

    private static boolean zzc(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzamo.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzamn.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    private class zzb
    implements zzoo.zza {
        private zzb() {
        }

        @Override
        public void zzk(@Nullable Bundle bundle) {
            zznx.this.zzamw.lock();
            try {
                zznx.this.zzamu = ConnectionResult.zzakj;
                zznx.this.zzrQ();
            }
            finally {
                zznx.this.zzamw.unlock();
            }
        }

        @Override
        public void zzd(@NonNull ConnectionResult connectionResult) {
            zznx.this.zzamw.lock();
            try {
                zznx.this.zzamu = connectionResult;
                zznx.this.zzrQ();
            }
            finally {
                zznx.this.zzamw.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zznx.this.zzamw.lock();
            try {
                if (zznx.this.zzamv) {
                    zznx.this.zzamv = false;
                    zznx.this.zzb(n, bl);
                    return;
                }
                zznx.this.zzamv = true;
                zznx.this.zzamn.onConnectionSuspended(n);
            }
            finally {
                zznx.this.zzamw.unlock();
            }
        }
    }

    private class zza
    implements zzoo.zza {
        private zza() {
        }

        @Override
        public void zzk(@Nullable Bundle bundle) {
            zznx.this.zzamw.lock();
            try {
                zznx.this.zzj(bundle);
                zznx.this.zzamt = ConnectionResult.zzakj;
                zznx.this.zzrQ();
            }
            finally {
                zznx.this.zzamw.unlock();
            }
        }

        @Override
        public void zzd(@NonNull ConnectionResult connectionResult) {
            zznx.this.zzamw.lock();
            try {
                zznx.this.zzamt = connectionResult;
                zznx.this.zzrQ();
            }
            finally {
                zznx.this.zzamw.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zznx.this.zzamw.lock();
            try {
                if (zznx.this.zzamv || zznx.this.zzamu == null || !zznx.this.zzamu.isSuccess()) {
                    zznx.this.zzamv = false;
                    zznx.this.zzb(n, bl);
                    return;
                }
                zznx.this.zzamv = true;
                zznx.this.zzamo.onConnectionSuspended(n);
            }
            finally {
                zznx.this.zzamw.unlock();
            }
        }
    }
}

