/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzne;

public final class zzma
extends Drawable
implements Drawable.Callback {
    private int zzaka = 0;
    private long zzRD;
    private int mFrom;
    private int zzakb;
    private int zzakc = 255;
    private int zzakd;
    private int zzake = 0;
    private boolean zzajT = true;
    private boolean zzakf;
    private zzb zzakg;
    private Drawable zzakh;
    private Drawable zzaki;
    private boolean zzakj;
    private boolean zzakk;
    private boolean zzakl;
    private int zzakm;

    public zzma(Drawable drawable, Drawable drawable2) {
        this(null);
        if (drawable == null) {
            drawable = zza.zzakn;
        }
        this.zzakh = drawable;
        drawable.setCallback((Drawable.Callback)this);
        this.zzakg.zzakq |= drawable.getChangingConfigurations();
        if (drawable2 == null) {
            drawable2 = zza.zzakn;
        }
        this.zzaki = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzakg.zzakq |= drawable2.getChangingConfigurations();
    }

    zzma(zzb zzb2) {
        this.zzakg = new zzb(zzb2);
    }

    @TargetApi(value=11)
    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (zzne.zzsd() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @TargetApi(value=11)
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (zzne.zzsd() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    @TargetApi(value=11)
    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (zzne.zzsd() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzakg.zzakp | this.zzakg.zzakq;
    }

    public void setAlpha(int alpha) {
        if (this.zzake == this.zzakc) {
            this.zzake = alpha;
        }
        this.zzakc = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.zzakh.setColorFilter(cf);
        this.zzaki.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzakh.getIntrinsicWidth(), this.zzaki.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzakh.getIntrinsicHeight(), this.zzaki.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.zzakh.setBounds(bounds);
        this.zzaki.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzakg.zzakp = this.getChangingConfigurations();
            return this.zzakg;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzakl) {
            this.zzakm = Drawable.resolveOpacity((int)this.zzakh.getOpacity(), (int)this.zzaki.getOpacity());
            this.zzakl = true;
        }
        return this.zzakm;
    }

    public boolean canConstantState() {
        if (!this.zzakj) {
            this.zzakk = this.zzakh.getConstantState() != null && this.zzaki.getConstantState() != null;
            this.zzakj = true;
        }
        return this.zzakk;
    }

    public Drawable mutate() {
        if (!this.zzakf && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzakh.mutate();
            this.zzaki.mutate();
            this.zzakf = true;
        }
        return this;
    }

    public Drawable zzqn() {
        return this.zzaki;
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.zzakb = this.zzakc;
        this.zzake = 0;
        this.zzakd = durationMillis;
        this.zzaka = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzaka) {
            case 1: {
                this.zzRD = SystemClock.uptimeMillis();
                bl = false;
                this.zzaka = 2;
                break;
            }
            case 2: {
                if (this.zzRD < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzRD) / (float)this.zzakd;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzaka = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzake = (int)((float)this.mFrom + (float)(this.zzakb - this.mFrom) * f);
            }
        }
        int n = this.zzake;
        boolean bl3 = this.zzajT;
        Drawable drawable = this.zzakh;
        Drawable drawable2 = this.zzaki;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable.draw(canvas);
            }
            if (n == this.zzakc) {
                drawable2.setAlpha(this.zzakc);
                drawable2.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable.setAlpha(this.zzakc - n);
        }
        drawable.draw(canvas);
        if (bl3) {
            drawable.setAlpha(this.zzakc);
        }
        if (n > 0) {
            drawable2.setAlpha(n);
            drawable2.draw(canvas);
            drawable2.setAlpha(this.zzakc);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzma$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzma$zza zzakn = new com.google.android.gms.internal.zzma$zza();
        private static final zza zzako = new zza();

        private com.google.android.gms.internal.zzma$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzako;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzakn;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int zzakp;
        int zzakq;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.zzakp = zzb2.zzakp;
                this.zzakq = zzb2.zzakq;
            }
        }

        public Drawable newDrawable() {
            return new zzma(this);
        }

        public int getChangingConfigurations() {
            return this.zzakp;
        }
    }
}

