/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.zza;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznx;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzahR = new Object();
    private static HashSet<Uri> zzahS = new HashSet();
    private static ImageManager zzahT;
    private static ImageManager zzahU;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzahV;
    private final zzb zzahW;
    private final zzmx zzahX;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzahY;
    private final Map<Uri, ImageReceiver> zzahZ;
    private final Map<Uri, Long> zzaia;

    public static ImageManager create(Context context) {
        return ImageManager.zzc(context, false);
    }

    public static ImageManager zzc(Context context, boolean bl) {
        if (bl) {
            if (zzahU == null) {
                zzahU = new ImageManager(context, true);
            }
            return zzahU;
        }
        if (zzahT == null) {
            zzahT = new ImageManager(context, false);
        }
        return zzahT;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzahV = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.zzahW = new zzb(this.mContext);
            if (zznx.zzrQ()) {
                this.zzpR();
            }
        } else {
            this.zzahW = null;
        }
        this.zzahX = new zzmx();
        this.zzahY = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzahZ = new HashMap<Uri, ImageReceiver>();
        this.zzaia = new HashMap<Uri, Long>();
    }

    private void zzpR() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new zze(this.zzahW));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, int resId) {
        zza.zzb zzb2 = new zza.zzb(imageView, resId);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        zzb2.zzbN(defaultResId);
        this.zza(zzb2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        zza.zzc zzc2 = new zza.zzc(listener, uri);
        this.zza(zzc2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        zza.zzc zzc2 = new zza.zzc(listener, uri);
        zzc2.zzbN(defaultResId);
        this.zza(zzc2);
    }

    public void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzb.zzcx((String)"ImageManager.loadImage() must be called in the main thread");
        zzd zzd2 = new zzd(zza2);
        zzd2.run();
    }

    private Bitmap zza(zza.zza zza2) {
        if (this.zzahW == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.zzahW.get(zza2);
        return bitmap;
    }

    private static final class zza {
        static int zza(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class zzb
    extends LruCache<zza.zza, Bitmap> {
        public zzb(Context context) {
            super(zzb.zzar(context));
        }

        protected void zza(boolean bl, zza.zza zza2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl, (Object)zza2, (Object)bitmap, (Object)bitmap2);
        }

        private static int zzar(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n = bl && zznx.zzrN() ? zza.zza(activityManager) : activityManager.getMemoryClass();
            int n2 = 0x100000 * n;
            return (int)(0.33f * (float)n2);
        }

        protected int zza(zza.zza zza2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.zza((zza.zza)x0, (Bitmap)x1);
        }

        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.zza(x0, (zza.zza)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class zze
    implements ComponentCallbacks2 {
        private final zzb zzahW;

        public zze(zzb zzb2) {
            this.zzahW = zzb2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.zzahW.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.zzahW.evictAll();
            } else if (level >= 20) {
                this.zzahW.trimToSize(this.zzahW.size() / 2);
            }
        }
    }

    private final class zzf
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzpy;
        private boolean zzaif;

        public zzf(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzaif = bl;
            this.zzpy = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzb.zzcx((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zzahW != null) {
                if (this.zzaif) {
                    ImageManager.this.zzahW.evictAll();
                    System.gc();
                    this.zzaif = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zzahW.put(new zza.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzahZ.remove(this.mUri))) != null) {
                this.zza(imageReceiver, bl);
            }
            this.zzpy.countDown();
            Object object = zzahR;
            synchronized (object) {
                zzahS.remove(this.mUri);
            }
        }

        private void zza(ImageReceiver imageReceiver, boolean bl) {
            ArrayList arrayList = imageReceiver.zzaib;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                if (bl) {
                    zza2.zza(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.zzaia.put(this.mUri, SystemClock.elapsedRealtime());
                    zza2.zza(ImageManager.this.mContext, ImageManager.this.zzahX, false);
                }
                if (zza2 instanceof zza.zzc) continue;
                ImageManager.this.zzahY.remove(zza2);
            }
        }
    }

    private final class zzc
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzaid;

        public zzc(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.zzaid = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzcy((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzaid != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzaid.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzaid.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zzf(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> zzaib;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzaib = new ArrayList();
        }

        public void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzcx((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzaib.add(zza2);
        }

        public void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzcx((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzaib.remove(zza2);
        }

        public void zzpU() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zzahV.execute(new zzc(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzd
    implements Runnable {
        private final com.google.android.gms.common.images.zza zzaie;

        public zzd(com.google.android.gms.common.images.zza zza2) {
            this.zzaie = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzcx((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzahY.get(this.zzaie));
            if (imageReceiver != null) {
                ImageManager.this.zzahY.remove(this.zzaie);
                imageReceiver.zzc(this.zzaie);
            }
            zza.zza zza2 = this.zzaie.zzaig;
            if (zza2.uri == null) {
                this.zzaie.zza(ImageManager.this.mContext, ImageManager.this.zzahX, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.zzaie.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zzaia.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzaie.zza(ImageManager.this.mContext, ImageManager.this.zzahX, true);
                    return;
                }
                ImageManager.this.zzaia.remove(zza2.uri);
            }
            this.zzaie.zza(ImageManager.this.mContext, ImageManager.this.zzahX);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzahZ.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.zzahZ.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.zzaie);
            if (!(this.zzaie instanceof zza.zzc)) {
                ImageManager.this.zzahY.put(this.zzaie, imageReceiver);
            }
            Object object = zzahR;
            synchronized (object) {
                boolean bl = zzahS.contains(zza2.uri);
                if (!bl) {
                    zzahS.add(zza2.uri);
                    imageReceiver.zzpU();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

