/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzc;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;

public final class CredentialRequest
implements SafeParcelable {
    public static final Parcelable.Creator<CredentialRequest> CREATOR = new zzc();
    final int mVersionCode;
    private final boolean zzRj;
    private final String[] zzRk;
    private final CredentialPickerConfig zzRl;
    private final CredentialPickerConfig zzRm;

    CredentialRequest(int version, boolean supportsPasswordLogin, String[] accountTypes, CredentialPickerConfig credentialPickerConfig, CredentialPickerConfig credentialHintPickerConfig) {
        this.mVersionCode = version;
        this.zzRj = supportsPasswordLogin;
        this.zzRk = zzx.zzv(accountTypes);
        this.zzRl = credentialPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig;
        this.zzRm = credentialHintPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialHintPickerConfig;
    }

    private CredentialRequest(Builder builder) {
        this(2, builder.zzRj, builder.zzRk, builder.zzRl, builder.zzRm);
    }

    public boolean getSupportsPasswordLogin() {
        return this.zzRj;
    }

    public String[] getAccountTypes() {
        return this.zzRk;
    }

    public CredentialPickerConfig getCredentialPickerConfig() {
        return this.zzRl;
    }

    public CredentialPickerConfig getCredentialHintPickerConfig() {
        return this.zzRm;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public static final class Builder {
        private boolean zzRj;
        private String[] zzRk;
        private CredentialPickerConfig zzRl;
        private CredentialPickerConfig zzRm;

        public Builder setSupportsPasswordLogin(boolean supportsPasswordLogin) {
            this.zzRj = supportsPasswordLogin;
            return this;
        }

        public Builder setAccountTypes(String ... accountTypes) {
            this.zzRk = accountTypes;
            return this;
        }

        public Builder setCredentialPickerConfig(CredentialPickerConfig config) {
            this.zzRl = config;
            return this;
        }

        public Builder setCredentialHintPickerConfig(CredentialPickerConfig config) {
            this.zzRm = config;
            return this;
        }

        public CredentialRequest build() {
            if (this.zzRk == null) {
                this.zzRk = new String[0];
            }
            if (!this.zzRj && this.zzRk.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new CredentialRequest(this);
        }
    }
}

