/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.internal.zzy;
import com.google.android.gms.internal.zzur;
import com.google.android.gms.internal.zzus;
import com.google.android.gms.internal.zzut;
import com.google.android.gms.internal.zzuw;
import com.google.android.gms.internal.zzuy;
import com.google.android.gms.internal.zzuz;
import com.google.android.gms.internal.zzva;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class zzvc
extends zzk<zzva>
implements zzur {
    private final zzf zzPG;
    private final zzus zzPr;
    private Integer zzPs;
    private final ExecutorService zzawZ;

    public zzvc(Context context, Looper looper, zzf zzf2, zzus zzus2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ExecutorService executorService) {
        super(context, looper, 44, connectionCallbacks, onConnectionFailedListener, zzf2);
        this.zzPG = zzf2;
        this.zzPr = zzus2;
        this.zzPs = zzf2.zziV();
        this.zzawZ = executorService;
    }

    @Override
    public void zza(zzt zzt2) {
        zzx.zzb(zzt2, (Object)"Expecting a valid IResolveAccountCallbacks");
        try {
            Account account = this.zzPG.zziN();
            ((zzva)this.zzjb()).zza(new zzy(account, this.zzPs), zzt2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when resolveAccount is called");
            try {
                zzt2.zzb(new zzaa(8));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"IResolveAccountCallbacks#onAccountResolutionComplete should be executed from the same process, unexpected RemoteException.");
            }
        }
    }

    @Override
    public void zza(zzq zzq2, boolean bl) {
        try {
            ((zzva)this.zzjb()).zza(zzq2, this.zzPs, bl);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
        }
    }

    @Override
    public void zzsu() {
        try {
            ((zzva)this.zzjb()).zzhb(this.zzPs);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
        }
    }

    @Override
    public void zza(zzq zzq2, Set<Scope> set, zzuz zzuz2) {
        zzx.zzb(zzuz2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            ((zzva)this.zzjb()).zza(new zzc(zzq2, set), zzuz2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when authAccount is called");
            try {
                zzuz2.zza(new ConnectionResult(8, null), new zzut());
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onAuthAccount should be executed from the same process, unexpected RemoteException.");
            }
        }
    }

    @Override
    protected String zzcF() {
        return "com.google.android.gms.signin.service.START";
    }

    @Override
    protected String zzcG() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected zzva zzcG(IBinder iBinder) {
        return zzva.zza.zzcF(iBinder);
    }

    @Override
    protected Bundle zzhq() {
        Bundle bundle = zzvc.zza(this.zzPr, this.zzPG.zziV(), this.zzawZ);
        String string2 = this.zzPG.zziR();
        if (!this.getContext().getPackageName().equals(string2)) {
            bundle.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzPG.zziR());
        }
        return bundle;
    }

    public static Bundle zza(zzus zzus2, Integer n, ExecutorService executorService) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzus2.zzsv());
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzus2.zzsw());
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzus2.zzrN());
        if (zzus2.zzsx() != null) {
            IBinder iBinder = new zza(zzus2, executorService).asBinder();
            bundle.putParcelable("com.google.android.gms.signin.internal.signInCallbacks", (Parcelable)new BinderWrapper(iBinder));
        }
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        return bundle;
    }

    @Override
    protected /* synthetic */ IInterface zzp(IBinder iBinder) {
        return this.zzcG(iBinder);
    }

    private static class zza
    extends zzuy.zza {
        private final zzus zzPr;
        private final ExecutorService zzawZ;

        public zza(zzus zzus2, ExecutorService executorService) {
            this.zzPr = zzus2;
            this.zzawZ = executorService;
        }

        @Override
        public void zza(final String string2, final List<Scope> list, final zzva zzva2) throws RemoteException {
            this.zzawZ.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        GoogleApiClient.ServerAuthCodeCallbacks serverAuthCodeCallbacks = zza.this.zzsx();
                        Set<Scope> set = Collections.unmodifiableSet(new HashSet(list));
                        GoogleApiClient.ServerAuthCodeCallbacks.CheckResult checkResult = serverAuthCodeCallbacks.onCheckServerAuthorization(string2, set);
                        zzuw zzuw2 = new zzuw(checkResult.zzic(), checkResult.zzid());
                        zzva2.zza(zzuw2);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing checkServerAuthorization callback", (Throwable)remoteException);
                    }
                }
            });
        }

        @Override
        public void zza(final String string2, final String string3, final zzva zzva2) throws RemoteException {
            this.zzawZ.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean bl = zza.this.zzsx().onUploadServerAuthCode(string2, string3);
                        zzva2.zzaf(bl);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing uploadServerAuthCode callback", (Throwable)remoteException);
                    }
                }
            });
        }

        private GoogleApiClient.ServerAuthCodeCallbacks zzsx() throws RemoteException {
            return this.zzPr.zzsx();
        }
    }
}

