/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzh
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean zzNu;
    private int zzNv = -1;
    private ConnectionResult zzNw;
    private final Handler zzNx = new Handler(Looper.getMainLooper());
    private final SparseArray<zzb> zzNy = new SparseArray();

    public static zzh zza(FragmentActivity fragmentActivity) {
        zzh zzh2;
        zzx.zzbd("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzh2 = (zzh)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (zzh2 == null || zzh2.isRemoving()) {
            zzh2 = new zzh();
            fragmentManager.beginTransaction().add((Fragment)zzh2, "GmsSupportLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return zzh2;
    }

    public GoogleApiClient zzar(int n) {
        zza zza2;
        if (this.getActivity() != null && (zza2 = this.zzat(n)) != null) {
            return zza2.zzNz;
        }
        return null;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzx.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzx.zza(this.zzNy.indexOfKey(n) < 0, (Object)("Already managing a GoogleApiClient with id " + n));
        zzb zzb2 = new zzb(googleApiClient, onConnectionFailedListener);
        this.zzNy.put(n, (Object)zzb2);
        if (this.getActivity() != null) {
            LoaderManager.enableDebugLogging((boolean)false);
            this.getLoaderManager().initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void zzas(int n) {
        this.zzNy.remove(n);
        this.getLoaderManager().destroyLoader(n);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zzb(this.zzNv, this.zzNw);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i = 0; i < this.zzNy.size(); ++i) {
            int n = this.zzNy.keyAt(i);
            zza zza2 = this.zzat(n);
            if (zza2 != null) {
                zzb zzb2 = (zzb)this.zzNy.valueAt(i);
                if (zzb2.zzNz != zza2.zzNz) {
                    this.getLoaderManager().restartLoader(n, null, (LoaderManager.LoaderCallbacks)this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzNu = savedInstanceState.getBoolean("resolving_error", false);
            this.zzNv = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzNv >= 0) {
                this.zzNw = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzNu);
        if (this.zzNv >= 0) {
            outState.putInt("failed_client_id", this.zzNv);
            outState.putInt("failed_status", this.zzNw.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzNw.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.zzNu) {
            for (int i = 0; i < this.zzNy.size(); ++i) {
                this.getLoaderManager().initLoader(this.zzNy.keyAt(i), null, (LoaderManager.LoaderCallbacks)this);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl = true;
            }
        }
        if (bl) {
            this.zziq();
        } else {
            this.zzb(this.zzNv, this.zzNw);
        }
    }

    public Loader<ConnectionResult> onCreateLoader(int id, Bundle args) {
        return new zza((Context)this.getActivity(), ((zzb)this.zzNy.get((int)id)).zzNz);
    }

    public void zza(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (!connectionResult.isSuccess()) {
            this.zza(loader.getId(), connectionResult);
        }
    }

    public void onLoaderReset(Loader<ConnectionResult> loader) {
    }

    zza zzat(int n) {
        try {
            return (zza)this.getLoaderManager().getLoader(n);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLifecycleFragment", classCastException);
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        if (!this.zzNu) {
            this.zzNu = true;
            this.zzNv = n;
            this.zzNw = connectionResult;
            this.zzNx.post((Runnable)new zzc(n, connectionResult));
        }
    }

    private void zzb(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zzb zzb2 = (zzb)this.zzNy.get(n);
        if (zzb2 != null) {
            this.zzas(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zzb2.zzNC;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zziq();
    }

    private void zziq() {
        this.zzNu = false;
        this.zzNv = -1;
        this.zzNw = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i = 0; i < this.zzNy.size(); ++i) {
            int n = this.zzNy.keyAt(i);
            zza zza2 = this.zzat(n);
            if (zza2 == null || !zza2.zzir()) continue;
            loaderManager.destroyLoader(n);
            loaderManager.initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.zza((Loader<ConnectionResult>)x0, (ConnectionResult)x1);
    }

    static class zza
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient zzNz;
        private boolean zzNA;
        private ConnectionResult zzNB;

        public zza(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.zzNz = googleApiClient;
        }

        public boolean zzir() {
            return this.zzNA;
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.zzNz.registerConnectionCallbacks(this);
            this.zzNz.registerConnectionFailedListener(this);
            if (this.zzNB != null) {
                this.deliverResult(this.zzNB);
            }
            if (!(this.zzNz.isConnected() || this.zzNz.isConnecting() || this.zzNA)) {
                this.zzNz.connect();
            }
        }

        protected void onStopLoading() {
            this.zzNz.disconnect();
        }

        protected void onReset() {
            this.zzNB = null;
            this.zzNA = false;
            this.zzNz.unregisterConnectionCallbacks(this);
            this.zzNz.unregisterConnectionFailedListener(this);
            this.zzNz.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.zzNA = false;
            this.zze(ConnectionResult.zzLr);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.zzNA = true;
            this.zze(result);
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            this.zzNz.dump(prefix, fd, writer, args);
        }

        private void zze(ConnectionResult connectionResult) {
            this.zzNB = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class zzb {
        public final GoogleApiClient zzNz;
        public final GoogleApiClient.OnConnectionFailedListener zzNC;

        private zzb(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzNz = googleApiClient;
            this.zzNC = onConnectionFailedListener;
        }
    }

    private class zzc
    implements Runnable {
        private final int zzND;
        private final ConnectionResult zzNE;

        public zzc(int n, ConnectionResult connectionResult) {
            this.zzND = n;
            this.zzNE = connectionResult;
        }

        @Override
        public void run() {
            if (this.zzNE.hasResolution()) {
                try {
                    int n = zzh.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)zzh.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzNE.startResolutionForResult((Activity)zzh.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzh.this.zziq();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.zzNE.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzNE.getErrorCode(), (Activity)zzh.this.getActivity(), zzh.this, 2, zzh.this);
            } else {
                zzh.this.zzb(this.zzND, this.zzNE);
            }
        }
    }
}

