/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzur;
import com.google.android.gms.internal.zzus;
import com.google.android.gms.internal.zzut;
import com.google.android.gms.internal.zzuv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class zzd
implements GoogleApiClient {
    private final Lock zzCN = new ReentrantLock();
    private final Condition zzMt = this.zzCN.newCondition();
    private final zzl zzMu;
    private final int zzMv;
    private final Context mContext;
    private final Looper zzMc;
    final Queue<zzg<?>> zzMw = new LinkedList();
    private ConnectionResult zzMx;
    private int zzMy;
    private volatile int zzMz = 4;
    private volatile boolean zzMA;
    private int zzMB = 0;
    private boolean zzMC = false;
    private int zzMD;
    private long zzME = 120000L;
    private long zzMF = 5000L;
    private final zzc zzMG;
    BroadcastReceiver zzMH;
    private final Bundle zzMI = new Bundle();
    private final Map<Api.zzc<?>, Api.zza> zzMJ = new HashMap();
    private final Set<Api.zzc<?>> zzMK = new HashSet();
    private final Map<Api.zzc<?>, ConnectionResult> zzML = new HashMap();
    private final List<String> zzMM;
    private boolean zzMN;
    private zzur zzMO;
    private int zzMP;
    private boolean zzMQ;
    private boolean zzMR;
    private zzq zzMS;
    private boolean zzMT;
    private boolean zzMU;
    private final Set<com.google.android.gms.common.api.zze<?>> zzMV = Collections.newSetFromMap(new WeakHashMap());
    final Set<zzg<?>> zzMW = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private final zze zzMX = new zze(){

        @Override
        public void zzb(zzg<?> zzg2) {
            zzd.this.zzMW.remove(zzg2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks zzMY = new zzf(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(Bundle connectionHint) {
            zzd.this.zzCN.lock();
            try {
                if (!zzd.this.isConnecting()) {
                    return;
                }
                if (connectionHint != null) {
                    zzd.this.zzMI.putAll(connectionHint);
                }
                zzd.this.zzie();
            }
            finally {
                zzd.this.zzCN.unlock();
            }
        }
    };
    private final GoogleApiClient.zza zzMZ = new GoogleApiClient.zza(){

        @Override
        public void zzia() {
            this.zzap(0);
        }

        @Override
        public void zzib() {
            this.zzap(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zzap(int n) {
            zzd.this.zzCN.lock();
            try {
                if (zzd.this.zzMB != n) {
                    Log.wtf((String)"GoogleApiClientImpl", (String)String.format("Internal error: step mismatch. Expected: %d, Actual: %d", zzd.this.zzMB, n));
                    zzd.this.zzao(4);
                    return;
                }
                if (zzd.this.zzMz == 1) {
                    zzd.this.zzie();
                }
            }
            finally {
                zzd.this.zzCN.unlock();
            }
        }
    };
    private final zzl.zza zzNa = new zzl.zza(){

        @Override
        public boolean zzin() {
            return zzd.this.zzMN;
        }

        @Override
        public boolean isConnected() {
            return zzd.this.isConnected();
        }

        @Override
        public Bundle zzhp() {
            return null;
        }
    };

    private final GoogleApiClient.OnConnectionFailedListener zza(final Api<?> api, final int n) {
        return new GoogleApiClient.OnConnectionFailedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionFailed(ConnectionResult result) {
                zzd.this.zzCN.lock();
                try {
                    int n2;
                    if (!zzd.this.isConnecting()) {
                        return;
                    }
                    if (n != 2 && zzd.this.zza(n2 = api.zzhT().getPriority(), n, result)) {
                        zzd.this.zzMx = result;
                        zzd.this.zzMy = n2;
                    }
                    zzd.this.zzML.put(api.zzhV(), result);
                    zzd.this.zzie();
                }
                finally {
                    zzd.this.zzCN.unlock();
                }
            }
        };
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !connectionResult.hasResolution()) {
            return false;
        }
        return this.zzMx == null || n < this.zzMy;
    }

    public zzd(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, Api.zzb<? extends zzur, zzus> zzb2, Map<Api<?>, Api.ApiOptions> map, Map<Api<?>, Boolean> map2, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2, int n) {
        this.mContext = context;
        this.zzMu = new zzl(looper, this.zzNa);
        this.zzMc = looper;
        this.zzMG = new zzc(looper);
        this.zzMv = n;
        for (GoogleApiClient.ConnectionCallbacks iterator : set) {
            this.zzMu.registerConnectionCallbacks(iterator);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.zzMu.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzMM = Collections.unmodifiableList(zzf2.zziP());
        this.zzMQ = false;
        this.zzMP = 2;
        boolean bl = false;
        for (Api<?> api : map.keySet()) {
            Api.ApiOptions apiOptions = map.get(api);
            int n2 = 0;
            if (map2.get(api) != null) {
                n2 = map2.get(api) != false ? 2 : 1;
            }
            Object obj = zzd.zza(api.zzhT(), apiOptions, context, looper, zzf2, this.zzMY, this.zza(api, n2));
            obj.zza(this.zzMZ);
            this.zzMJ.put(api.zzhV(), (Api.zza)obj);
            bl |= api.zzhT().getPriority() == 1;
            if (!obj.zzhc()) continue;
            this.zzMQ = true;
            if (n2 < this.zzMP) {
                this.zzMP = n2;
            }
            if (n2 == 0) continue;
            this.zzMK.add(api.zzhV());
        }
        if (bl) {
            this.zzMQ = false;
        }
        if (this.zzMQ) {
            zzf2.zza(this.getSessionId());
            this.zza(context, looper, zzf2, zzb2);
        }
    }

    private static <C extends Api.zza, O> C zza(Api.zzb<C, O> zzb2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return zzb2.zza(context, looper, zzf2, object, connectionCallbacks, onConnectionFailedListener);
    }

    private void zza(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, Api.zzb<? extends zzur, zzus> zzb2) {
        this.zzMO = zzd.zza(zzb2, zzf2.zziU(), context, looper, zzf2, new zzf(){

            @Override
            public void onConnected(Bundle connectionHint) {
                zzd.this.zzif();
            }
        }, new GoogleApiClient.OnConnectionFailedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionFailed(ConnectionResult result) {
                zzd.this.zzCN.lock();
                try {
                    zzd.this.zzb(new ConnectionResult(8, null));
                }
                finally {
                    zzd.this.zzCN.unlock();
                }
            }
        });
    }

    private void zzie() {
        --this.zzMD;
        if (this.zzMD == 0) {
            if (this.zzMx != null) {
                this.zza(this.zzMx);
            } else {
                switch (this.zzMB) {
                    case 0: {
                        if (this.zzMQ) {
                            this.zzMB = 1;
                            this.zzii();
                            break;
                        }
                        this.zzij();
                        break;
                    }
                    case 1: {
                        this.zzih();
                        break;
                    }
                    case 2: {
                        this.zzMz = 2;
                        this.zzim();
                        if (this.zzMO != null) {
                            if (this.zzMT) {
                                this.zzMO.zza(this.zzMS, this.zzMU);
                            }
                            this.zzM(false);
                        }
                        this.zzMt.signalAll();
                        this.zzik();
                        if (this.zzMC) {
                            this.zzMC = false;
                            this.zzao(-1);
                            break;
                        }
                        Bundle bundle = this.zzMI.isEmpty() ? null : this.zzMI;
                        this.zzMu.zzj(bundle);
                    }
                }
            }
        }
    }

    private void zza(ConnectionResult connectionResult) {
        this.zzMC = false;
        this.zzM(!connectionResult.hasResolution());
        this.zzao(3);
        if (!this.zzil() || !GooglePlayServicesUtil.zzh(this.mContext, connectionResult.getErrorCode())) {
            this.zzim();
            this.zzMu.zzg(connectionResult);
        }
        this.zzMN = false;
    }

    private void zzM(boolean bl) {
        if (this.zzMO != null) {
            if (this.zzMO.isConnected()) {
                if (bl) {
                    this.zzMO.zzsu();
                }
                this.zzMO.disconnect();
            }
            this.zzMS = null;
        }
    }

    private void zzif() {
        this.zzMO.zza(new zzb(this));
    }

    private void zza(final zzaa zzaa2) {
        ConnectionResult connectionResult = zzaa2.zzjo();
        if (connectionResult.isSuccess()) {
            this.zzMG.post(new Runnable(){

                @Override
                public void run() {
                    zzd.this.zzMS = zzaa2.zzjn();
                    zzd.this.zzMR = true;
                    zzd.this.zzMT = zzaa2.zzjp();
                    zzd.this.zzMU = zzaa2.zzjq();
                    zzd.this.zzii();
                }
            });
        } else {
            this.zzb(connectionResult);
        }
    }

    private void zzb(final ConnectionResult connectionResult) {
        this.zzMG.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                zzd.this.zzCN.lock();
                try {
                    if (zzd.this.zzc(connectionResult)) {
                        zzd.this.zzMN = false;
                        for (Api.zzc zzc2 : zzd.this.zzMK) {
                            Api.zza zza2 = (Api.zza)zzd.this.zzMJ.get(zzc2);
                            if (zza2.isConnected()) {
                                zza2.disconnect();
                            }
                            if (zzd.this.zzML.containsKey(zzc2)) continue;
                            zzd.this.zzML.put(zzc2, new ConnectionResult(17, null));
                        }
                        zzd.this.zzMN = true;
                        zzd.this.zzij();
                    } else {
                        zzd.this.zza(connectionResult);
                    }
                }
                finally {
                    zzd.this.zzCN.unlock();
                }
            }
        });
    }

    private boolean zzc(ConnectionResult connectionResult) {
        return this.zzMP == 2 || this.zzMP == 1 && !connectionResult.hasResolution();
    }

    private Set<Scope> zzig() {
        return new HashSet<Scope>(Arrays.asList(zzmh.zzi(this.zzMM)));
    }

    private void zzih() {
        this.zzMO.zza(this.zzMS, this.zzig(), new zza(this));
    }

    private void zzd(ConnectionResult connectionResult) {
        if (connectionResult.isSuccess()) {
            this.zzMG.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    zzd.this.zzCN.lock();
                    try {
                        zzd.this.zzij();
                    }
                    finally {
                        zzd.this.zzCN.unlock();
                    }
                }
            });
        } else {
            this.zzb(connectionResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzii() {
        zzx.zza(this.getLooper() == this.zzMG.getLooper(), (Object)"This method must be run on the mHandlerForCallbacks thread");
        if (this.zzMB == 1 && this.zzMR) {
            this.zzMD = this.zzMJ.size();
            for (Api.zzc<?> zzc2 : this.zzMJ.keySet()) {
                if (this.zzML.containsKey(zzc2)) {
                    this.zzCN.lock();
                    try {
                        this.zzie();
                        continue;
                    }
                    finally {
                        this.zzCN.unlock();
                        continue;
                    }
                }
                this.zzMJ.get(zzc2).zza(this.zzMS);
            }
        }
    }

    private void zzij() {
        this.zzMB = 2;
        this.zzMD = this.zzMJ.size();
        for (Api.zzc<?> zzc2 : this.zzMJ.keySet()) {
            if (this.zzML.containsKey(zzc2)) {
                this.zzie();
                continue;
            }
            this.zzMJ.get(zzc2).zzb(this.zzMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zza, R extends Result, T extends zza.zza<R, A>> T zza(T t) {
        zzx.zzb(this.zzMJ.containsKey(t.zzhV()), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        this.zzCN.lock();
        try {
            if (this.isConnected()) {
                this.zzb(t);
            } else {
                this.zzMw.add(t);
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.zzCN.unlock();
        }
    }

    @Override
    public <A extends Api.zza, T extends zza.zza<? extends Result, A>> T zzb(T t) {
        zzx.zza(this.isConnected() || this.zzil(), (Object)"GoogleApiClient is not connected yet.");
        this.zzik();
        try {
            this.zza((zzg<A>)t);
        }
        catch (DeadObjectException deadObjectException) {
            this.zzao(1);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.zza> void zza(zzg<A> zzg2) throws DeadObjectException {
        this.zzCN.lock();
        try {
            zzx.zzb(zzg2.zzhV() != null, (Object)"This task can not be executed or enqueued (it's probably a Batch or malformed)");
            this.zzMW.add(zzg2);
            zzg2.zza(this.zzMX);
            if (this.zzil()) {
                zzg2.zzk(new Status(8));
                return;
            }
            A a = this.zza(zzg2.zzhV());
            if (!a.isConnected() && this.zzML.containsKey(zzg2.zzhV())) {
                zzg2.zzk(new Status(17));
                return;
            }
            zzg2.zzb(a);
        }
        finally {
            this.zzCN.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzik() {
        this.zzCN.lock();
        try {
            zzx.zza(this.isConnected() || this.zzil(), (Object)"GoogleApiClient is not connected yet.");
            while (!this.zzMw.isEmpty()) {
                try {
                    this.zza(this.zzMw.remove());
                }
                catch (DeadObjectException deadObjectException) {
                    Log.w((String)"GoogleApiClientImpl", (String)"Service died while flushing queue", (Throwable)deadObjectException);
                }
            }
        }
        finally {
            this.zzCN.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> com.google.android.gms.common.api.zze<L> zzf(L l) {
        zzx.zzb(l, (Object)"Listener must not be null");
        this.zzCN.lock();
        try {
            com.google.android.gms.common.api.zze<L> zze2 = new com.google.android.gms.common.api.zze<L>(this.zzMc, l);
            this.zzMV.add(zze2);
            com.google.android.gms.common.api.zze<L> zze3 = zze2;
            return zze3;
        }
        finally {
            this.zzCN.unlock();
        }
    }

    @Override
    public <C extends Api.zza> C zza(Api.zzc<C> zzc2) {
        Api.zza zza2 = this.zzMJ.get(zzc2);
        zzx.zzb(zza2, (Object)"Appropriate Api was not requested.");
        return (C)zza2;
    }

    @Override
    public boolean zza(Api<?> api) {
        return this.zzMJ.containsKey(api.zzhV());
    }

    @Override
    public boolean zzb(Api<?> api) {
        Api.zza zza2 = this.zzMJ.get(api.zzhV());
        return zza2 == null ? false : zza2.isConnected();
    }

    @Override
    public boolean zza(Scope scope) {
        return this.zzMM.contains(scope.zzio());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zzCN.lock();
        try {
            this.zzMC = false;
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.zzMN = true;
            this.zzMx = null;
            this.zzMz = 1;
            this.zzMB = 0;
            this.zzMI.clear();
            this.zzMD = this.zzMJ.size();
            this.zzML.clear();
            this.zzMR = false;
            this.zzMT = false;
            this.zzMU = false;
            if (this.zzMQ) {
                this.zzMO.connect();
            }
            for (Api.zza zza2 : this.zzMJ.values()) {
                zza2.connect();
            }
        }
        finally {
            this.zzCN.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzCN.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.zzMt.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.zzCN.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzLr;
                return connectionResult;
            }
            if (this.zzMx != null) {
                ConnectionResult connectionResult = this.zzMx;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzCN.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzCN.lock();
        try {
            this.connect();
            long l = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l = this.zzMt.awaitNanos(l);
                    if (l > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzLr;
                return connectionResult;
            }
            if (this.zzMx != null) {
                ConnectionResult connectionResult = this.zzMx;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzCN.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.zzim();
        this.zzao(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzao(int n) {
        this.zzCN.lock();
        try {
            if (this.zzMz != 3) {
                if (n == -1) {
                    if (this.isConnecting()) {
                        Iterator<Object> iterator = this.zzMw.iterator();
                        while (iterator.hasNext()) {
                            zzg object = (zzg)iterator.next();
                            if (object.zzhW() == 1) continue;
                            object.cancel();
                            iterator.remove();
                        }
                    } else {
                        for (zzg bl2 : this.zzMw) {
                            bl2.cancel();
                        }
                        this.zzMw.clear();
                    }
                    for (zzg zzg2 : this.zzMW) {
                        zzg2.zza(null);
                        zzg2.cancel();
                    }
                    this.zzMW.clear();
                    for (com.google.android.gms.common.api.zze zze2 : this.zzMV) {
                        zze2.clear();
                    }
                    this.zzMV.clear();
                    if (this.zzMx == null && !this.zzMw.isEmpty()) {
                        this.zzMC = true;
                        return;
                    }
                    this.zzML.clear();
                }
                boolean bl = this.isConnecting();
                boolean bl2 = this.isConnected();
                this.zzMz = 3;
                if (bl) {
                    if (n == -1) {
                        this.zzMx = null;
                    }
                    this.zzMt.signalAll();
                }
                this.zzMN = false;
                for (Api.zza zza2 : this.zzMJ.values()) {
                    zza2.disconnect();
                }
                boolean bl3 = n == -1;
                this.zzM(bl3);
                this.zzMN = true;
                this.zzMz = 4;
                if (bl2) {
                    if (n != -1) {
                        this.zzMu.zzaJ(n);
                    }
                    this.zzMN = false;
                }
            }
        }
        finally {
            this.zzCN.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzx.zza(this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        final com.google.android.gms.common.api.zzg zzg2 = new com.google.android.gms.common.api.zzg(this.zzMc);
        if (this.zzMJ.containsKey(zzko.zzGR)) {
            this.zza(this, zzg2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle connectionHint) {
                    zzd.this.zza((GoogleApiClient)atomicReference.get(), zzg2, true);
                }

                @Override
                public void onConnectionSuspended(int cause) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    zzg2.setResult(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzko.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzMG).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzg2;
    }

    private void zza(final GoogleApiClient googleApiClient, final com.google.android.gms.common.api.zzg zzg2, final boolean bl) {
        zzko.zzQy.zzc(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzi(Status status) {
                if (status.isSuccess() && zzd.this.isConnected()) {
                    zzd.this.reconnect();
                }
                zzg2.setResult(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zzi((Status)x0);
            }
        });
    }

    @Override
    public void stopAutoManage(FragmentActivity lifecycleActivity) {
        zzx.zza(this.zzMv >= 0, (Object)"Called stopAutoManage but automatic lifecycle management is not enabled.");
        zzh.zza(lifecycleActivity).zzas(this.zzMv);
    }

    @Override
    public boolean isConnected() {
        return this.zzMz == 2;
    }

    @Override
    public boolean isConnecting() {
        return this.zzMz == 1;
    }

    boolean zzil() {
        return this.zzMA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.zzCN.lock();
        try {
            if (this.zzil()) {
                this.connect();
            }
        }
        finally {
            this.zzCN.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzim() {
        this.zzCN.lock();
        try {
            if (!this.zzMA) {
                return;
            }
            this.zzMA = false;
            this.zzMG.removeMessages(2);
            this.zzMG.removeMessages(1);
            if (this.zzMH != null) {
                this.mContext.getApplicationContext().unregisterReceiver(this.zzMH);
                this.zzMH = null;
            }
        }
        finally {
            this.zzCN.unlock();
        }
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzMu.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.zzMu.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzMu.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzMu.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.zzMu.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzMu.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzMc;
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).println("GoogleApiClient:");
        String string2 = prefix + "  ";
        writer.append(string2).append("mConnectionState=");
        switch (this.zzMz) {
            case 1: {
                writer.print("CONNECTING");
                break;
            }
            case 2: {
                writer.print("CONNECTED");
                break;
            }
            case 3: {
                writer.print("DISCONNECTING");
                break;
            }
            case 4: {
                writer.print("DISCONNECTED");
                break;
            }
            default: {
                writer.print("UNKNOWN");
            }
        }
        writer.append(" mResuming=").print(this.zzMA);
        writer.append(" mWaitingToDisconnect=").println(this.zzMC);
        writer.append(string2).append("mWorkQueue.size()=").print(this.zzMw.size());
        writer.append(" mUnconsumedRunners.size()=").println(this.zzMW.size());
        for (Api.zza zza2 : this.zzMJ.values()) {
            zza2.dump(string2, fd, writer, args);
        }
    }

    @Override
    public int getSessionId() {
        return System.identityHashCode(this);
    }

    private static class zza
    extends zzuv {
        private WeakReference<zzd> zzNj;

        zza(zzd zzd2) {
            this.zzNj = new WeakReference<zzd>(zzd2);
        }

        @Override
        public void zza(ConnectionResult connectionResult, zzut zzut2) {
            zzd zzd2 = (zzd)this.zzNj.get();
            if (zzd2 != null) {
                zzd2.zzd(connectionResult);
            }
        }
    }

    private static class zzb
    extends zzt.zza {
        private WeakReference<zzd> zzNj;

        zzb(zzd zzd2) {
            this.zzNj = new WeakReference<zzd>(zzd2);
        }

        @Override
        public void zzb(zzaa zzaa2) {
            zzd zzd2 = (zzd)this.zzNj.get();
            if (zzd2 != null) {
                zzd2.zza(zzaa2);
            }
        }
    }

    private final class zzc
    extends Handler {
        zzc(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zzd.this.zzim();
                    break;
                }
                case 2: {
                    zzd.this.resume();
                    break;
                }
                default: {
                    Log.w((String)"GoogleApiClientImpl", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }

    private static class zzd
    extends BroadcastReceiver {
        private WeakReference<zzd> zzNj;

        zzd(zzd zzd2) {
            this.zzNj = new WeakReference<zzd>(zzd2);
        }

        public void onReceive(Context context, Intent intent) {
            Uri uri = intent.getData();
            String string2 = null;
            if (uri != null) {
                string2 = uri.getSchemeSpecificPart();
            }
            if (string2 == null || !string2.equals("com.google.android.gms")) {
                return;
            }
            zzd zzd2 = (zzd)this.zzNj.get();
            if (zzd2 == null) {
                return;
            }
            zzd2.resume();
        }
    }

    private abstract class zzf
    implements GoogleApiClient.ConnectionCallbacks {
        private zzf() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConnectionSuspended(int cause) {
            zzd.this.zzCN.lock();
            try {
                switch (cause) {
                    case 2: {
                        zzd.this.zzao(cause);
                        zzd.this.connect();
                        return;
                    }
                    case 1: {
                        if (zzd.this.zzil()) {
                            return;
                        }
                        zzd.this.zzMA = true;
                        if (zzd.this.zzMH == null) {
                            zzd.this.zzMH = new zzd(zzd.this);
                            IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
                            intentFilter.addDataScheme("package");
                            zzd.this.mContext.getApplicationContext().registerReceiver(zzd.this.zzMH, intentFilter);
                        }
                        zzd.this.zzMG.sendMessageDelayed(zzd.this.zzMG.obtainMessage(1), zzd.this.zzME);
                        zzd.this.zzMG.sendMessageDelayed(zzd.this.zzMG.obtainMessage(2), zzd.this.zzMF);
                        zzd.this.zzao(cause);
                        return;
                    }
                }
                return;
            }
            finally {
                zzd.this.zzCN.unlock();
            }
        }
    }

    static interface zzg<A extends Api.zza> {
        public void cancel();

        public Api.zzc<A> zzhV();

        public void zzb(A var1) throws DeadObjectException;

        public void zzk(Status var1);

        public void zza(zze var1);

        public int zzhW();
    }

    static interface zze {
        public void zzb(zzg<?> var1);
    }
}

