/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;

public final class Status
implements Result,
SafeParcelable {
    public static final Status zzNo = new Status(0);
    public static final Status zzNp = new Status(14);
    public static final Status zzNq = new Status(8);
    public static final Status zzNr = new Status(15);
    public static final Status zzNs = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int zzFG;
    private final int zzLs;
    private final String zzNt;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.zzFG = versionCode;
        this.zzLs = statusCode;
        this.zzNt = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent zzip() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.zzNt;
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzLs <= 0;
    }

    public boolean isCanceled() {
        return this.zzLs == 16;
    }

    public boolean isInterrupted() {
        return this.zzLs == 14;
    }

    public int getStatusCode() {
        return this.zzLs;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzFG, this.zzLs, this.zzNt, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.zzFG == status.zzFG && this.zzLs == status.zzLs && zzw.equal(this.zzNt, status.zzNt) && zzw.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzhK() {
        if (this.zzNt != null) {
            return this.zzNt;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzLs);
    }

    public String toString() {
        return zzw.zzk(this).zza("statusCode", this.zzhK()).zza("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.zza(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

