/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzad;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzg;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int mColor;
    private View zzLI;
    private View.OnClickListener zzLJ = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.mColor);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        zzx.zza(buttonSize >= 0 && buttonSize < 3, "Unknown button size %d", buttonSize);
        zzx.zza(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme %s", colorScheme);
        this.mSize = buttonSize;
        this.mColor = colorScheme;
        this.zzN(this.getContext());
    }

    private void zzN(Context context) {
        if (this.zzLI != null) {
            this.removeView(this.zzLI);
        }
        try {
            this.zzLI = zzac.zzb(context, this.mSize, this.mColor);
        }
        catch (zzg.zza zza2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.zzLI = SignInButton.zza(context, this.mSize, this.mColor);
        }
        this.addView(this.zzLI);
        this.zzLI.setEnabled(this.isEnabled());
        this.zzLI.setOnClickListener((View.OnClickListener)this);
    }

    private static Button zza(Context context, int n, int n2) {
        zzad zzad2 = new zzad(context);
        zzad2.zza(context.getResources(), n, n2);
        return zzad2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.zzLJ = listener;
        if (this.zzLI != null) {
            this.zzLI.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.zzLI.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.zzLJ != null && view == this.zzLI) {
            this.zzLJ.onClick((View)this);
        }
    }
}

