/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.ab;
import com.google.android.gms.analytics.ac;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.af;
import com.google.android.gms.analytics.an;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.l;
import com.google.android.gms.analytics.o;
import com.google.android.gms.analytics.r;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

public class h
implements r {
    private final String wl;
    private final HttpClient yf;
    private final Context mContext;
    private URL yg;
    private int yh;
    private int yi;
    private int yj;
    private String yk;
    private String yl;
    private i ym;
    private l yn;
    private Set<Integer> yo = new HashSet<Integer>();
    private boolean yp = false;
    private long yq;
    private long yr;
    private o ys;
    private volatile boolean yt = false;

    h(HttpClient httpClient, Context context, o o2) {
        this.mContext = context.getApplicationContext();
        this.ys = o2;
        this.wl = this.a("GoogleAnalytics", "4.0", Build.VERSION.RELEASE, an.a(Locale.getDefault()), Build.MODEL, Build.ID);
        this.yf = httpClient;
    }

    @Override
    public boolean ea() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            ae.V("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public void ad(String string2) {
        try {
            this.yg = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.yg = null;
        }
    }

    String a(String string2, String string3, String string4, String string5, String string6, String string7) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string2, string3, string4, string5, string6, string7);
    }

    int a(List<ab> list, int n2) {
        if (list.isEmpty()) {
            return 0;
        }
        if (n2 > list.size()) {
            n2 = list.size();
        }
        int n3 = n2;
        long l2 = 0L;
        for (int i2 = n2 - 1; i2 > 0; --i2) {
            ab ab2 = list.get(i2 - 1);
            ab ab3 = list.get(i2);
            long l3 = ab2.fc();
            long l4 = ab3.fc();
            if (l3 == 0L || l4 == 0L || l4 - l3 <= l2) continue;
            l2 = l4 - l3;
            n3 = i2;
        }
        return n3;
    }

    int b(List<ab> list, int n2) {
        if (list.isEmpty()) {
            return 0;
        }
        int n3 = n2;
        for (int i2 = n2 - 1; i2 > 0; --i2) {
            String string2 = list.get(i2).fa();
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            if (string2.contains("sc=start")) {
                n3 = i2;
                break;
            }
            if (!string2.contains("sc=end")) continue;
            n3 = i2 + 1;
            break;
        }
        return n3;
    }

    private boolean a(String string2, HttpHost httpHost, int n2, af af2, l l2) {
        boolean bl2;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = bl2 = n2 > 1;
        if (string2.getBytes().length > this.yj || string2.getBytes().length > this.yi) {
            ae.W("Request too long (> " + Math.min(this.yi, this.yj) + " bytes)--not sent");
        } else if (this.yt) {
            ae.U("Dry run enabled. Hit not actually sent.");
        } else {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream;
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = this.d(string2, bl2);
            if (httpEntityEnclosingRequest == null) {
                return true;
            }
            if (httpEntityEnclosingRequest.getRequestLine().getMethod().equals("GET")) {
                n3 = string2.getBytes().length;
                n4 = string2.getBytes().length;
            } else {
                try {
                    switch (l2) {
                        case yJ: {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                            gZIPOutputStream.write(string2.getBytes());
                            gZIPOutputStream.close();
                            object = byteArrayOutputStream.toByteArray();
                            n4 += ((byte[])object).length;
                            httpEntityEnclosingRequest.setEntity((HttpEntity)new ByteArrayEntity(object));
                            httpEntityEnclosingRequest.addHeader("Content-Encoding", "gzip");
                            break;
                        }
                        default: {
                            n4 = string2.getBytes().length;
                            httpEntityEnclosingRequest.setEntity((HttpEntity)new StringEntity(string2));
                        }
                    }
                    n3 = string2.getBytes().length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ae.T("Encoding error, hit will be discarded");
                    return true;
                }
                catch (IOException iOException) {
                    ae.T("Unexpected IOException: " + iOException.getMessage());
                    ae.T("Request will be discarded");
                    return true;
                }
            }
            httpEntityEnclosingRequest.addHeader("Host", httpHost.toHostString());
            if (ae.ff()) {
                this.a(httpEntityEnclosingRequest);
            }
            try {
                byteArrayOutputStream = this.yf.execute(httpHost, (HttpRequest)httpEntityEnclosingRequest);
                af2.e("_td", n3);
                af2.e("_cd", n4);
                int n5 = byteArrayOutputStream.getStatusLine().getStatusCode();
                object = byteArrayOutputStream.getEntity();
                if (object != null) {
                    object.consumeContent();
                }
                if (n5 != 200) {
                    if (bl2 && this.yo.contains(n5)) {
                        ae.U("Falling back to single hit per request mode.");
                        this.yp = true;
                        this.yq = System.currentTimeMillis();
                        return false;
                    }
                    ae.W("Bad response: " + byteArrayOutputStream.getStatusLine().getStatusCode());
                }
            }
            catch (ClientProtocolException clientProtocolException) {
                ae.W("ClientProtocolException sending hit; discarding hit...");
            }
            catch (IOException iOException) {
                ae.W("Exception sending hit: " + iOException.getClass().getSimpleName());
                ae.W(iOException.getMessage());
                return false;
            }
        }
        return true;
    }

    private String a(ab ab2, List<String> list, i i2) {
        String string2;
        if (i2 == i.yw) {
            string2 = ab2.fa() == null || ab2.fa().length() == 0 ? "" : ab2.fa();
            long l2 = System.currentTimeMillis();
            string2 = TextUtils.isEmpty((CharSequence)string2) ? "" : ac.a(ab2, l2);
        } else {
            string2 = "";
            for (String string3 : list) {
                if (string3.length() == 0) continue;
                if (string2.length() != 0) {
                    string2 = string2 + "\n";
                }
                string2 = string2 + string3;
            }
        }
        return string2;
    }

    @Override
    public int a(List<ab> list, af af2, boolean bl2) {
        String string2;
        ab ab22;
        l l2;
        i i2;
        this.yh = this.ys.eb();
        this.yi = this.ys.ec();
        this.yj = this.ys.ed();
        int n2 = this.ys.ee();
        this.yk = this.ys.eg();
        this.yl = this.ys.eh();
        this.ym = this.ys.ei();
        this.yn = this.ys.ej();
        this.yo.clear();
        this.yo.addAll(this.ys.ek());
        this.yr = this.ys.ef();
        if (!this.yp && this.yo.isEmpty()) {
            this.yp = true;
            this.yq = System.currentTimeMillis();
        }
        if (this.yp && System.currentTimeMillis() - this.yq > 1000L * this.yr) {
            this.yp = false;
        }
        if (this.yp) {
            i2 = i.yw;
            l2 = l.yI;
        } else {
            i2 = this.ym;
            l2 = this.yn;
        }
        int n3 = 0;
        int n4 = Math.min(list.size(), n2);
        af2.e("_hr", list.size());
        long l3 = System.currentTimeMillis();
        List<String> list2 = new ArrayList<String>();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l4 = 0L;
        int n5 = n4;
        int n6 = 0;
        if (i2 != i.yw) {
            n5 = 1;
            for (ab ab22 : list) {
                String string3 = string2 = TextUtils.isEmpty((CharSequence)ab22.fa()) ? "" : ac.a(ab22, l3);
                if (string2.getBytes().length > this.yi) {
                    string2 = "";
                }
                list2.add(string2);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    l4 += (long)(string2.getBytes().length + (n6 == 0 ? 0 : 1));
                }
                arrayList.add(l4);
                if (l4 <= (long)this.yj) {
                    ++n6;
                }
                if (n6 != n4) continue;
                break;
            }
        }
        while (n6 > 1 && (Long)arrayList.get(n6 - 1) > (long)this.yj) {
            --n6;
        }
        if (l4 > (long)this.yj) {
            int n7 = 0;
            switch (i2) {
                case yA: {
                    int n8 = list2.size() / 2;
                    if (n6 > n8) {
                        n7 = n8;
                        break;
                    }
                    n7 = n6;
                    break;
                }
                case yy: {
                    n7 = this.a(list, n6);
                    break;
                }
                case yx: {
                    n7 = this.b(list, n6);
                    break;
                }
                case yB: {
                    if (l4 < (long)(this.yj * 2)) {
                        int n9;
                        for (n9 = arrayList.size() - 1; n9 > 0 && (Long)arrayList.get(n9) > l4 / 2L; --n9) {
                        }
                        n7 = n9;
                        break;
                    }
                    n7 = n6;
                    break;
                }
                case yz: {
                    n7 = n6;
                    break;
                }
                default: {
                    ae.W("Unexpected batching strategy encountered; sending a single hit.");
                    n7 = 1;
                    string2 = (String)list2.get(0);
                    list2.clear();
                    list2.add(string2);
                }
            }
            if (n7 < list2.size()) {
                list2 = list2.subList(0, n7);
            }
        }
        int n10 = 0;
        ab22 = null;
        for (int i3 = 0; i3 < n5; ++i3) {
            ab ab3 = list.get(i3);
            URL uRL = this.a(ab3);
            int n11 = Math.max(1, list2.size());
            if (uRL == null) {
                ae.W("No destination: discarding hit.");
                n10 += n11;
                n3 += n11;
                continue;
            }
            ab22 = new HttpHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
            String string4 = this.a(ab3, list2, i2);
            if (!this.a(string4, (HttpHost)ab22, n11, af2, l2)) {
                af2.e("_de", 1);
                af2.e("_hd", n10);
                af2.e("_hs", n3);
                this.a(af2, (HttpHost)ab22, i2, l2);
                return n3;
            }
            for (String string5 : list2) {
                if (!TextUtils.isEmpty((CharSequence)string5)) continue;
                ++n10;
            }
            af2.e("_rs", 1);
            n3 += n11;
        }
        af2.e("_hd", n10);
        af2.e("_hs", n3);
        if (bl2) {
            this.a(af2, (HttpHost)ab22, i2, l2);
        }
        return n3;
    }

    private void a(af af2, HttpHost httpHost, i i2, l l2) {
        af2.g("_bs", i2.toString());
        af2.g("_cs", l2.toString());
        String string2 = af2.fg();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        HttpHost httpHost2 = httpHost;
        if (httpHost2 == null) {
            try {
                URL uRL = new URL("https://ssl.google-analytics.com");
                httpHost2 = new HttpHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        this.a(string2, httpHost2, 1, af2, l.yI);
    }

    private HttpEntityEnclosingRequest d(String string2, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            System.out.println("Empty hit, discarding.");
            return null;
        }
        String string3 = this.yk + "?" + string2;
        BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest = string3.length() < this.yh && !bl2 ? new BasicHttpEntityEnclosingRequest("GET", string3) : (bl2 ? new BasicHttpEntityEnclosingRequest("POST", this.yl) : new BasicHttpEntityEnclosingRequest("POST", this.yk));
        basicHttpEntityEnclosingRequest.addHeader("User-Agent", this.wl);
        return basicHttpEntityEnclosingRequest;
    }

    private void a(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Header header : httpEntityEnclosingRequest.getAllHeaders()) {
            stringBuffer.append(header.toString()).append("\n");
        }
        stringBuffer.append(httpEntityEnclosingRequest.getRequestLine().toString()).append("\n");
        if (httpEntityEnclosingRequest.getEntity() != null) {
            try {
                int n2;
                InputStream inputStream = httpEntityEnclosingRequest.getEntity().getContent();
                if (inputStream != null && (n2 = inputStream.available()) > 0) {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray);
                    stringBuffer.append("POST:\n");
                    stringBuffer.append(new String(byArray)).append("\n");
                }
            }
            catch (IOException iOException) {
                ae.W("Error Writing hit to log...");
            }
        }
        ae.U(stringBuffer.toString());
    }

    private URL a(ab ab2) {
        if (this.yg != null) {
            return this.yg;
        }
        String string2 = ab2.fd();
        try {
            return new URL("http:".equals(string2) ? "http://www.google-analytics.com/collect" : "https://ssl.google-analytics.com/collect");
        }
        catch (MalformedURLException malformedURLException) {
            ae.T("Error trying to parse the hardcoded host url. This really shouldn't happen.");
            return null;
        }
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.yt = dryRun;
    }
}

