/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.zaad;
import com.google.android.gms.common.api.internal.zaae;
import com.google.android.gms.common.api.internal.zabm;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zabp;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zac;
import com.google.android.gms.common.api.internal.zaci;
import com.google.android.gms.common.api.internal.zact;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zal;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.zap;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zabq
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zau {
    private final Queue zab = new LinkedList();
    @NotOnlyInitialized
    private final Api.Client zac;
    private final ApiKey zad;
    private final zaad zae;
    private final Set zaf = new HashSet();
    private final Map zag = new HashMap();
    private final int zah;
    @Nullable
    private final zact zai;
    private boolean zaj;
    private final List zak = new ArrayList();
    @Nullable
    private ConnectionResult zal = null;
    private int zam = 0;
    final /* synthetic */ GoogleApiManager zaa;

    public final int zab() {
        return this.zah;
    }

    @WorkerThread
    final int zac() {
        return this.zam;
    }

    @WorkerThread
    @Nullable
    public final ConnectionResult zad() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        return this.zal;
    }

    @WorkerThread
    @Nullable
    private final Feature zaB(@Nullable Feature[] featureArray) {
        if (featureArray == null || featureArray.length == 0) {
            return null;
        }
        Feature[] featureArray2 = featureArray2.zac.getAvailableFeatures();
        if (featureArray2 == null) {
            featureArray2 = new Feature[]{};
        }
        ArrayMap arrayMap = new ArrayMap(featureArray2.length);
        for (int i = 0; i < featureArray2.length; ++i) {
            Feature feature = featureArray2[i];
            arrayMap.put(feature.getName(), feature.getVersion());
        }
        for (Feature feature : featureArray) {
            Long l = (Long)arrayMap.get(feature.getName());
            if (l != null && l >= feature.getVersion()) continue;
            return feature;
        }
        return null;
    }

    static /* bridge */ /* synthetic */ Api.Client zae(zabq zabq2) {
        return zabq2.zac;
    }

    public final Api.Client zaf() {
        return this.zac;
    }

    static /* bridge */ /* synthetic */ ApiKey zag(zabq zabq2) {
        return zabq2.zad;
    }

    public final Map zah() {
        return this.zag;
    }

    static /* bridge */ /* synthetic */ void zai(zabq zabq2, Status status) {
        zabq2.zaD(status);
    }

    static /* bridge */ /* synthetic */ void zaj(zabq zabq2) {
        zabq2.zaG();
    }

    static /* bridge */ /* synthetic */ void zak(zabq zabq2, int n) {
        zabq2.zaH(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zal(zabq zabq2, zabs zabs2) {
        if (!zabq2.zak.contains(zabs2) || zabq2.zaj) {
            return;
        }
        if (!zabq2.zac.isConnected()) {
            zabq2.zao();
            return;
        }
        zabq2.zaF();
    }

    static /* bridge */ /* synthetic */ void zam(zabq zabq2, zabs object) {
        if (zabq2.zak.remove(object)) {
            Object[] objectArray;
            GoogleApiManager.zad(zabq2.zaa).removeMessages(15, object);
            GoogleApiManager.zad(zabq2.zaa).removeMessages(16, object);
            Feature feature = zabs.zaa((zabs)object);
            ArrayList<zai> arrayList = new ArrayList<zai>(zabq2.zab.size());
            for (zai zai2 : zabq2.zab) {
                if (!(zai2 instanceof zac) || (objectArray = ((zac)zai2).zab(zabq2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                arrayList.add(zai2);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                objectArray = (zai)arrayList.get(i);
                zabq2.zab.remove(objectArray);
                objectArray.zae((Exception)new UnsupportedApiCallException(feature));
            }
        }
    }

    @WorkerThread
    public zabq(GoogleApiManager googleApiManager, GoogleApi googleApi) {
        this.zaa = googleApiManager;
        this.zac = googleApi.zab(GoogleApiManager.zad(googleApiManager).getLooper(), this);
        this.zad = googleApi.getApiKey();
        this.zae = new zaad();
        this.zah = googleApi.zaa();
        if (this.zac.requiresSignIn()) {
            this.zai = googleApi.zac(GoogleApiManager.zac(googleApiManager), GoogleApiManager.zad(googleApiManager));
            return;
        }
        this.zai = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaC(ConnectionResult connectionResult) {
        Iterator iterator = this.zaf.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zaf.clear();
                return;
            }
            zal zal2 = (zal)iterator.next();
            String string2 = Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS) ? this.zac.getEndpointPackageName() : null;
            zal2.zac(this.zad, connectionResult, string2);
        }
    }

    @WorkerThread
    public final void zan() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zal = null;
    }

    @WorkerThread
    public final void zao() {
        block7: {
            int n;
            com.google.android.gms.common.internal.zal zal2;
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
            if (this.zac.isConnected() || this.zac.isConnecting()) {
                return;
            }
            try {
                GoogleApiManager googleApiManager = this.zaa;
                zal2 = GoogleApiManager.zal(googleApiManager);
                n = zal2.zab(GoogleApiManager.zac(googleApiManager), this.zac);
                if (n == 0) break block7;
            }
            catch (IllegalStateException illegalStateException) {
                this.zar(new ConnectionResult(10), illegalStateException);
                return;
            }
            zal2 = new ConnectionResult(n, null);
            String string2 = this.zac.getClass().getName();
            String string3 = zal2.toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The service for ");
            stringBuilder.append(string2);
            stringBuilder.append(" is not available: ");
            stringBuilder.append(string3);
            Log.w((String)"GoogleApiManager", (String)stringBuilder.toString());
            this.zar((ConnectionResult)zal2, null);
            return;
        }
        Api.Client client = this.zac;
        zabu zabu2 = new zabu(this.zaa, client, this.zad);
        if (client.requiresSignIn()) {
            ((zact)Preconditions.checkNotNull((Object)this.zai)).zae(zabu2);
        }
        try {
            this.zac.connect(zabu2);
            return;
        }
        catch (SecurityException securityException) {
            this.zar(new ConnectionResult(10), securityException);
            return;
        }
    }

    @WorkerThread
    public final void zap(zai zai2) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (this.zac.isConnected()) {
            if (this.zaL(zai2)) {
                this.zaI();
                return;
            }
            this.zab.add(zai2);
            return;
        }
        this.zab.add(zai2);
        zai2 = this.zal;
        if (zai2 != null && zai2.hasResolution()) {
            zabq zabq2 = this;
            zabq2.zar(zabq2.zal, null);
            return;
        }
        this.zao();
    }

    @WorkerThread
    private final void zaD(Status status) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaE(status, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaE(@Nullable Status status, @Nullable Exception exception, boolean bl) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(((zabq)((Object)iterator)).zaa));
        boolean bl2 = status == null;
        boolean bl3 = exception == null;
        if (bl2 == bl3) {
            throw new IllegalArgumentException("Status XOR exception should be null");
        }
        Iterator iterator = ((zabq)((Object)iterator)).zab.iterator();
        while (iterator.hasNext()) {
            zai zai2 = (zai)iterator.next();
            if (bl && zai2.zac != 2) continue;
            if (status != null) {
                zai2.zad(status);
            } else {
                zai2.zae(exception);
            }
            iterator.remove();
        }
        return;
    }

    @WorkerThread
    private final void zaF() {
        ArrayList arrayList = new ArrayList(this.zab);
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            zai zai2;
            block6: {
                block5: {
                    if (n2 >= n) break block5;
                    zai2 = (zai)arrayList.get(n2);
                    if (this.zac.isConnected()) break block6;
                }
                return;
            }
            if (this.zaL(zai2)) {
                this.zab.remove(zai2);
            }
            ++n2;
        }
    }

    @WorkerThread
    final void zaq() {
        ++this.zam;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == GoogleApiManager.zad(this.zaa).getLooper()) {
            this.zaG();
            return;
        }
        GoogleApiManager.zad(this.zaa).post((Runnable)new zabm(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zaG() {
        this.zan();
        this.zaC(ConnectionResult.RESULT_SUCCESS);
        this.zaK();
        Iterator iterator = this.zag.values().iterator();
        while (iterator.hasNext()) {
            zaci zaci2 = (zaci)iterator.next();
            if (this.zaB(zaci2.zaa.getRequiredFeatures()) != null) {
                iterator.remove();
                continue;
            }
            try {
                zaci2.zaa.registerListener(this.zac, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(3);
                this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                break;
            }
            catch (RemoteException remoteException) {
                iterator.remove();
            }
        }
        this.zaF();
        this.zaI();
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zar(connectionResult, null);
    }

    @WorkerThread
    public final void zar(@NonNull ConnectionResult object, @Nullable Exception exception) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        Object object2 = this.zai;
        if (object2 != null) {
            ((zact)object2).zaf();
        }
        this.zan();
        GoogleApiManager.zal(this.zaa).zac();
        this.zaC((ConnectionResult)object);
        if (this.zac instanceof zap && object.getErrorCode() != 24) {
            GoogleApiManager.zat(this.zaa, true);
            object2 = this.zaa;
            GoogleApiManager.zad((GoogleApiManager)object2).sendMessageDelayed(GoogleApiManager.zad((GoogleApiManager)object2).obtainMessage(19), 300000L);
        }
        if (object.getErrorCode() == 4) {
            this.zaD(GoogleApiManager.zaf());
            return;
        }
        if (this.zab.isEmpty()) {
            this.zal = object;
            return;
        }
        if (exception != null) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
            this.zaE(null, exception, false);
            return;
        }
        if (GoogleApiManager.zaC(this.zaa)) {
            zabq zabq2 = this;
            zabq2.zaE(GoogleApiManager.zag(zabq2.zad, object), null, true);
            if (this.zab.isEmpty()) {
                return;
            }
            if (this.zaM((ConnectionResult)object)) {
                return;
            }
            if (!this.zaa.zaE((ConnectionResult)object, this.zah)) {
                if (object.getErrorCode() == 18) {
                    this.zaj = true;
                }
                if (this.zaj) {
                    object = this.zaa;
                    GoogleApiManager.zad((GoogleApiManager)object).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad((GoogleApiManager)object), (int)9, (Object)this.zad), 5000L);
                    return;
                }
                zabq zabq3 = this;
                zabq3.zaD(GoogleApiManager.zag(zabq3.zad, object));
                return;
            }
            return;
        }
        zabq zabq4 = this;
        zabq4.zaD(GoogleApiManager.zag(zabq4.zad, object));
    }

    @Override
    public final void zaa(ConnectionResult connectionResult, Api api, boolean bl) {
        throw null;
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == GoogleApiManager.zad(this.zaa).getLooper()) {
            this.zaH(n);
            return;
        }
        GoogleApiManager.zad(this.zaa).post((Runnable)new zabn(this, n));
    }

    @WorkerThread
    private final void zaH(int n) {
        ((zabq)((Object)iterator)).zan();
        ((zabq)((Object)iterator)).zaj = true;
        ((zabq)((Object)iterator)).zae.zae(n, ((zabq)((Object)iterator)).zac.getLastDisconnectMessage());
        GoogleApiManager googleApiManager = ((zabq)((Object)iterator)).zaa;
        GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)9, (Object)((zabq)((Object)iterator)).zad), 5000L);
        googleApiManager = ((zabq)((Object)iterator)).zaa;
        GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)11, (Object)((zabq)((Object)iterator)).zad), 120000L);
        GoogleApiManager.zal(((zabq)((Object)iterator)).zaa).zac();
        Iterator iterator = ((zabq)((Object)iterator)).zag.values().iterator();
        while (iterator.hasNext()) {
            ((zaci)iterator.next()).zac.run();
        }
    }

    @WorkerThread
    public final void zas(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        Api.Client client = this.zac;
        String string2 = client.getClass().getName();
        String string3 = String.valueOf(connectionResult);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("onSignInFailed for ");
        stringBuilder.append(string2);
        stringBuilder.append(" with ");
        stringBuilder.append(string3);
        client.disconnect(stringBuilder.toString());
        this.zar(connectionResult, null);
    }

    @WorkerThread
    public final void zat(zal zal2) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaf.add(zal2);
    }

    private final void zaI() {
        GoogleApiManager.zad(this.zaa).removeMessages(12, (Object)this.zad);
        GoogleApiManager googleApiManager = this.zaa;
        GoogleApiManager.zad(googleApiManager).sendMessageDelayed(GoogleApiManager.zad(googleApiManager).obtainMessage(12, (Object)this.zad), GoogleApiManager.zab(this.zaa));
    }

    @WorkerThread
    public final void zau() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (this.zaj) {
            this.zao();
            return;
        }
    }

    @WorkerThread
    private final void zaJ(zai zai2) {
        zai2.zag(this.zae, this.zaz());
        try {
            zai2.zaf(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
            return;
        }
    }

    @WorkerThread
    public final void zav() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaD(GoogleApiManager.zaa);
        this.zae.zaf();
        for (ListenerHolder.ListenerKey listenerKey : this.zag.keySet().toArray(new ListenerHolder.ListenerKey[0])) {
            this.zap(new zah(listenerKey, new TaskCompletionSource()));
        }
        this.zaC(new ConnectionResult(4));
        if (this.zac.isConnected()) {
            this.zac.onUserSignOut(new zabp(this));
            return;
        }
    }

    @WorkerThread
    private final void zaK() {
        if (this.zaj) {
            GoogleApiManager.zad(this.zaa).removeMessages(11, (Object)this.zad);
            GoogleApiManager.zad(this.zaa).removeMessages(9, (Object)this.zad);
            this.zaj = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zaw() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (!this.zaj) {
            return;
        }
        this.zaK();
        Object object = this.zaa;
        if (GoogleApiManager.zae((GoogleApiManager)object).isGooglePlayServicesAvailable(GoogleApiManager.zac((GoogleApiManager)object)) == 18) {
            object = "Connection timed out waiting for Google Play services update to complete.";
            object = new Status(21, (String)object);
        } else {
            object = "API failed to connect while resuming due to an unknown error.";
            object = new Status(22, (String)object);
        }
        this.zaD((Status)object);
        this.zac.disconnect("Timing out connection while resuming.");
    }

    static /* bridge */ /* synthetic */ boolean zax(zabq zabq2, boolean bl) {
        return zabq2.zaN(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final boolean zaL(zai object) {
        StringBuilder stringBuilder;
        if (!(object instanceof zac)) {
            ((zabq)((Object)googleApiManager)).zaJ((zai)object);
            return true;
        }
        zac zac2 = (zac)object;
        zabq zabq2 = googleApiManager;
        Feature feature = zabq2.zaB(zac2.zab(zabq2));
        if (feature == null) {
            ((zabq)((Object)googleApiManager)).zaJ((zai)object);
            return true;
        }
        object = ((zabq)((Object)googleApiManager)).zac.getClass().getName();
        String string2 = feature.getName();
        long l = feature.getVersion();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder2.append((String)object);
        StringBuilder stringBuilder3 = stringBuilder;
        stringBuilder3.append(" could not execute call because it requires feature (");
        stringBuilder3.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(l);
        stringBuilder.append(").");
        object = stringBuilder.toString();
        Log.w((String)"GoogleApiManager", (String)object);
        if (GoogleApiManager.zaC(((zabq)((Object)googleApiManager)).zaa) && zac2.zaa((zabq)((Object)googleApiManager))) {
            object = new zabs(((zabq)((Object)googleApiManager)).zad, feature, null);
            int n = ((zabq)((Object)googleApiManager)).zak.indexOf(object);
            if (n >= 0) {
                object = (zabs)((zabq)((Object)googleApiManager)).zak.get(n);
                GoogleApiManager.zad(((zabq)((Object)googleApiManager)).zaa).removeMessages(15, object);
                GoogleApiManager googleApiManager = ((zabq)((Object)googleApiManager)).zaa;
                GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)15, (Object)object), 5000L);
                return false;
            }
            ((zabq)((Object)googleApiManager)).zak.add(object);
            GoogleApiManager googleApiManager = ((zabq)((Object)googleApiManager)).zaa;
            GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)15, (Object)object), 5000L);
            googleApiManager = ((zabq)((Object)googleApiManager)).zaa;
            GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)16, (Object)object), 120000L);
            object = new ConnectionResult(2, null);
            if (super.zaM((ConnectionResult)object)) return false;
            ((zabq)((Object)googleApiManager)).zaa.zaE((ConnectionResult)object, ((zabq)((Object)googleApiManager)).zah);
            return false;
        }
        zac2.zae((Exception)new UnsupportedApiCallException(feature));
        return true;
    }

    final boolean zay() {
        return this.zac.isConnected();
    }

    public final boolean zaz() {
        return this.zac.requiresSignIn();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zaM(@NonNull ConnectionResult connectionResult) {
        Object object = GoogleApiManager.zaq();
        synchronized (object) {
            GoogleApiManager googleApiManager = this.zaa;
            zaae zaae2 = GoogleApiManager.zah(googleApiManager);
            if (zaae2 == null) return false;
            boolean bl = GoogleApiManager.zas(googleApiManager).contains(this.zad);
            if (!bl) return false;
            GoogleApiManager.zah(this.zaa).zah(connectionResult, this.zah);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @ResultIgnorabilityUnspecified
    @WorkerThread
    public final boolean zaA() {
        return this.zaN(true);
    }

    @WorkerThread
    private final boolean zaN(boolean bl) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (this.zac.isConnected() && this.zag.size() == 0) {
            if (this.zae.zag()) {
                if (bl) {
                    this.zaI();
                }
                return false;
            }
            this.zac.disconnect("Timing out service connection.");
            return true;
        }
        return false;
    }
}

