/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaau;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zar;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zap;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

final class zas
implements zabs {
    private final Context mContext;
    private final zaau zaej;
    private final Looper zabm;
    private final zabc zaek;
    private final zabc zael;
    private final Map<Api.AnyClientKey<?>, zabc> zaem;
    private final Set<SignInConnectionListener> zaen = Collections.newSetFromMap(new WeakHashMap());
    private final Api.Client zaeo;
    private Bundle zaep;
    private ConnectionResult zaeq = null;
    private ConnectionResult zaer = null;
    private boolean zaes = false;
    private final Lock zaet;
    @GuardedBy(value="mLock")
    private int zaeu = 0;

    public static zas zaa(Context context, zaau zaau2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList) {
        Object object;
        Api.Client client = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.providesSignIn()) {
                client = object;
            }
            if (object.requiresSignIn()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        Preconditions.checkState((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.AnyClientKey<?> anyClientKey = api.getClientKey();
            if (arrayMap2.containsKey(anyClientKey)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(anyClientKey)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zaq>();
        ArrayList<zaq> arrayList2 = new ArrayList<zaq>();
        ArrayList<zaq> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList3.get(i);
            zaq zaq3 = zaq2;
            if (arrayMap5.containsKey(zaq3.mApi)) {
                ((ArrayList)object).add(zaq3);
                continue;
            }
            if (arrayMap.containsKey(zaq3.mApi)) {
                arrayList2.add(zaq3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zas(context, zaau2, lock, looper, googleApiAvailabilityLight, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap2, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap3, clientSettings, abstractClientBuilder, client, (ArrayList<zaq>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zas(Context context, zaau zaau2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, Map<Api.AnyClientKey<?>, Api.Client> map2, ClientSettings clientSettings, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Api.Client client, ArrayList<zaq> arrayList, ArrayList<zaq> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zaej = zaau2;
        this.zaet = lock;
        this.zabm = looper;
        this.zaeo = client;
        this.zaek = new zabc(context, this.zaej, lock, looper, googleApiAvailabilityLight, map2, null, map4, null, arrayList2, new zau(this, null));
        this.zael = new zabc(context, this.zaej, lock, looper, googleApiAvailabilityLight, map, clientSettings, map3, abstractClientBuilder, arrayList, new zat(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.AnyClientKey<?> anyClientKey : map2.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zaek);
        }
        for (Api.AnyClientKey<?> anyClientKey : map.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zael);
        }
        this.zaem = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zaa(t)) {
            if (this.zax()) {
                t.setFailedResult(new Status(4, null, this.zay()));
                return t;
            }
            return this.zael.enqueue(t);
        }
        return this.zaek.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        if (this.zaa(t)) {
            if (this.zax()) {
                t.setFailedResult(new Status(4, null, this.zay()));
                return t;
            }
            return this.zael.execute(t);
        }
        return this.zaek.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zaem.get(api.getClientKey()).equals(this.zael)) {
            if (this.zax()) {
                return new ConnectionResult(4, this.zay());
            }
            return this.zael.getConnectionResult(api);
        }
        return this.zaek.getConnectionResult(api);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zaeu = 2;
        this.zaes = false;
        zas zas2 = this;
        this.zaer = null;
        zas2.zaeq = null;
        zas2.zaek.connect();
        zas2.zael.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        this.zaer = null;
        this.zaeq = null;
        this.zaeu = 0;
        this.zaek.disconnect();
        this.zael.disconnect();
        this.zaw();
    }

    @Override
    public final boolean isConnected() {
        this.zaet.lock();
        try {
            boolean bl = this.zaek.isConnected() && (this.zael.isConnected() || this.zax() || this.zaeu == 1);
            return bl;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zaet.lock();
        try {
            boolean bl = this.zaeu == 2;
            return bl;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        this.zaet.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zael.isConnected()) {
                this.zaen.add(signInConnectionListener);
                if (this.zaeu == 0) {
                    this.zaeu = 1;
                }
                this.zaer = null;
                this.zael.connect();
                return true;
            }
        }
        finally {
            this.zaet.unlock();
        }
        return false;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zau() {
        this.zaek.zau();
        this.zael.zau();
    }

    @Override
    public final void maybeSignOut() {
        this.zaet.lock();
        try {
            boolean bl = this.isConnecting();
            this.zael.disconnect();
            this.zaer = new ConnectionResult(4);
            if (bl) {
                new zap(this.zabm).post(new zar(this));
            } else {
                this.zaw();
            }
            return;
        }
        finally {
            this.zaet.unlock();
        }
    }

    @GuardedBy(value="mLock")
    private final void zav() {
        if (zas.zab(this.zaeq)) {
            if (zas.zab(this.zaer) || this.zax()) {
                zas zas2 = this;
                switch (zas2.zaeu) {
                    case 2: {
                        zas2.zaej.zab(zas2.zaep);
                    }
                    case 1: {
                        zas2.zaw();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zas2.zaeu = 0;
                return;
            }
            if (this.zaer != null) {
                if (this.zaeu == 1) {
                    this.zaw();
                    return;
                }
                this.zaa(this.zaer);
                this.zaek.disconnect();
                return;
            }
        } else {
            if (this.zaeq != null && zas.zab(this.zaer)) {
                this.zael.disconnect();
                this.zaa(this.zaeq);
                return;
            }
            if (this.zaeq != null && this.zaer != null) {
                ConnectionResult connectionResult = this.zaeq;
                if (this.zael.zahw < this.zaek.zahw) {
                    connectionResult = this.zaer;
                }
                this.zaa(connectionResult);
            }
        }
    }

    @GuardedBy(value="mLock")
    private final void zaa(ConnectionResult connectionResult) {
        switch (this.zaeu) {
            case 2: {
                this.zaej.zac(connectionResult);
            }
            case 1: {
                this.zaw();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zaeu = 0;
    }

    @GuardedBy(value="mLock")
    private final void zaw() {
        Iterator<SignInConnectionListener> iterator = this.zaen.iterator();
        while (iterator.hasNext()) {
            iterator.next().onComplete();
        }
        this.zaen.clear();
    }

    @GuardedBy(value="mLock")
    private final void zaa(int n, boolean bl) {
        this.zaej.zab(n, bl);
        this.zaer = null;
        this.zaeq = null;
    }

    @GuardedBy(value="mLock")
    private final boolean zax() {
        return this.zaer != null && this.zaer.getErrorCode() == 4;
    }

    private final boolean zaa(BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient> apiMethodImpl) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = apiMethodImpl.getClientKey();
        Preconditions.checkArgument((boolean)this.zaem.containsKey(anyClientKey), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zaem.get(anyClientKey).equals(this.zael);
    }

    @Nullable
    private final PendingIntent zay() {
        if (this.zaeo == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zaej), (Intent)this.zaeo.getSignInIntent(), (int)0x8000000);
    }

    private final void zaa(Bundle bundle) {
        if (this.zaep == null) {
            this.zaep = bundle;
            return;
        }
        if (bundle != null) {
            this.zaep.putAll(bundle);
        }
    }

    private static boolean zab(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zael.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zaek.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zaa(zas zas2) {
        return zas2.zaet;
    }

    static /* synthetic */ void zab(zas zas2) {
        zas2.zav();
    }

    static /* synthetic */ void zaa(zas zas2, Bundle bundle) {
        zas2.zaa(bundle);
    }

    static /* synthetic */ ConnectionResult zaa(zas zas2, ConnectionResult connectionResult) {
        zas2.zaeq = connectionResult;
        return zas2.zaeq;
    }

    static /* synthetic */ boolean zac(zas zas2) {
        return zas2.zaes;
    }

    static /* synthetic */ ConnectionResult zad(zas zas2) {
        return zas2.zaer;
    }

    static /* synthetic */ boolean zaa(zas zas2, boolean bl) {
        zas2.zaes = bl;
        return zas2.zaes;
    }

    static /* synthetic */ void zaa(zas zas2, int n, boolean bl) {
        zas2.zaa(n, bl);
    }

    static /* synthetic */ zabc zae(zas zas2) {
        return zas2.zael;
    }

    static /* synthetic */ ConnectionResult zab(zas zas2, ConnectionResult connectionResult) {
        zas2.zaer = connectionResult;
        return zas2.zaer;
    }

    static /* synthetic */ zabc zaf(zas zas2) {
        return zas2.zaek;
    }
}

