/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacn;
import com.google.android.gms.common.api.internal.zacs;
import com.google.android.gms.common.api.internal.zao;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
@KeepForSdk
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zadr = new zao();
    private final Object zads = new Object();
    private final CallbackHandler<R> zadt;
    private final WeakReference<GoogleApiClient> zadu;
    private final CountDownLatch zadv = new CountDownLatch(1);
    private final ArrayList<PendingResult.StatusListener> zadw = new ArrayList();
    private ResultCallback<? super R> zadx;
    private final AtomicReference<zacs> zady = new AtomicReference();
    private R zacm;
    private Status mStatus;
    @KeepName
    private zaa mResultGuardian;
    private volatile boolean zadz;
    private boolean zaea;
    private boolean zaeb;
    private ICancelToken zaec;
    private volatile zacn<R> zaed;
    private boolean zaee = false;

    @Deprecated
    BasePendingResult() {
        this.zadt = new CallbackHandler(Looper.getMainLooper());
        this.zadu = new WeakReference<Object>(null);
    }

    @KeepForSdk
    protected BasePendingResult(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zadt = new CallbackHandler(looper);
        this.zadu = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    @KeepForSdk
    protected BasePendingResult(Looper looper) {
        this.zadt = new CallbackHandler(looper);
        this.zadu = new WeakReference<Object>(null);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BasePendingResult(@NonNull CallbackHandler<R> callbackHandler) {
        this.zadt = (CallbackHandler)((Object)Preconditions.checkNotNull(callbackHandler, (Object)"CallbackHandler must not be null"));
        this.zadu = new WeakReference<Object>(null);
    }

    @KeepForSdk
    public final boolean isReady() {
        return this.zadv.getCount() == 0L;
    }

    @Override
    public final R await() {
        Preconditions.checkNotMainThread((String)"await must not be called on the UI thread");
        Preconditions.checkState((!this.zadz ? 1 : 0) != 0, (Object)"Result has already been consumed");
        Preconditions.checkState((this.zaed == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zadv.await();
        }
        catch (InterruptedException interruptedException) {
            this.zab(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            Preconditions.checkNotMainThread((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        Preconditions.checkState((!this.zadz ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Preconditions.checkState((this.zaed == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zadv.await(l, timeUnit)) {
                this.zab(Status.RESULT_TIMEOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zab(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zads;
        synchronized (object) {
            if (resultCallback == null) {
                this.zadx = null;
                return;
            }
            Preconditions.checkState((!this.zadz ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zaed == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zadt.zaa(resultCallback, (R)this.get());
            } else {
                this.zadx = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zads;
        synchronized (object) {
            if (resultCallback == null) {
                this.zadx = null;
                return;
            }
            Preconditions.checkState((!this.zadz ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((this.zaed == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zadt.zaa(resultCallback, (R)this.get());
            } else {
                this.zadx = resultCallback;
                long l2 = timeUnit.toMillis(l);
                BasePendingResult basePendingResult = this;
                CallbackHandler<R> callbackHandler = this.zadt;
                callbackHandler.sendMessageDelayed(callbackHandler.obtainMessage(2, basePendingResult), l2);
            }
            return;
        }
    }

    private static <R extends Result> ResultCallback<R> zaa(ResultCallback<R> resultCallback) {
        return resultCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStatusListener(PendingResult.StatusListener statusListener) {
        Preconditions.checkArgument((statusListener != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zads;
        synchronized (object) {
            if (this.isReady()) {
                statusListener.onComplete(this.mStatus);
            } else {
                this.zadw.add(statusListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @KeepForSdk
    public void cancel() {
        Object object = this.zads;
        synchronized (object) {
            if (this.zaea || this.zadz) {
                return;
            }
            if (this.zaec != null) {
                try {
                    this.zaec.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zab(this.zacm);
            this.zaea = true;
            this.zaa(this.createFailedResult(Status.RESULT_CANCELED));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zar() {
        Object object = this.zads;
        synchronized (object) {
            if ((GoogleApiClient)this.zadu.get() == null || !this.zaee) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zads;
        synchronized (object) {
            return this.zaea;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        Preconditions.checkState((!this.zadz ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zads;
        synchronized (object) {
            Preconditions.checkState((this.zaed == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zadx == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            Preconditions.checkState((!this.zaea ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zaee = true;
            this.zaed = new zacn(this.zadu);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zaed).then(resultTransform);
            if (this.isReady()) {
                this.zadt.zaa(this.zaed, this.get());
            } else {
                this.zadx = this.zaed;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void setResult(R r) {
        Object object = this.zads;
        synchronized (object) {
            if (!this.zaeb && !this.zaea) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                BasePendingResult.zab(r);
                return;
            }
            Preconditions.checkState((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            Preconditions.checkState((!this.zadz ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zaa(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zab(Status status) {
        Object object = this.zads;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(status));
                this.zaeb = true;
            }
            return;
        }
    }

    @NonNull
    @KeepForSdk
    protected abstract R createFailedResult(Status var1);

    public final void zaa(zacs zacs2) {
        this.zady.set(zacs2);
    }

    @Override
    public final Integer zal() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    protected final void setCancelToken(ICancelToken iCancelToken) {
        Object object = this.zads;
        synchronized (object) {
            this.zaec = iCancelToken;
            return;
        }
    }

    public final void zas() {
        this.zaee = this.zaee || zadr.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zads;
        synchronized (object) {
            Preconditions.checkState((!this.zadz ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            Preconditions.checkState((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zacm;
            this.zacm = null;
            this.zadx = null;
            this.zadz = true;
        }
        BasePendingResult basePendingResult = this;
        zacs zacs2 = basePendingResult.zady.getAndSet(null);
        if (zacs2 != null) {
            zacs2.zac(basePendingResult);
        }
        return r;
    }

    private final void zaa(R r) {
        this.zacm = r;
        this.zaec = null;
        this.zadv.countDown();
        this.mStatus = this.zacm.getStatus();
        if (this.zaea) {
            this.zadx = null;
        } else if (this.zadx == null) {
            if (this.zacm instanceof Releasable) {
                this.mResultGuardian = new zaa(null);
            }
        } else {
            this.zadt.removeMessages(2);
            this.zadt.zaa(this.zadx, (R)this.get());
        }
        ArrayList<PendingResult.StatusListener> arrayList = this.zadw;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.StatusListener statusListener = arrayList.get(i);
            statusListener.onComplete(this.mStatus);
        }
        this.zadw.clear();
    }

    public static void zab(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zaa {
        private zaa() {
        }

        protected final void finalize() throws Throwable {
            BasePendingResult.zab(BasePendingResult.this.zacm);
            super.finalize();
        }

        /* synthetic */ zaa(zao zao2) {
            this();
        }
    }

    @VisibleForTesting
    public static class CallbackHandler<R extends Result>
    extends zap {
        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public final void zaa(ResultCallback<? super R> resultCallback, R r) {
            resultCallback = BasePendingResult.zaa(resultCallback);
            this.sendMessage(this.obtainMessage(1, new Pair((Object)resultCallback, r)));
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    Result result = (Result)pair.second;
                    ResultCallback resultCallback = (ResultCallback)pair.first;
                    try {
                        resultCallback.onResult(result);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zab(result);
                        throw runtimeException;
                    }
                }
                case 2: {
                    ((BasePendingResult)message.obj).zab(Status.RESULT_TIMEOUT);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }
    }
}

