/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ConnectionErrorMessages;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.dynamic.zab;
import com.google.android.gms.dynamic.zac;
import com.google.android.gms.dynamic.zad;
import com.google.android.gms.dynamic.zae;
import com.google.android.gms.dynamic.zaf;
import com.google.android.gms.dynamic.zag;
import java.util.LinkedList;

@KeepForSdk
public abstract class DeferredLifecycleHelper<T extends LifecycleDelegate> {
    private T zarv;
    private Bundle zarw;
    private LinkedList<zaa> zarx;
    private final OnDelegateCreatedListener<T> zary = new zab(this);

    @KeepForSdk
    public DeferredLifecycleHelper() {
    }

    @KeepForSdk
    public T getDelegate() {
        return this.zarv;
    }

    private final void zal(int n) {
        while (!this.zarx.isEmpty() && this.zarx.getLast().getState() >= n) {
            this.zarx.removeLast();
        }
    }

    private final void zaa(Bundle bundle, zaa zaa2) {
        if (this.zarv != null) {
            zaa2.zaa((LifecycleDelegate)this.zarv);
            return;
        }
        if (this.zarx == null) {
            this.zarx = new LinkedList();
        }
        this.zarx.add(zaa2);
        if (bundle != null) {
            if (this.zarw == null) {
                this.zarw = (Bundle)bundle.clone();
            } else {
                this.zarw.putAll(bundle);
            }
        }
        this.createDelegate(this.zary);
    }

    @KeepForSdk
    protected abstract void createDelegate(OnDelegateCreatedListener<T> var1);

    @KeepForSdk
    public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
        this.zaa(bundle2, new com.google.android.gms.dynamic.zaa(this, activity, bundle, bundle2));
    }

    @KeepForSdk
    public void onCreate(Bundle bundle) {
        this.zaa(bundle, new zad(this, bundle));
    }

    @KeepForSdk
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zaa(bundle, new zac(this, frameLayout, layoutInflater, viewGroup, bundle));
        if (this.zarv == null) {
            this.handleGooglePlayUnavailable(frameLayout);
        }
        return frameLayout;
    }

    @KeepForSdk
    protected void handleGooglePlayUnavailable(FrameLayout frameLayout) {
        DeferredLifecycleHelper.showGooglePlayUnavailableMessage(frameLayout);
    }

    @KeepForSdk
    public static void showGooglePlayUnavailableMessage(FrameLayout frameLayout) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        FrameLayout frameLayout2 = frameLayout;
        Context context = frameLayout2.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = ConnectionErrorMessages.getErrorMessage(context, n);
        String string3 = ConnectionErrorMessages.getErrorDialogButtonMessage(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout2.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout2.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout2.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        Intent intent = googleApiAvailability.getErrorResolutionIntent(context, n, null);
        if (intent != null) {
            Button button = new Button(context);
            button.setId(16908313);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener((View.OnClickListener)new zaf(context, intent));
        }
    }

    @KeepForSdk
    public void onStart() {
        this.zaa(null, new zae(this));
    }

    @KeepForSdk
    public void onResume() {
        this.zaa(null, new zag(this));
    }

    @KeepForSdk
    public void onPause() {
        if (this.zarv != null) {
            this.zarv.onPause();
            return;
        }
        this.zal(5);
    }

    @KeepForSdk
    public void onStop() {
        if (this.zarv != null) {
            this.zarv.onStop();
            return;
        }
        this.zal(4);
    }

    @KeepForSdk
    public void onDestroyView() {
        if (this.zarv != null) {
            this.zarv.onDestroyView();
            return;
        }
        this.zal(2);
    }

    @KeepForSdk
    public void onDestroy() {
        if (this.zarv != null) {
            this.zarv.onDestroy();
            return;
        }
        this.zal(1);
    }

    @KeepForSdk
    public void onSaveInstanceState(Bundle bundle) {
        if (this.zarv != null) {
            this.zarv.onSaveInstanceState(bundle);
            return;
        }
        if (this.zarw != null) {
            bundle.putAll(this.zarw);
        }
    }

    @KeepForSdk
    public void onLowMemory() {
        if (this.zarv != null) {
            this.zarv.onLowMemory();
        }
    }

    static /* synthetic */ LifecycleDelegate zaa(DeferredLifecycleHelper deferredLifecycleHelper, LifecycleDelegate lifecycleDelegate) {
        deferredLifecycleHelper.zarv = lifecycleDelegate;
        return deferredLifecycleHelper.zarv;
    }

    static /* synthetic */ LinkedList zaa(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zarx;
    }

    static /* synthetic */ LifecycleDelegate zab(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zarv;
    }

    static /* synthetic */ Bundle zaa(DeferredLifecycleHelper deferredLifecycleHelper, Bundle bundle) {
        deferredLifecycleHelper.zarw = null;
        return null;
    }

    private static interface zaa {
        public int getState();

        public void zaa(LifecycleDelegate var1);
    }
}

