/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zap;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class GmsClientEventManager
implements Handler.Callback {
    private final GmsClientEventState zaoy;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zaoz = new ArrayList();
    @VisibleForTesting
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zapa = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zapb = new ArrayList();
    private volatile boolean zapc = false;
    private final AtomicInteger zapd = new AtomicInteger(0);
    private boolean zape = false;
    private final Handler mHandler;
    private final Object mLock = new Object();

    public GmsClientEventManager(Looper looper, GmsClientEventState gmsClientEventState) {
        this.zaoy = gmsClientEventState;
        this.mHandler = new zap(looper, this);
    }

    public final void disableCallbacks() {
        this.zapc = false;
        this.zapd.incrementAndGet();
    }

    public final void enableCallbacks() {
        this.zapc = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected final void onConnectionSuccess() {
        Object object = this.mLock;
        synchronized (object) {
            this.onConnectionSuccess(this.zaoy.getConnectionHint());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onConnectionSuccess(Bundle bundle) {
        Preconditions.checkHandlerThread((Handler)this.mHandler, (String)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkState((!this.zape ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.zape = true;
            Preconditions.checkState((this.zapa.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zaoz);
            int n = this.zapd.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zapc || !this.zaoy.isConnected() || this.zapd.get() != n) break;
                if (this.zapa.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnected(bundle);
            }
            this.zapa.clear();
            this.zape = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onUnintentionalDisconnection(int n) {
        Preconditions.checkHandlerThread((Handler)this.mHandler, (String)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            this.zape = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zaoz);
            int n2 = this.zapd.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zapc || this.zapd.get() != n2) break;
                if (!this.zaoz.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnectionSuspended(n);
            }
            this.zapa.clear();
            this.zape = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void onConnectionFailure(ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)this.mHandler, (String)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zapb);
            int n = this.zapd.get();
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = arrayList2.get(i);
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
                if (this.zapc && this.zapd.get() == n) continue;
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            if (this.zaoz.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zaoz.add(connectionCallbacks);
            }
        }
        if (this.zaoy.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            return this.zaoz.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zaoz.remove(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.zape) {
                this.zapa.add(connectionCallbacks);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            if (this.zapb.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zapb.add(onConnectionFailedListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            return this.zapb.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zapb.remove(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.mLock;
            synchronized (object) {
                if (this.zapc && this.zaoy.isConnected() && this.zaoz.contains(connectionCallbacks)) {
                    Bundle bundle = this.zaoy.getConnectionHint();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public final boolean areCallbacksEnabled() {
        return this.zapc;
    }

    @VisibleForTesting
    public static interface GmsClientEventState {
        public boolean isConnected();

        public Bundle getConnectionHint();
    }
}

