/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.stable.zza;
import com.google.android.gms.internal.stable.zzb;
import com.google.android.gms.internal.stable.zzc;
import com.google.android.gms.signin.internal.AuthAccountResult;
import com.google.android.gms.signin.internal.SignInResponse;

public interface ISignInCallbacks
extends IInterface {
    public void onAuthAccountComplete(ConnectionResult var1, AuthAccountResult var2) throws RemoteException;

    public void onSaveAccountToSessionStoreComplete(Status var1) throws RemoteException;

    public void onRecordConsentComplete(Status var1) throws RemoteException;

    public void onGetCurrentAccountComplete(Status var1, GoogleSignInAccount var2) throws RemoteException;

    public void onSignInComplete(SignInResponse var1) throws RemoteException;

    public static abstract class Stub
    extends zzb
    implements ISignInCallbacks {
        public Stub() {
            super("com.google.android.gms.signin.internal.ISignInCallbacks");
        }

        public static ISignInCallbacks asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.signin.internal.ISignInCallbacks");
            if (iInterface instanceof ISignInCallbacks) {
                return (ISignInCallbacks)iInterface;
            }
            return new Proxy(iBinder);
        }

        protected boolean dispatchTransaction(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 3: {
                    ConnectionResult connectionResult = (ConnectionResult)zzc.zza((Parcel)parcel, (Parcelable.Creator)ConnectionResult.CREATOR);
                    AuthAccountResult authAccountResult = (AuthAccountResult)zzc.zza((Parcel)parcel, AuthAccountResult.CREATOR);
                    this.onAuthAccountComplete(connectionResult, authAccountResult);
                    break;
                }
                case 4: {
                    Status status = (Status)zzc.zza((Parcel)parcel, (Parcelable.Creator)Status.CREATOR);
                    this.onSaveAccountToSessionStoreComplete(status);
                    break;
                }
                case 6: {
                    Status status = (Status)zzc.zza((Parcel)parcel, (Parcelable.Creator)Status.CREATOR);
                    this.onRecordConsentComplete(status);
                    break;
                }
                case 7: {
                    Status status = (Status)zzc.zza((Parcel)parcel, (Parcelable.Creator)Status.CREATOR);
                    GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)zzc.zza((Parcel)parcel, GoogleSignInAccount.CREATOR);
                    this.onGetCurrentAccountComplete(status, googleSignInAccount);
                    break;
                }
                case 8: {
                    SignInResponse signInResponse = (SignInResponse)zzc.zza((Parcel)parcel, SignInResponse.CREATOR);
                    this.onSignInComplete(signInResponse);
                    break;
                }
                default: {
                    return false;
                }
            }
            parcel2.writeNoException();
            return true;
        }

        public static class Proxy
        extends zza
        implements ISignInCallbacks {
            Proxy(IBinder iBinder) {
                super(iBinder, "com.google.android.gms.signin.internal.ISignInCallbacks");
            }

            @Override
            public void onAuthAccountComplete(ConnectionResult connectionResult, AuthAccountResult authAccountResult) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)connectionResult);
                zzc.zza((Parcel)parcel, (Parcelable)authAccountResult);
                this.transactAndReadExceptionReturnVoid(3, parcel);
            }

            @Override
            public void onSaveAccountToSessionStoreComplete(Status status) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)status);
                this.transactAndReadExceptionReturnVoid(4, parcel);
            }

            @Override
            public void onRecordConsentComplete(Status status) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)status);
                this.transactAndReadExceptionReturnVoid(6, parcel);
            }

            @Override
            public void onGetCurrentAccountComplete(Status status, GoogleSignInAccount googleSignInAccount) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)status);
                zzc.zza((Parcel)parcel, (Parcelable)googleSignInAccount);
                this.transactAndReadExceptionReturnVoid(7, parcel);
            }

            @Override
            public void onSignInComplete(SignInResponse signInResponse) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (Parcelable)signInResponse);
                this.transactAndReadExceptionReturnVoid(8, parcel);
            }
        }
    }
}

