/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.SparseIntArray;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.internal.Preconditions;

public class GoogleApiAvailabilityCache {
    private final SparseIntArray zzug = new SparseIntArray();
    private GoogleApiAvailabilityLight zzuh;

    public GoogleApiAvailabilityCache() {
        this(GoogleApiAvailability.getInstance());
    }

    public GoogleApiAvailabilityCache(@NonNull GoogleApiAvailabilityLight googleApiAvailabilityLight) {
        Preconditions.checkNotNull((Object)googleApiAvailabilityLight);
        this.zzuh = googleApiAvailabilityLight;
    }

    public int getClientAvailability(@NonNull Context context, @NonNull Api.Client client) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)client);
        if (!client.requiresGooglePlayServices()) {
            return 0;
        }
        int n = client.getMinApkVersion();
        int n2 = this.zzug.get(n, -1);
        if (n2 != -1) {
            return n2;
        }
        for (int i = 0; i < this.zzug.size(); ++i) {
            int n3 = this.zzug.keyAt(i);
            if (n3 <= n || this.zzug.get(n3) != 0) continue;
            n2 = 0;
            break;
        }
        if (n2 == -1) {
            n2 = this.zzuh.isGooglePlayServicesAvailable(context, n);
        }
        this.zzug.put(n, n2);
        return n2;
    }

    public void flush() {
        this.zzug.clear();
    }
}

