/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.zzak;
import com.google.android.gms.common.api.internal.zzal;
import com.google.android.gms.common.api.internal.zzam;
import com.google.android.gms.common.api.internal.zzap;
import com.google.android.gms.common.api.internal.zzas;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.signin.SignInClient;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.SignInResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zzaj
implements zzbc {
    private final zzbd zzhf;
    private final Lock zzga;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zzgk;
    private ConnectionResult zzgt;
    private int zzhi;
    private int zzhj = 0;
    private int zzhk;
    private final Bundle zzhl = new Bundle();
    private final Set<Api.AnyClientKey> zzhm = new HashSet<Api.AnyClientKey>();
    private SignInClient zzhn;
    private boolean zzho;
    private boolean zzhp;
    private boolean zzhq;
    private IAccountAccessor zzhr;
    private boolean zzhs;
    private boolean zzht;
    private final ClientSettings zzgf;
    private final Map<Api<?>, Boolean> zzgi;
    private final Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> zzdh;
    private ArrayList<Future<?>> zzhu = new ArrayList();

    public zzaj(zzbd zzbd2, ClientSettings clientSettings, Map<Api<?>, Boolean> map, GoogleApiAvailabilityLight googleApiAvailabilityLight, Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> abstractClientBuilder, Lock lock, Context context) {
        this.zzhf = zzbd2;
        this.zzgf = clientSettings;
        this.zzgi = map;
        this.zzgk = googleApiAvailabilityLight;
        this.zzdh = abstractClientBuilder;
        this.zzga = lock;
        this.mContext = context;
    }

    @Override
    public final void begin() {
        this.zzhf.zzjb.clear();
        this.zzhp = false;
        this.zzgt = null;
        this.zzhj = 0;
        this.zzho = true;
        this.zzhq = false;
        this.zzhs = false;
        boolean bl = false;
        HashMap<Api.Client, zzal> hashMap = new HashMap<Api.Client, zzal>();
        for (Api<?> api : this.zzgi.keySet()) {
            Api.Client client = this.zzhf.zzil.get(api.getClientKey());
            bl |= api.zzj().getPriority() == 1;
            boolean bl2 = this.zzgi.get(api);
            if (client.requiresSignIn()) {
                this.zzhp = true;
                if (bl2) {
                    this.zzhm.add(api.getClientKey());
                } else {
                    this.zzho = false;
                }
            }
            hashMap.put(client, new zzal(this, api, bl2));
        }
        if (bl) {
            this.zzhp = false;
        }
        if (this.zzhp) {
            this.zzgf.setClientSessionId(System.identityHashCode(this.zzhf.zzfq));
            zzas zzas2 = new zzas(this, null);
            this.zzhn = this.zzdh.buildClient(this.mContext, ((GoogleApiClient)this.zzhf.zzfq).getLooper(), this.zzgf, this.zzgf.getSignInOptions(), zzas2, zzas2);
        }
        this.zzhk = this.zzhf.zzil.size();
        this.zzhu.add(zzbg.zzbe().submit(new zzam(this, hashMap)));
    }

    @GuardedBy(value="mLock")
    private final boolean zzar() {
        --this.zzhk;
        if (this.zzhk > 0) {
            return false;
        }
        if (this.zzhk < 0) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zzhf.zzfq.zzbb());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zze(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzgt != null) {
            this.zzhf.zzje = this.zzhi;
            this.zze(this.zzgt);
            return false;
        }
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zza(SignInResponse signInResponse) {
        if (!this.zze(0)) {
            return;
        }
        ConnectionResult connectionResult = signInResponse.getConnectionResult();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = signInResponse.getResolveAccountResponse();
            ConnectionResult connectionResult2 = resolveAccountResponse.getConnectionResult();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zze(connectionResult2);
                return;
            }
            this.zzhq = true;
            this.zzhr = resolveAccountResponse.getAccountAccessor();
            this.zzhs = resolveAccountResponse.getSaveDefaultAccount();
            this.zzht = resolveAccountResponse.isFromCrossClientAuth();
            this.zzas();
            return;
        }
        if (this.zzd(connectionResult)) {
            this.zzau();
            this.zzas();
            return;
        }
        this.zze(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zzas() {
        if (this.zzhk != 0) {
            return;
        }
        if (!this.zzhp || this.zzhq) {
            zzaj zzaj2 = this;
            ArrayList<Api.Client> arrayList = new ArrayList<Api.Client>();
            zzaj2.zzhj = 1;
            zzaj2.zzhk = zzaj2.zzhf.zzil.size();
            for (Api.AnyClientKey<?> anyClientKey : zzaj2.zzhf.zzil.keySet()) {
                if (zzaj2.zzhf.zzjb.containsKey(anyClientKey)) {
                    if (!zzaj2.zzar()) continue;
                    zzaj2.zzat();
                    continue;
                }
                arrayList.add(zzaj2.zzhf.zzil.get(anyClientKey));
            }
            if (!arrayList.isEmpty()) {
                zzaj2.zzhu.add(zzbg.zzbe().submit(new zzap(zzaj2, arrayList)));
            }
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnected(Bundle bundle) {
        if (!this.zze(1)) {
            return;
        }
        if (bundle != null) {
            this.zzhl.putAll(bundle);
        }
        if (this.zzar()) {
            this.zzat();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (!this.zze(1)) {
            return;
        }
        this.zzb(connectionResult, api, bl);
        if (this.zzar()) {
            this.zzat();
        }
    }

    @GuardedBy(value="mLock")
    private final void zzat() {
        this.zzhf.zzbd();
        zzbg.zzbe().execute(new zzak(this));
        if (this.zzhn != null) {
            if (this.zzhs) {
                this.zzhn.saveDefaultAccount(this.zzhr, this.zzht);
            }
            this.zza(false);
        }
        for (Api.AnyClientKey<?> anyClientKey : this.zzhf.zzjb.keySet()) {
            this.zzhf.zzil.get(anyClientKey).disconnect();
        }
        Bundle bundle = this.zzhl.isEmpty() ? null : this.zzhl;
        this.zzhf.zzjf.zzb(bundle);
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(T t) {
        this.zzhf.zzfq.zzgo.add(t);
        return t;
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public final void connect() {
    }

    @Override
    public final boolean disconnect() {
        this.zzav();
        this.zza(true);
        this.zzhf.zzf(null);
        return true;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnectionSuspended(int n) {
        this.zze(new ConnectionResult(8, null));
    }

    /*
     * Unable to fully structure code
     */
    @GuardedBy(value="mLock")
    private final void zzb(ConnectionResult var1_1, Api<?> var2_2, boolean var3_3) {
        block3: {
            var4_4 = var2_2.zzj().getPriority();
            var7_5 = var1_1;
            var6_6 = var3_3;
            var5_7 = this;
            if (!var6_6) break block3;
            var9_8 = var7_5;
            var8_9 = var5_7;
            if (!(var9_8.hasResolution() != false ? true : var8_9.zzgk.getErrorResolutionIntent(var9_8.getErrorCode()) != null)) ** GOTO lbl-1000
        }
        if (var5_7.zzgt == null || var4_4 < var5_7.zzhi) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            this.zzgt = var1_1;
            this.zzhi = var4_4;
        }
        this.zzhf.zzjb.put(var2_2.getClientKey(), var1_1);
    }

    @GuardedBy(value="mLock")
    private final void zzau() {
        this.zzhp = false;
        this.zzhf.zzfq.zzim = Collections.emptySet();
        for (Api.AnyClientKey anyClientKey : this.zzhm) {
            if (this.zzhf.zzjb.containsKey(anyClientKey)) continue;
            this.zzhf.zzjb.put(anyClientKey, new ConnectionResult(17, null));
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zzd(ConnectionResult connectionResult) {
        return this.zzho && !connectionResult.hasResolution();
    }

    @GuardedBy(value="mLock")
    private final void zze(ConnectionResult connectionResult) {
        this.zzav();
        this.zza(!connectionResult.hasResolution());
        this.zzhf.zzf(connectionResult);
        this.zzhf.zzjf.zzc(connectionResult);
    }

    private final void zza(boolean bl) {
        if (this.zzhn != null) {
            if (this.zzhn.isConnected() && bl) {
                this.zzhn.clearAccountFromSessionStore();
            }
            this.zzhn.disconnect();
            this.zzhr = null;
        }
    }

    private final void zzav() {
        ArrayList<Future<?>> arrayList = this.zzhu;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Future<?> future = arrayList.get(i);
            future.cancel(true);
        }
        this.zzhu.clear();
    }

    private final Set<Scope> zzaw() {
        if (this.zzgf == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzgf.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zzgf.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            if (this.zzhf.zzjb.containsKey(api.getClientKey())) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        return hashSet;
    }

    @GuardedBy(value="mLock")
    private final boolean zze(int n) {
        if (this.zzhj != n) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zzhf.zzfq.zzbb());
            String string2 = String.valueOf(this);
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zzhk;
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = zzaj.zzf(this.zzhj);
            String string4 = zzaj.zzf(n);
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zze(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private static String zzf(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Context zza(zzaj zzaj2) {
        return zzaj2.mContext;
    }

    static /* synthetic */ GoogleApiAvailabilityLight zzb(zzaj zzaj2) {
        return zzaj2.zzgk;
    }

    static /* synthetic */ Lock zzc(zzaj zzaj2) {
        return zzaj2.zzga;
    }

    static /* synthetic */ zzbd zzd(zzaj zzaj2) {
        return zzaj2.zzhf;
    }

    static /* synthetic */ void zza(zzaj zzaj2, ConnectionResult connectionResult) {
        zzaj2.zze(connectionResult);
    }

    static /* synthetic */ boolean zze(zzaj zzaj2) {
        return zzaj2.zzhp;
    }

    static /* synthetic */ SignInClient zzf(zzaj zzaj2) {
        return zzaj2.zzhn;
    }

    static /* synthetic */ Set zzg(zzaj zzaj2) {
        return zzaj2.zzaw();
    }

    static /* synthetic */ IAccountAccessor zzh(zzaj zzaj2) {
        return zzaj2.zzhr;
    }

    static /* synthetic */ boolean zzb(zzaj zzaj2, ConnectionResult connectionResult) {
        return zzaj2.zzd(connectionResult);
    }

    static /* synthetic */ void zzi(zzaj zzaj2) {
        zzaj2.zzau();
    }

    static /* synthetic */ void zzj(zzaj zzaj2) {
        zzaj2.zzas();
    }

    static /* synthetic */ boolean zza(zzaj zzaj2, int n) {
        return zzaj2.zze(0);
    }

    static /* synthetic */ void zza(zzaj zzaj2, ConnectionResult connectionResult, Api api, boolean bl) {
        zzaj2.zzb(connectionResult, api, bl);
    }

    static /* synthetic */ boolean zzk(zzaj zzaj2) {
        return zzaj2.zzar();
    }

    static /* synthetic */ void zza(zzaj zzaj2, SignInResponse signInResponse) {
        zzaj2.zza(signInResponse);
    }
}

