/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.data.zzf;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Hide
@KeepName
public final class DataHolder
extends zzbgl
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zzf();
    private int zzehz;
    private final String[] zzgcl;
    private Bundle zzgcm;
    private final CursorWindow[] zzgcn;
    private final int zzcc;
    private final Bundle zzgco;
    private int[] zzgcp;
    int zzgcq;
    private boolean mClosed = false;
    private boolean zzgcr = true;
    private static final zza zzgcs = new zze(new String[0], null);

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.zzehz = n;
        this.zzgcl = stringArray;
        this.zzgcn = cursorWindowArray;
        this.zzcc = n2;
        this.zzgco = bundle;
    }

    private DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.zzehz = 1;
        this.zzgcl = (String[])zzbq.checkNotNull((Object)stringArray);
        this.zzgcn = (CursorWindow[])zzbq.checkNotNull((Object)cursorWindowArray);
        this.zzcc = n;
        this.zzgco = bundle;
        this.zzali();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zzgcl, DataHolder.zza(zza2, -1), n, null);
    }

    public final void zzali() {
        int n;
        this.zzgcm = new Bundle();
        for (n = 0; n < this.zzgcl.length; ++n) {
            this.zzgcm.putInt(this.zzgcl[n], n);
        }
        this.zzgcp = new int[this.zzgcn.length];
        n = 0;
        for (int i = 0; i < this.zzgcn.length; ++i) {
            this.zzgcp[i] = n;
            int n2 = this.zzgcn[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzgcn[i].getNumRows() - n3;
        }
        this.zzgcq = n;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataHolder dataHolder = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String[])dataHolder.zzgcl, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable[])dataHolder.zzgcn, (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)dataHolder.zzcc);
        zzbgo.zza((Parcel)parcel2, (int)4, (Bundle)dataHolder.zzgco, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)1000, (int)dataHolder.zzehz);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
        if ((n & 1) != 0) {
            this.close();
        }
    }

    public final int getStatusCode() {
        return this.zzcc;
    }

    @Hide
    public final Bundle zzahs() {
        return this.zzgco;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzgcl.length == 0) {
            return new CursorWindow[0];
        }
        ArrayList arrayList = zza2.zzgct;
        int n2 = arrayList.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList2 = new ArrayList<CursorWindow>();
        arrayList2.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzgcl.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzgcl.length);
                    arrayList2.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList2.remove(cursorWindow);
                        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
                    }
                }
                Map map = (Map)arrayList.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zzgcl.length && bl2; ++n3) {
                    String string2 = zza2.zzgcl[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzgcl.length);
                    arrayList2.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList2.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList2.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
    }

    private final void zzh(String string2, int n) {
        if (this.zzgcm == null || !this.zzgcm.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzgcq) {
            throw new CursorIndexOutOfBoundsException(n, this.zzgcq);
        }
    }

    public final boolean zzgj(String string2) {
        return this.zzgcm.containsKey(string2);
    }

    public final long zzb(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzgcn[n2].getLong(n, this.zzgcm.getInt(string2));
    }

    public final int zzc(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzgcn[n2].getInt(n, this.zzgcm.getInt(string2));
    }

    public final String zzd(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzgcn[n2].getString(n, this.zzgcm.getInt(string2));
    }

    public final boolean zze(String string2, int n, int n2) {
        this.zzh(string2, n);
        return Long.valueOf(this.zzgcn[n2].getLong(n, this.zzgcm.getInt(string2))) == 1L;
    }

    public final float zzf(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzgcn[n2].getFloat(n, this.zzgcm.getInt(string2));
    }

    public final byte[] zzg(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzgcn[n2].getBlob(n, this.zzgcm.getInt(string2));
    }

    public final void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzh(string2, n);
        this.zzgcn[n2].copyStringToBuffer(n, this.zzgcm.getInt(string2), charArrayBuffer);
    }

    public final boolean zzh(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzgcn[n2].isNull(n, this.zzgcm.getInt(string2));
    }

    public final int getCount() {
        return this.zzgcq;
    }

    @Hide
    public final int zzby(int n) {
        int n2;
        zzbq.checkState((n >= 0 && n < this.zzgcq ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zzgcp.length; ++n2) {
            if (n >= this.zzgcp[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzgcp.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzgcn.length; ++i) {
                    this.zzgcn[i].close();
                }
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.zzgcr && this.zzgcn.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = this.toString();
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public static zza zzb(String[] stringArray) {
        return new zza(stringArray, null, null);
    }

    public static DataHolder zzbz(int n) {
        int n2 = n;
        return new DataHolder(zzgcs, n2, null);
    }

    /* synthetic */ DataHolder(zza zza2, int n, Bundle bundle, zze zze2) {
        this(zza2, 0, null);
    }

    public static final class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzgcl;
        private final ArrayList<HashMap<String, Object>> zzgct;
        private final String zzgcu;
        private final HashMap<Object, Integer> zzgcv;
        private boolean zzgcw;
        private String zzgcx;

        private zza(String[] stringArray, String string2) {
            this.zzgcl = (String[])zzbq.checkNotNull((Object)stringArray);
            this.zzgct = new ArrayList();
            this.zzgcu = string2;
            this.zzgcv = new HashMap();
            this.zzgcw = false;
            this.zzgcx = null;
        }

        public zza zza(HashMap<String, Object> hashMap) {
            int n;
            int n2;
            zzc.zzv(hashMap);
            HashMap<String, Object> hashMap2 = hashMap;
            zza zza2 = this;
            if (zza2.zzgcu == null) {
                n2 = -1;
            } else {
                Object object = hashMap2.get(zza2.zzgcu);
                if (object == null) {
                    n2 = -1;
                } else {
                    Integer n3 = zza2.zzgcv.get(object);
                    if (n3 == null) {
                        zza2.zzgcv.put(object, zza2.zzgct.size());
                        n2 = -1;
                    } else {
                        n2 = n = n3.intValue();
                    }
                }
            }
            if (n2 == -1) {
                this.zzgct.add(hashMap);
            } else {
                this.zzgct.remove(n);
                this.zzgct.add(n, hashMap);
            }
            this.zzgcw = false;
            return this;
        }

        public zza zza(ContentValues contentValues) {
            zzc.zzv((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zza(hashMap);
        }

        public final DataHolder zzca(int n) {
            return new DataHolder(this, 0, null, null);
        }

        /* synthetic */ zza(String[] stringArray, String string2, zze zze2) {
            this(stringArray, null);
        }
    }
}

