/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.internal.zzq;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.auth.api.signin.zze;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zzbgl
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    @Hide
    public static final Scope zzemx = new Scope("profile");
    @Hide
    public static final Scope zzemy = new Scope("email");
    @Hide
    public static final Scope zzemz = new Scope("openid");
    @Hide
    public static final Scope SCOPE_GAMES_LITE = new Scope("https://www.googleapis.com/auth/games_lite");
    @Hide
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES_LITE, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zze();
    private int versionCode;
    private final ArrayList<Scope> zzena;
    private Account zzeho;
    private boolean zzela;
    private final boolean zzenb;
    private final boolean zzenc;
    private String zzelb;
    private String zzend;
    private ArrayList<zzo> zzene;
    private Map<Integer, zzo> zzenf;
    private static Comparator<Scope> zzeng = new zzd();

    @Hide
    @Nullable
    public static GoogleSignInOptions zzfb(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzo>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzo> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzx(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzo> map) {
        this.versionCode = n;
        this.zzena = arrayList;
        this.zzeho = account;
        this.zzela = bl;
        this.zzenb = bl2;
        this.zzenc = bl3;
        this.zzelb = string2;
        this.zzend = string3;
        this.zzene = new ArrayList<zzo>(map.values());
        this.zzenf = map;
    }

    @Hide
    public final ArrayList<Scope> zzaci() {
        return new ArrayList<Scope>(this.zzena);
    }

    public Scope[] getScopeArray() {
        return this.zzena.toArray(new Scope[this.zzena.size()]);
    }

    @Hide
    public final Account getAccount() {
        return this.zzeho;
    }

    @Hide
    public final boolean isIdTokenRequested() {
        return this.zzela;
    }

    @Hide
    public final boolean zzacj() {
        return this.zzenb;
    }

    @Hide
    public final String getServerClientId() {
        return this.zzelb;
    }

    private static Map<Integer, zzo> zzx(@Nullable List<zzo> list) {
        HashMap<Integer, zzo> hashMap = new HashMap<Integer, zzo>();
        if (list == null) {
            return hashMap;
        }
        for (zzo zzo2 : list) {
            hashMap.put(zzo2.getType(), zzo2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        zzbgo.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzaci(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzeho, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzela);
        zzbgo.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzenb);
        zzbgo.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzenc);
        zzbgo.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzelb, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzend, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzene, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzene.size() > 0 || googleSignInOptions.zzene.size() > 0) {
                return false;
            }
            if (this.zzena.size() != googleSignInOptions.zzaci().size() || !this.zzena.containsAll(googleSignInOptions.zzaci())) {
                return false;
            }
            return (this.zzeho == null ? googleSignInOptions.zzeho == null : this.zzeho.equals((Object)googleSignInOptions.zzeho)) && (TextUtils.isEmpty((CharSequence)this.zzelb) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzelb) : this.zzelb.equals(googleSignInOptions.zzelb)) && this.zzenc == googleSignInOptions.zzenc && this.zzela == googleSignInOptions.zzela && this.zzenb == googleSignInOptions.zzenb;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzena;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzaie());
        }
        Collections.sort(arrayList);
        return new zzq().zzs(arrayList).zzs(this.zzeho).zzs(this.zzelb).zzav(this.zzenc).zzav(this.zzela).zzav(this.zzenb).zzacr();
    }

    @Hide
    public final String zzack() {
        return this.toJsonObject().toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzena, zzeng);
            ArrayList<Scope> arrayList = this.zzena;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzaie());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzeho != null) {
                jSONObject.put("accountName", (Object)this.zzeho.name);
            }
            jSONObject.put("idTokenRequested", this.zzela);
            jSONObject.put("forceCodeForRefreshToken", this.zzenc);
            jSONObject.put("serverAuthRequested", this.zzenb);
            if (!TextUtils.isEmpty((CharSequence)this.zzelb)) {
                jSONObject.put("serverClientId", (Object)this.zzelb);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzend)) {
                jSONObject.put("hostedDomain", (Object)this.zzend);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzd zzd2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzenh = new HashSet<Scope>();
        private boolean zzenb;
        private boolean zzenc;
        private boolean zzela;
        private String zzelb;
        private Account zzeho;
        private String zzend;
        private Map<Integer, zzo> zzeni = new HashMap<Integer, zzo>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbq.checkNotNull((Object)googleSignInOptions);
            this.zzenh = new HashSet<Scope>(googleSignInOptions.zzena);
            this.zzenb = googleSignInOptions.zzenb;
            this.zzenc = googleSignInOptions.zzenc;
            this.zzela = googleSignInOptions.zzela;
            this.zzelb = googleSignInOptions.zzelb;
            this.zzeho = googleSignInOptions.zzeho;
            this.zzend = googleSignInOptions.zzend;
            this.zzeni = GoogleSignInOptions.zzx(googleSignInOptions.zzene);
        }

        public final Builder requestId() {
            this.zzenh.add(zzemz);
            return this;
        }

        public final Builder requestEmail() {
            this.zzenh.add(zzemy);
            return this;
        }

        public final Builder requestProfile() {
            this.zzenh.add(zzemx);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzenh.add(scope);
            this.zzenh.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzela = true;
            this.zzelb = this.zzfc(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzenb = true;
            this.zzelb = this.zzfc(string2);
            this.zzenc = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzeho = new Account(zzbq.zzgv((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzend = zzbq.zzgv((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzeni.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            if (googleSignInOptionsExtension.getImpliedScopes() != null) {
                this.zzenh.addAll(googleSignInOptionsExtension.getImpliedScopes());
            }
            this.zzeni.put(googleSignInOptionsExtension.getExtensionType(), new zzo(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzenh.contains(SCOPE_GAMES) && this.zzenh.contains(SCOPE_GAMES_LITE)) {
                this.zzenh.remove(SCOPE_GAMES_LITE);
            }
            if (this.zzela && (this.zzeho == null || !this.zzenh.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzenh), this.zzeho, this.zzela, this.zzenb, this.zzenc, this.zzelb, this.zzend, this.zzeni, null);
        }

        private final String zzfc(String string2) {
            zzbq.zzgv((String)string2);
            zzbq.checkArgument((this.zzelb == null || this.zzelb.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

