/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.data.zzf;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Hide
@KeepName
public final class DataHolder
extends zzbgl
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zzf();
    private int zzb;
    private final String[] zzc;
    private Bundle zzd;
    private final CursorWindow[] zze;
    private final int zzf;
    private final Bundle zzg;
    private int[] zzh;
    int zza;
    private boolean zzi = false;
    private boolean zzj = true;
    private static final zza zzk = new zze(new String[0], null);

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.zzb = n;
        this.zzc = stringArray;
        this.zze = cursorWindowArray;
        this.zzf = n2;
        this.zzg = bundle;
    }

    private DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.zzb = 1;
        this.zzc = (String[])zzbq.zza((Object)stringArray);
        this.zze = (CursorWindow[])zzbq.zza((Object)cursorWindowArray);
        this.zzf = n;
        this.zzg = bundle;
        this.zza();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zza, DataHolder.zza(zza2, -1), n, null);
    }

    public final void zza() {
        int n;
        this.zzd = new Bundle();
        for (n = 0; n < this.zzc.length; ++n) {
            this.zzd.putInt(this.zzc[n], n);
        }
        this.zzh = new int[this.zze.length];
        n = 0;
        for (int i = 0; i < this.zze.length; ++i) {
            this.zzh[i] = n;
            int n2 = this.zze[i].getStartPosition();
            int n3 = n - n2;
            n += this.zze[i].getNumRows() - n3;
        }
        this.zza = n;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataHolder dataHolder = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String[])dataHolder.zzc, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable[])dataHolder.zze, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (int)dataHolder.zzf);
        zzbgo.zza((Parcel)parcel2, (int)4, (Bundle)dataHolder.zzg, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)1000, (int)dataHolder.zzb);
        zzbgo.zza((Parcel)parcel2, (int)n2);
        if ((n & 1) != 0) {
            this.close();
        }
    }

    public final int zzb() {
        return this.zzf;
    }

    @Hide
    public final Bundle zzc() {
        return this.zzg;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zza.length == 0) {
            return new CursorWindow[0];
        }
        ArrayList arrayList = zza2.zzb;
        int n2 = arrayList.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList2 = new ArrayList<CursorWindow>();
        arrayList2.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zza.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zza.length);
                    arrayList2.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList2.remove(cursorWindow);
                        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
                    }
                }
                Map map = (Map)arrayList.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zza.length && bl2; ++n3) {
                    String string2 = zza2.zza[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zza.length);
                    arrayList2.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList2.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList2.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
    }

    private final void zza(String string2, int n) {
        if (this.zzd == null || !this.zzd.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.zze()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zza) {
            throw new CursorIndexOutOfBoundsException(n, this.zza);
        }
    }

    public final boolean zza(String string2) {
        return this.zzd.containsKey(string2);
    }

    public final long zza(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zze[n2].getLong(n, this.zzd.getInt(string2));
    }

    public final int zzb(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zze[n2].getInt(n, this.zzd.getInt(string2));
    }

    public final String zzc(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zze[n2].getString(n, this.zzd.getInt(string2));
    }

    public final boolean zzd(String string2, int n, int n2) {
        this.zza(string2, n);
        return Long.valueOf(this.zze[n2].getLong(n, this.zzd.getInt(string2))) == 1L;
    }

    public final float zze(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zze[n2].getFloat(n, this.zzd.getInt(string2));
    }

    public final byte[] zzf(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zze[n2].getBlob(n, this.zzd.getInt(string2));
    }

    public final void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zza(string2, n);
        this.zze[n2].copyStringToBuffer(n, this.zzd.getInt(string2), charArrayBuffer);
    }

    public final boolean zzg(String string2, int n, int n2) {
        this.zza(string2, n);
        return this.zze[n2].isNull(n, this.zzd.getInt(string2));
    }

    public final int zzd() {
        return this.zza;
    }

    @Hide
    public final int zza(int n) {
        int n2;
        zzbq.zza((n >= 0 && n < this.zza ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zzh.length; ++n2) {
            if (n >= this.zzh[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzh.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zze() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.zzi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.zzi) {
                this.zzi = true;
                for (int i = 0; i < this.zze.length; ++i) {
                    this.zze[i].close();
                }
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.zzj && this.zze.length > 0 && !this.zze()) {
                this.close();
                String string2 = this.toString();
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public static zza zza(String[] stringArray) {
        return new zza(stringArray, null, null);
    }

    public static DataHolder zzb(int n) {
        int n2 = n;
        return new DataHolder(zzk, n2, null);
    }

    /* synthetic */ DataHolder(zza zza2, int n, Bundle bundle, zze zze2) {
        this(zza2, 0, null);
    }

    public static final class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zza;
        private final ArrayList<HashMap<String, Object>> zzb;
        private final String zzc;
        private final HashMap<Object, Integer> zzd;
        private boolean zze;
        private String zzf;

        private zza(String[] stringArray, String string2) {
            this.zza = (String[])zzbq.zza((Object)stringArray);
            this.zzb = new ArrayList();
            this.zzc = string2;
            this.zzd = new HashMap();
            this.zze = false;
            this.zzf = null;
        }

        public zza zza(HashMap<String, Object> hashMap) {
            int n;
            int n2;
            com.google.android.gms.common.internal.zzc.zza(hashMap);
            HashMap<String, Object> hashMap2 = hashMap;
            zza zza2 = this;
            if (zza2.zzc == null) {
                n2 = -1;
            } else {
                Object object = hashMap2.get(zza2.zzc);
                if (object == null) {
                    n2 = -1;
                } else {
                    Integer n3 = zza2.zzd.get(object);
                    if (n3 == null) {
                        zza2.zzd.put(object, zza2.zzb.size());
                        n2 = -1;
                    } else {
                        n2 = n = n3.intValue();
                    }
                }
            }
            if (n2 == -1) {
                this.zzb.add(hashMap);
            } else {
                this.zzb.remove(n);
                this.zzb.add(n, hashMap);
            }
            this.zze = false;
            return this;
        }

        public zza zza(ContentValues contentValues) {
            com.google.android.gms.common.internal.zzc.zza((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zza(hashMap);
        }

        public final DataHolder zza(int n) {
            return new DataHolder(this, 0, null, null);
        }

        /* synthetic */ zza(String[] stringArray, String string2, zze zze2) {
            this(stringArray, null);
        }
    }
}

